/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.wizards.pages;

import ghidradev.ghidraprojectcreator.utils.PackageFragmentRootSelectionDialog;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateGhidraScriptWizardPage
extends WizardPage {
    private IPackageFragmentRoot selecttion;
    private Text scriptFolderText;
    private Button scriptFolderButton;
    private Text scriptNameText;
    private Button javaRadioButton;
    private Button pythonRadioButton;
    private Text scriptAuthorText;
    private Text scriptCategoryText;
    private Text scriptDescriptionText;

    public CreateGhidraScriptWizardPage() {
        super("CreateGhidraScriptWizardPage");
        this.setTitle("Create Ghidra Script");
        this.setDescription("Create a new Ghidra script.");
    }

    public CreateGhidraScriptWizardPage(IPackageFragmentRoot selectedPackageFragmentRoot) {
        this();
        this.selecttion = selectedPackageFragmentRoot;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Label sourceFolderLabel = new Label(container, 0);
        sourceFolderLabel.setText("Script folder:");
        this.scriptFolderText = new Text(container, 2052);
        this.scriptFolderText.setLayoutData((Object)new GridData(768));
        this.scriptFolderText.setEditable(false);
        this.scriptFolderText.setText(this.selecttion != null ? this.selecttion.getPath().toString() : "");
        this.scriptFolderText.addModifyListener(evt -> this.validate());
        this.scriptFolderButton = new Button(container, 524288);
        this.scriptFolderButton.setText("...");
        this.scriptFolderButton.addListener(13, evt -> {
            IFolder scriptFolder;
            PackageFragmentRootSelectionDialog selectionDialog = new PackageFragmentRootSelectionDialog(this.getShell(), "Script Folder Selection", "Choose a script folder:", "Select script folder");
            if (selectionDialog.open() == 0 && (scriptFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(selectionDialog.getPackageFragmentRoot().getPath())) != null) {
                this.scriptFolderText.setText(scriptFolder.getFullPath().toString());
            }
        });
        Label scriptNameLabel = new Label(container, 0);
        scriptNameLabel.setText("Script name:");
        this.scriptNameText = new Text(container, 2052);
        this.scriptNameText.setLayoutData((Object)new GridData(768));
        this.scriptNameText.addModifyListener(evt -> this.validate());
        new Label(container, 0).setText("");
        Label scriptTypeLabel = new Label(container, 0);
        scriptTypeLabel.setText("Script type:");
        Group scriptTypeGroup = new Group(container, 64);
        scriptTypeGroup.setLayout((Layout)new RowLayout(256));
        this.javaRadioButton = new Button((Composite)scriptTypeGroup, 16);
        this.javaRadioButton.setSelection(true);
        this.javaRadioButton.setText("Java");
        this.pythonRadioButton = new Button((Composite)scriptTypeGroup, 16);
        this.pythonRadioButton.setSelection(false);
        this.pythonRadioButton.setText("Python");
        new Label(container, 0).setText("");
        Label scriptAuthorLabel = new Label(container, 0);
        scriptAuthorLabel.setText("Script author:");
        this.scriptAuthorText = new Text(container, 2052);
        this.scriptAuthorText.setLayoutData((Object)new GridData(768));
        this.scriptAuthorText.addModifyListener(evt -> this.validate());
        new Label(container, 0).setText("");
        Label scriptCategoryLabel = new Label(container, 0);
        scriptCategoryLabel.setText("Script category:");
        this.scriptCategoryText = new Text(container, 2052);
        this.scriptCategoryText.setLayoutData((Object)new GridData(768));
        this.scriptCategoryText.addModifyListener(evt -> this.validate());
        new Label(container, 0).setText("");
        Label scriptDescriptionLabel = new Label(container, 0);
        scriptDescriptionLabel.setText("Script description:");
        this.scriptDescriptionText = new Text(container, 2626);
        this.scriptDescriptionText.setLayoutData((Object)new GridData(1808));
        this.scriptDescriptionText.addModifyListener(evt -> this.validate());
        new Label(container, 0).setText("");
        this.validate();
        this.setControl((Control)container);
    }

    public IFolder getScriptFolder() {
        if (!this.scriptFolderText.getText().isEmpty()) {
            try {
                Path path = new Path(this.scriptFolderText.getText());
                return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }

    public String getScriptName() {
        return this.scriptNameText.getText() + (this.javaRadioButton.getSelection() ? ".java" : ".py");
    }

    public String getScriptAuthor() {
        return this.scriptAuthorText.getText();
    }

    public String getScriptCategory() {
        return this.scriptCategoryText.getText();
    }

    public String[] getScriptDescription() {
        return this.scriptDescriptionText.getText().split("\\n");
    }

    private void validate() {
        String message = null;
        IFolder scriptFolder = this.getScriptFolder();
        String scriptName = this.scriptNameText.getText();
        if (scriptFolder == null) {
            message = "Script folder must be specified";
        } else if (!scriptFolder.exists()) {
            message = "Script folder does not exist";
        } else if (scriptName.isEmpty()) {
            message = "Script name must be specified";
        } else if ("0123456789 `~!@#$%^&*()-+=[]{}\\|;:'\"<>,./?".chars().anyMatch(ch -> scriptName.charAt(0) == ch)) {
            message = "Script name cannot start with an invalid character:\n 0123456789 `~!@#$%^&*()-+=[]{}\\|;:'\"<>,./?";
        } else if (" `~!@#$%^&*()-+=[]{}\\|;:'\"<>,./?".chars().anyMatch(ch -> scriptName.indexOf(ch) != -1)) {
            message = "Script name cannot contain invalid characters:\n  `~!@#$%^&*()-+=[]{}\\|;:'\"<>,./?";
        } else if (scriptFolder.getFile(this.getScriptName()).exists()) {
            message = "Script already exists";
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

