/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.wizards.pages;

import ghidradev.EclipseMessageUtils;
import ghidradev.ghidraprojectcreator.utils.PyDevUtils;
import ghidradev.ghidraprojectcreator.wizards.pages.ChooseGhidraInstallationWizardPage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.List;
import javax.naming.OperationNotSupportedException;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class EnablePythonWizardPage
extends WizardPage {
    private ChooseGhidraInstallationWizardPage ghidraInstallationPage;
    private Button enablePythonCheckboxButton;
    private Combo jythonCombo;
    private Button addJythonButton;

    public EnablePythonWizardPage(ChooseGhidraInstallationWizardPage ghidraInstallationPage) {
        super("EnablePythonWizardPage");
        this.setTitle("Python Support");
        this.setDescription("Enable Python support for your project (requires PyDev plugin).");
        this.ghidraInstallationPage = ghidraInstallationPage;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        this.enablePythonCheckboxButton = new Button(container, 32);
        this.enablePythonCheckboxButton.setText("Enable Python");
        this.enablePythonCheckboxButton.setToolTipText("Enables Python support using the PyDev Eclipse plugin.  Requires PyDev version 6.3.1 - 9.3.0");
        this.enablePythonCheckboxButton.setSelection(PyDevUtils.isSupportedPyDevInstalled());
        this.enablePythonCheckboxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                EnablePythonWizardPage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                EnablePythonWizardPage.this.validate();
            }
        });
        new Label(container, 0).setText("");
        new Label(container, 0).setText("");
        Label jythonLabel = new Label(container, 0);
        jythonLabel.setText("Jython interpreter:");
        this.jythonCombo = new Combo(container, 12);
        this.jythonCombo.setLayoutData((Object)new GridData(768));
        this.jythonCombo.setToolTipText("The wizard requires a Jython interpreter to be selected.  Click the + button to add or manage Jython interpreters.");
        this.populateJythonCombo();
        this.jythonCombo.addModifyListener(evt -> this.validate());
        this.addJythonButton = new Button(container, 524288);
        this.addJythonButton.setText("+");
        this.addJythonButton.setToolTipText("Adds/manages Jython interpreters.");
        this.addJythonButton.addListener(13, evt -> {
            try {
                if (PyDevUtils.getJython27InterpreterNames().isEmpty()) {
                    File ghidraDir = this.ghidraInstallationPage.getGhidraInstallDir();
                    File jythonFile = this.findJythonInterpreter(ghidraDir);
                    File jythonLib = this.findJythonLibrary(ghidraDir);
                    if (jythonFile != null && EclipseMessageUtils.showQuestionDialog("Jython Found", "A Jython interpreter was found bundled with Ghidra. Would you like to use it as your interpreter?")) {
                        PyDevUtils.addJythonInterpreter("jython_" + ghidraDir.getName(), jythonFile, jythonLib);
                        this.populateJythonCombo();
                        this.validate();
                        return;
                    }
                }
            }
            catch (OperationNotSupportedException operationNotSupportedException) {}
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)PyDevUtils.getJythonPreferencePageId(), null, null);
            dialog.open();
            this.populateJythonCombo();
            this.validate();
        });
        this.validate();
        this.setControl((Control)container);
    }

    public boolean shouldEnablePython() {
        return this.enablePythonCheckboxButton.getSelection();
    }

    public String getJythonInterpreterName() {
        if (this.enablePythonCheckboxButton.getSelection()) {
            return this.jythonCombo.getText();
        }
        return null;
    }

    private void validate() {
        boolean comboEnabled;
        String message = null;
        boolean pyDevInstalled = PyDevUtils.isSupportedPyDevInstalled();
        boolean pyDevEnabled = this.enablePythonCheckboxButton.getSelection();
        boolean bl = comboEnabled = pyDevInstalled && pyDevEnabled;
        if (pyDevEnabled) {
            if (!pyDevInstalled) {
                message = "PyDev version 6.3.1 - 9.3.0 is not installed.";
            } else {
                try {
                    List<String> interpreters = PyDevUtils.getJython27InterpreterNames();
                    if (interpreters.isEmpty()) {
                        message = "No Jython interpreters found.  Click the + button to add one.";
                    }
                }
                catch (OperationNotSupportedException operationNotSupportedException) {
                    message = "PyDev version is not supported.";
                    comboEnabled = false;
                }
            }
        }
        this.jythonCombo.setEnabled(comboEnabled);
        this.addJythonButton.setEnabled(comboEnabled);
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void populateJythonCombo() {
        this.jythonCombo.removeAll();
        try {
            for (String jythonName : PyDevUtils.getJython27InterpreterNames()) {
                this.jythonCombo.add(jythonName);
            }
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        if (this.jythonCombo.getItemCount() > 0) {
            this.jythonCombo.select(0);
        }
    }

    private File findJythonInterpreter(File ghidraInstallDir) {
        if (ghidraInstallDir == null || !ghidraInstallDir.isDirectory()) {
            return null;
        }
        try {
            return Files.find(ghidraInstallDir.toPath(), 10, (path, attrs) -> {
                String name = path.getFileName().toString();
                return attrs.isRegularFile() && name.startsWith("jython") && name.endsWith(".jar");
            }, new FileVisitOption[0]).map(p -> p.toFile()).findFirst().orElse(null);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private File findJythonLibrary(File ghidraInstallDir) {
        if (ghidraInstallDir == null || !ghidraInstallDir.isDirectory()) {
            return null;
        }
        try {
            return Files.find(ghidraInstallDir.toPath(), 10, (path, attrs) -> {
                String name = path.getFileName().toString();
                String parentName = path.getParent().getFileName().toString();
                return attrs.isDirectory() && name.equals("Lib") && parentName.startsWith("jython");
            }, new FileVisitOption[0]).map(p -> p.toFile()).findFirst().orElse(null);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

