/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidrascripteditor;

import ghidradev.EclipseMessageUtils;
import ghidradev.ghidraprojectcreator.utils.GhidraProjectUtils;
import ghidradev.ghidraprojectcreator.wizards.CreateGhidraScriptProjectWizard;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.ide.IDE;

public class OpenFileRunnable
implements Runnable {
    private String filePath;

    public OpenFileRunnable(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public void run() {
        List<IFile> projectFiles = this.findMatchingFiles(this.filePath);
        IFile[] filesToOpen = this.maybePromptUserForFilesToOpen(projectFiles);
        this.openFiles(filesToOpen);
    }

    private void openFiles(IFile[] userFileChoices) {
        if (userFileChoices == null) {
            return;
        }
        IFile[] iFileArray = userFileChoices;
        int n = userFileChoices.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            this.openFile(file);
            ++n2;
        }
    }

    private void openFile(IFile file) {
        IWorkbenchPage page = EclipseMessageUtils.getWorkbenchPage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)file);
        }
        catch (PartInitException partInitException) {
            EclipseMessageUtils.showErrorDialog("Unable to Open Script", "Couldn't open editor for " + this.filePath);
        }
        page.getWorkbenchWindow().getShell().forceActive();
    }

    private IFile[] maybePromptUserForFilesToOpen(List<IFile> projectFiles) {
        if (projectFiles.size() == 0) {
            return null;
        }
        if (projectFiles.size() == 1) {
            return new IFile[]{projectFiles.get(0)};
        }
        for (IFile iFile : projectFiles) {
            IProject project = iFile.getProject();
            String projectName = project.getName();
            if (!projectName.toLowerCase().endsWith("scripts")) continue;
            return new IFile[]{projectFiles.get(0)};
        }
        IWorkbenchPage page = EclipseMessageUtils.getWorkbenchPage();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(page.getWorkbenchWindow().getShell(), (ILabelProvider)new LabelProvider());
        dialog.setTitle("Choose a File");
        List<DisplayableIFile> displayableFiles = this.formatStrings(projectFiles);
        dialog.setMultipleSelection(true);
        dialog.setElements((Object[])displayableFiles.toArray(new DisplayableIFile[displayableFiles.size()]));
        dialog.setMessage("Select a file to open");
        Dimension size = this.calculatePreferredSizeInCharacters(displayableFiles);
        dialog.setSize(size.width, size.height);
        dialog.open();
        Object[] results = dialog.getResult();
        IFile[] resultFiles = new IFile[results.length];
        int i = 0;
        while (i < results.length) {
            resultFiles[i] = ((DisplayableIFile)results[i]).getFile();
            ++i;
        }
        return resultFiles;
    }

    private List<IFile> findMatchingFiles(String path) {
        Collection<IJavaProject> javaProjects = GhidraProjectUtils.getGhidraProjects();
        List<IFile> projectFiles = this.findMatchingFilesInProjects(path, javaProjects);
        if (projectFiles.isEmpty()) {
            try {
                for (IJavaProject javaProject : javaProjects) {
                    javaProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException coreException) {
                EclipseMessageUtils.showErrorDialog("Unable to Open Script", "Unexpected Exception refreshing project");
                return new ArrayList<IFile>();
            }
        }
        if ((projectFiles = this.findMatchingFilesInProjects(path, javaProjects)).isEmpty()) {
            boolean createProject = EclipseMessageUtils.showConfirmDialog("Unable to Open Script", "File does not exist in any Eclipse project in your workspace.\n\nWould you like to create a new Ghidra Scripting project?");
            if (createProject) {
                CreateGhidraScriptProjectWizard wizard = new CreateGhidraScriptProjectWizard();
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection());
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0) {
                    return this.findMatchingFilesInProjects(path, GhidraProjectUtils.getGhidraProjects());
                }
            }
            return new ArrayList<IFile>();
        }
        return projectFiles;
    }

    private Dimension calculatePreferredSizeInCharacters(List<DisplayableIFile> files) {
        int width = 0;
        int height = 10;
        for (DisplayableIFile file : files) {
            String displayString = file.getDisplayString();
            width = Math.max(width, displayString.length());
        }
        width = Math.min(width + 7, 100);
        height = Math.min(height, files.size() + 3);
        return new Dimension(width, height);
    }

    private List<IFile> findMatchingFilesInProjects(String pathString, Collection<IJavaProject> javaProjects) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (IJavaProject javaProject : javaProjects) {
            IProject project = javaProject.getProject();
            if (!project.isOpen()) continue;
            try {
                IPath path = this.findPathFromFolder(pathString, (IResource)project);
                if (path == null) continue;
                IFile file = project.getFile(path);
                files.add(file);
            }
            catch (CoreException e) {
                EclipseMessageUtils.error("Unexpected exception accessing project members", e);
            }
        }
        return files;
    }

    private IPath findPathFromFolder(String pathString, IResource resource) throws CoreException {
        IResource[] members;
        if (!(resource instanceof IContainer)) {
            return null;
        }
        IContainer container = (IContainer)resource;
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            IPath location = member.getLocation();
            File fileForPath = new File(pathString);
            File fileForLocation = location.toFile();
            if (fileForLocation.equals(fileForPath)) {
                return member.getProjectRelativePath();
            }
            IPath pathFromFolder = this.findPathFromFolder(pathString, member);
            if (pathFromFolder != null) {
                return pathFromFolder;
            }
            ++n2;
        }
        return null;
    }

    private List<DisplayableIFile> formatStrings(List<IFile> projectFiles) {
        ArrayList<DisplayableIFile> list = new ArrayList<DisplayableIFile>();
        for (IFile file : projectFiles) {
            list.add(new DisplayableIFile(file));
        }
        return list;
    }

    private class DisplayableIFile {
        private final IFile file;
        private final String displayString;

        private DisplayableIFile(IFile file) {
            this.file = file;
            Object format = "";
            String[] strings = file.toString().split("/");
            int i = 1;
            while (i < strings.length - 1) {
                format = (String)format + strings[i] + "/";
                ++i;
            }
            this.displayString = ((String)format).substring(0, ((String)format).length() - 1) + " - " + strings[strings.length - 1];
        }

        IFile getFile() {
            return this.file;
        }

        String getDisplayString() {
            return this.displayString;
        }

        public String toString() {
            return this.getDisplayString();
        }
    }
}

