/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidrascripteditor;

import ghidradev.Activator;
import ghidradev.EclipseMessageUtils;
import ghidradev.ghidrascripteditor.SocketSetupRunnable;
import ghidradev.ghidrascripteditor.preferences.GhidraScriptEditorPreferences;
import java.io.IOException;
import java.net.ServerSocket;

public class ScriptEditorInitializer {
    private static ServerSocket serverSocket;

    public static void init(boolean firstTimeConsent) {
        if (firstTimeConsent) {
            GhidraScriptEditorPreferences.setScriptEditorEnabled(true);
        }
        ScriptEditorInitializer.listen(GhidraScriptEditorPreferences.getScriptEditorPort());
    }

    private static void listen(int port) {
        if (!GhidraScriptEditorPreferences.isScriptEditorEnabled()) {
            EclipseMessageUtils.info("GhidraDev Script Editor port listening is disabled in preferences.");
            return;
        }
        if (port == -1) {
            EclipseMessageUtils.info("GhidraDev Script Editor port listening is disabled, port not set in preferences.");
            return;
        }
        try {
            serverSocket = new ServerSocket(port);
            EclipseMessageUtils.info("GhidraDev Script Editor is listening on port " + port);
            Activator.getDefault().registerCloseable(serverSocket);
        }
        catch (IOException iOException) {
            EclipseMessageUtils.showErrorDialog("GhidraDev Script Editor", "Failed to listen for connections on port " + port + ".  The Script Editor features will be disabled until a valid port is selected in preferences.");
            return;
        }
        new Thread(new SocketSetupRunnable(serverSocket)).start();
    }

    public static void notifyPreferencesChanged(boolean enabledWasChanged, boolean portWasChanged) {
        if (!enabledWasChanged && !portWasChanged) {
            return;
        }
        try {
            if (serverSocket != null) {
                serverSocket.close();
                Activator.getDefault().unregisterCloseable(serverSocket);
                serverSocket = null;
            }
        }
        catch (IOException iOException) {}
        ScriptEditorInitializer.listen(GhidraScriptEditorPreferences.getScriptEditorPort());
    }
}

