/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidrascripteditor.preferences;

import ghidradev.Activator;
import ghidradev.ghidrascripteditor.ScriptEditorInitializer;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GhidraScriptEditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor enabledField;
    private StringFieldEditor portField;
    private String previousEnabledString = null;
    private String currentEnabledString = null;
    private String previousPortString = null;
    private String currentPortString = null;

    public GhidraScriptEditorPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void createFieldEditors() {
        this.enabledField = new BooleanFieldEditor("ghidradev.scriptEditorEnabled", "Enabled", this.getFieldEditorParent());
        this.portField = new StringFieldEditor("ghidradev.scriptEditorPortNumber", "Port:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.enabledField);
        this.addField((FieldEditor)this.portField);
    }

    public void checkState() {
        super.checkState();
        if (!this.isValid()) {
            return;
        }
        String portValue = this.portField.getStringValue();
        if (!portValue.isEmpty()) {
            try {
                int portNumber = Integer.parseInt(portValue);
                if (portNumber < 1024 || portNumber > 65535) {
                    this.setErrorMessage("Port must be between 1024 and 65535.");
                    this.setValid(false);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("Port must be an integer.");
                this.setValid(false);
                return;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value")) {
            this.checkState();
        }
        if (event.getSource() == this.enabledField) {
            if (this.previousEnabledString == null) {
                this.previousEnabledString = event.getOldValue().toString();
            }
            this.currentEnabledString = event.getNewValue().toString();
        } else if (event.getSource() == this.portField) {
            if (this.previousPortString == null) {
                this.previousPortString = event.getOldValue().toString();
            }
            this.currentPortString = event.getNewValue().toString();
        }
    }

    public boolean performOk() {
        super.performOk();
        boolean enabledWasChanged = false;
        boolean portWasChanged = false;
        if (this.currentEnabledString != null && this.previousEnabledString != null && !this.currentEnabledString.equals(this.previousEnabledString)) {
            enabledWasChanged = true;
        }
        if (this.currentPortString != null && this.previousPortString != null && !this.currentPortString.equals(this.previousPortString)) {
            portWasChanged = true;
        }
        ScriptEditorInitializer.notifyPreferencesChanged(enabledWasChanged, portWasChanged);
        this.previousEnabledString = null;
        this.previousPortString = null;
        return true;
    }

    public boolean performCancel() {
        super.performCancel();
        this.previousEnabledString = null;
        this.previousPortString = null;
        return true;
    }
}

