/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidrasymbollookup;

import ghidradev.EclipseMessageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.IndexTypeInfo;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.browser.opentype.ElementSelectionDialog;
import org.eclipse.cdt.internal.ui.browser.opentype.OpenTypeMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

public class OpenDeclarations {
    private IProject project;
    private HashMap<String, IMarker> symbolMap;

    public OpenDeclarations(IProject project) {
        this.project = project;
        this.symbolMap = new HashMap();
    }

    public void setProject(IProject newProject) {
        this.project = newProject;
    }

    public boolean open(String filename, int lineNumber) {
        this.openSingleFileAtLineNumber(filename, lineNumber);
        return true;
    }

    public boolean open(String symbolName) {
        IIndex index = null;
        if (this.symbolMap.containsKey(symbolName)) {
            EclipseMessageUtils.info("Re-using editor for symbol: " + symbolName);
            this.openFileFromMap(symbolName);
            return true;
        }
        EclipseMessageUtils.info("Searching index for symbol: " + symbolName);
        ArrayList<IIndexName> indexNames = new ArrayList<IIndexName>();
        ICProject cProject = CoreModel.getDefault().getCModel().getCProject(this.project.getName());
        IIndexManager manager = CCorePlugin.getIndexManager();
        try {
            IIndexName name;
            int n;
            int n2;
            IIndexName[] iIndexNameArray;
            IIndexName[] names;
            IIndexBinding binding;
            index = manager.getIndex(cProject);
            this.waitForIndexInitialization(index);
            index.acquireReadLock();
            IIndexBinding[] bindings = index.findBindings(Pattern.compile(symbolName), false, IndexFilter.ALL, (IProgressMonitor)new NullProgressMonitor());
            EclipseMessageUtils.info("Found \"" + bindings.length + "\" bindings for symbol");
            IIndexBinding[] iIndexBindingArray = bindings;
            int n3 = bindings.length;
            int n4 = 0;
            while (n4 < n3) {
                binding = iIndexBindingArray[n4];
                iIndexNameArray = names = index.findNames((IBinding)binding, 2);
                n2 = names.length;
                n = 0;
                while (n < n2) {
                    name = iIndexNameArray[n];
                    indexNames.add(name);
                    ++n;
                }
                ++n4;
            }
            if (indexNames.size() == 0) {
                EclipseMessageUtils.info("Found no definitions, looking for declarations...");
                iIndexBindingArray = bindings;
                n3 = bindings.length;
                n4 = 0;
                while (n4 < n3) {
                    binding = iIndexBindingArray[n4];
                    iIndexNameArray = names = index.findNames((IBinding)binding, 1);
                    n2 = names.length;
                    n = 0;
                    while (n < n2) {
                        name = iIndexNameArray[n];
                        indexNames.add(name);
                        ++n;
                    }
                    ++n4;
                }
            }
            if (indexNames.size() == 1) {
                EclipseMessageUtils.info("Found single match - opening editor");
                this.openSingleFile(((IIndexName)indexNames.get(0)).getFileLocation(), symbolName);
                return true;
            }
            if (indexNames.size() > 1) {
                EclipseMessageUtils.info("Found multiple matches - showing dialog");
                this.openMultipleFileDialog(symbolName);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            EclipseMessageUtils.error("Unexpected exception searching C index: " + e.getMessage(), e);
            return false;
        }
        finally {
            if (index != null) {
                index.releaseReadLock();
            }
        }
    }

    private void waitForIndexInitialization(IIndex index) throws CoreException {
        int waitCount = 0;
        while (waitCount < 2) {
            ++waitCount;
            try {
                try {
                    index.acquireReadLock();
                    IIndexFile[] allFiles = index.getAllFiles();
                    if (allFiles.length == 0) {
                        EclipseMessageUtils.info("C Index is not yet initialized--waiting...");
                        index.releaseReadLock();
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    index.releaseReadLock();
                    continue;
                }
            }
            catch (Throwable throwable) {
                index.releaseReadLock();
                throw throwable;
            }
            index.releaseReadLock();
        }
    }

    private void openSingleFile(IASTFileLocation location, String functionName) {
        String projectName;
        String pathToFix = location.getFileName();
        int index = pathToFix.indexOf(projectName = this.project.getName());
        if (index == -1) {
            EclipseMessageUtils.error("Error opening the file containing " + pathToFix);
            return;
        }
        String relativePath = pathToFix.substring(index);
        IPath path = new Path(relativePath).removeFirstSegments(1);
        int offset = location.getNodeOffset();
        int length = location.getNodeLength();
        String fName = functionName;
        Display.getDefault().asyncExec(() -> {
            try {
                IFile file = this.project.getFile(path);
                IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
                marker.setAttribute("charStart", offset);
                marker.setAttribute("charEnd", offset + length);
                IDE.openEditor((IWorkbenchPage)EclipseMessageUtils.getWorkbenchPage(), (IMarker)marker);
                this.symbolMap.put(fName, marker);
                EclipseMessageUtils.getWorkbenchPage().getWorkbenchWindow().getShell().forceActive();
            }
            catch (CoreException e) {
                EclipseMessageUtils.error("Error opening the file containing " + fName, e);
            }
        });
    }

    private void openMultipleFileDialog(String functionName) {
        ElementSelectionDialog dialog = new ElementSelectionDialog(EclipseMessageUtils.getWorkbenchPage().getWorkbenchWindow().getShell());
        this.configureDialog(dialog, functionName);
        String fName = functionName;
        Display.getDefault().asyncExec(() -> {
            EclipseMessageUtils.getWorkbenchPage().getWorkbenchWindow().getShell().forceActive();
            dialog.open();
            Object[] results = dialog.getResult();
            if (results == null) {
                return;
            }
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                if (result instanceof IndexTypeInfo) {
                    ITypeReference reference = ((IndexTypeInfo)result).getResolvedReference();
                    IPath path = reference.getPath();
                    path = path.removeFirstSegments(1);
                    IFile file = this.project.getFile(path);
                    try {
                        IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
                        marker.setAttribute("charStart", reference.getOffset());
                        marker.setAttribute("charEnd", reference.getOffset() + reference.getLength());
                        IDE.openEditor((IWorkbenchPage)EclipseMessageUtils.getWorkbenchPage(), (IMarker)marker);
                        this.symbolMap.put(fName, marker);
                    }
                    catch (CoreException e) {
                        EclipseMessageUtils.error("Error opening file chosen from selection dialog", e);
                    }
                }
                ++n2;
            }
        });
    }

    private void openSingleFileAtLineNumber(String relativeFilename, int lineNumber) {
        IPath path = new Path(relativeFilename).removeFirstSegments(1);
        Display.getDefault().asyncExec(() -> {
            try {
                IFile file = this.project.getFile(path);
                IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
                marker.setAttribute("lineNumber", lineNumber);
                IDE.openEditor((IWorkbenchPage)EclipseMessageUtils.getWorkbenchPage(), (IMarker)marker);
                EclipseMessageUtils.getWorkbenchPage().getWorkbenchWindow().getShell().forceActive();
            }
            catch (CoreException e) {
                EclipseMessageUtils.error("Error opening the file containing at line " + lineNumber, e);
            }
        });
    }

    private void configureDialog(ElementSelectionDialog dialog, String functionName) {
        dialog.setTitle(OpenTypeMessages.OpenTypeDialog_title);
        dialog.setMessage(OpenTypeMessages.OpenTypeDialog_message);
        dialog.setDialogSettings(this.getClass().getName());
        dialog.setIgnoreCase(true);
        if (functionName.length() > 0 && functionName.length() < 80) {
            dialog.setFilter(functionName, true);
        }
    }

    private void openFileFromMap(String functionName) {
        IMarker marker = this.symbolMap.get(functionName);
        Display.getDefault().asyncExec(() -> {
            try {
                IDE.openEditor((IWorkbenchPage)EclipseMessageUtils.getWorkbenchPage(), (IMarker)marker);
                EclipseMessageUtils.getWorkbenchPage().getWorkbenchWindow().getShell().forceActive();
            }
            catch (CoreException e) {
                EclipseMessageUtils.error("Error opening file from map", e);
            }
        });
    }
}

