/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidrasymbollookup;

import ghidradev.EclipseMessageUtils;
import ghidradev.ghidrasymbollookup.OpenDeclarations;
import ghidradev.ghidrasymbollookup.preferences.GhidraSymbolLookupPreferences;
import ghidradev.ghidrasymbollookup.utils.CdtUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Display;

public class SocketSetupRunnable
implements Runnable {
    private ServerSocket serverSocket = null;
    private OpenDeclarations openDeclsDialog;
    private IProject project;
    private boolean isInitialized;

    public SocketSetupRunnable(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (!this.serverSocket.isClosed()) {
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try {
                    Socket socket = this.serverSocket.accept();
                    try {
                        block31: {
                            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                            try {
                                block30: {
                                    try (PrintWriter output = new PrintWriter(socket.getOutputStream());){
                                        String result = "";
                                        if (!this.isInitialized) {
                                            result = this.init();
                                        }
                                        if (this.isInitialized && !this.project.isOpen()) {
                                            try {
                                                input.readLine();
                                            }
                                            catch (IOException e) {
                                                EclipseMessageUtils.error("Unexpected exception receiving symbol name: " + e.getMessage());
                                            }
                                            this.isInitialized = false;
                                            result = this.init();
                                        }
                                        if (this.isInitialized) {
                                            String symbolName = null;
                                            try {
                                                symbolName = input.readLine();
                                            }
                                            catch (IOException e) {
                                                EclipseMessageUtils.error("Unexpected exception looking for symbol: " + e.getMessage());
                                                e.printStackTrace();
                                            }
                                            if (this.isInitialized) {
                                                this.lookup(symbolName, output);
                                                break block30;
                                            } else {
                                                output.write("Failed to initialize CDT project");
                                                output.flush();
                                            }
                                            break block30;
                                        }
                                        output.write(result);
                                    }
                                }
                                if (input == null) break block31;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (input == null) throw throwable;
                                input.close();
                                throw throwable;
                            }
                            input.close();
                        }
                        if (socket == null) continue;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (socket == null) throw throwable;
                        socket.close();
                        throw throwable;
                    }
                    socket.close();
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        return;
    }

    private String init() {
        String projectName = GhidraSymbolLookupPreferences.getSymbolLookupProjectName();
        String[] errorMessageContainer = new String[]{""};
        Display.getDefault().syncExec(() -> {
            while (!this.isInitialized) {
                if (projectName == null) {
                    stringArray[0] = "Project name not defined in the Ghidra Symbol Lookup preference page.";
                    EclipseMessageUtils.showWarnDialog("Ghidra Symbol Lookup", errorMessageContainer[0]);
                    break;
                }
                this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (!this.project.exists()) {
                    stringArray[0] = "The project \"" + projectName + "\" does not exist in your workspace. Please edit the \"Project Name\" field in the Ghidra Symbol Lookup preference page.";
                    EclipseMessageUtils.showWarnDialog("Project Does Not Exist", errorMessageContainer[0]);
                    break;
                }
                if (!this.project.isOpen()) {
                    stringArray[0] = "Please open the project \"" + this.project.getName() + "\" or choose a different one in the plugin preference page.";
                    EclipseMessageUtils.showWarnDialog("Project Not Open", errorMessageContainer[0]);
                    break;
                }
                if (!CdtUtils.isCdtProject(this.project)) {
                    stringArray[0] = "The project \"" + this.project.getName() + "\" is not a C or C++ project.\nPlease edit the \"Project Name\" field in the Ghidra Symbol Lookup preference page.";
                    EclipseMessageUtils.showWarnDialog("Not a C/C++ Project", errorMessageContainer[0]);
                    break;
                }
                this.openDeclsDialog = new OpenDeclarations(this.project);
                this.isInitialized = true;
            }
        });
        return errorMessageContainer[0];
    }

    private void lookup(String symbolName, PrintWriter output) {
        EclipseMessageUtils.info("Looking for symbol name: " + symbolName);
        boolean result = this.openDeclsDialog.open(symbolName);
        if (result) {
            output.write("Found symbol " + symbolName + "\n");
        } else {
            output.write("Couldn't find " + symbolName + "\n");
        }
        output.flush();
    }
}

