/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidrasymbollookup;

import ghidradev.Activator;
import ghidradev.EclipseMessageUtils;
import ghidradev.ghidrasymbollookup.SocketSetupRunnable;
import ghidradev.ghidrasymbollookup.preferences.GhidraSymbolLookupPreferences;
import java.io.IOException;
import java.net.ServerSocket;

public class SymbolLookupInitializer {
    private static ServerSocket serverSocket;

    public static void init(boolean firstTimeConsent) {
        if (firstTimeConsent) {
            GhidraSymbolLookupPreferences.setSymbolLookupEnabled(true);
        }
        SymbolLookupInitializer.listen(GhidraSymbolLookupPreferences.getSymbolLookupPort());
    }

    private static void listen(int port) {
        if (!GhidraSymbolLookupPreferences.isSymbolLookupEnabled()) {
            EclipseMessageUtils.info("GhidraDev Symbol Lookup port listening is disabled in preferences.");
            return;
        }
        if (port == -1) {
            EclipseMessageUtils.info("GhidraDev Symbol Lookup port listening is disabled, port not set in preferences.");
            return;
        }
        try {
            serverSocket = new ServerSocket(port);
            EclipseMessageUtils.info("GhidraDev Symbol Lookup is listening on port " + port);
            Activator.getDefault().registerCloseable(serverSocket);
        }
        catch (IOException iOException) {
            EclipseMessageUtils.showErrorDialog("GhidraDev Symbol Lookup", "Failed to listen for connections on port " + port + ".  The Symbol Lookup features will be disabled until a valid port is selected in preferences.");
            return;
        }
        new Thread(new SocketSetupRunnable(serverSocket)).start();
    }

    public static void preferencesChanged(boolean enabledWasChanged, boolean portWasChanged) {
        if (!enabledWasChanged && !portWasChanged) {
            return;
        }
        try {
            if (serverSocket != null) {
                serverSocket.close();
                Activator.getDefault().unregisterCloseable(serverSocket);
                serverSocket = null;
            }
        }
        catch (IOException iOException) {}
        SymbolLookupInitializer.listen(GhidraSymbolLookupPreferences.getSymbolLookupPort());
    }
}

