/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidrasymbollookup.preferences;

import ghidradev.Activator;
import org.eclipse.jface.preference.IPreferenceStore;

public class GhidraSymbolLookupPreferences {
    static final String GHIDRA_SYMBOL_LOOKUP_ENABLED = "ghidradev.symbolLookupEnabled";
    static final String GHIDRA_SYMBOL_LOOKUP_PROJECT_NAME = "ghidradev.symbolLookupProjectName";
    static final String GHIDRA_SYMBOL_LOOKUP_PORT_NUMBER = "ghidradev.symbolLookupPortNumber";

    public static boolean isSymbolLookupEnabled() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        return prefs.getBoolean(GHIDRA_SYMBOL_LOOKUP_ENABLED);
    }

    public static void setSymbolLookupEnabled(boolean enabled) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        prefs.setValue(GHIDRA_SYMBOL_LOOKUP_ENABLED, enabled);
    }

    public static String getSymbolLookupProjectName() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        String name = prefs.getString(GHIDRA_SYMBOL_LOOKUP_PROJECT_NAME);
        if (name.isEmpty()) {
            return null;
        }
        return name;
    }

    public static int getSymbolLookupPort() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        try {
            return Integer.parseInt(prefs.getString(GHIDRA_SYMBOL_LOOKUP_PORT_NUMBER));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }
}

