/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidrasymbollookup.utils;

import ghidradev.EclipseMessageUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class CdtUtils {
    public static final String C_NATURE = "org.eclipse.cdt.core.cnature";
    public static final String CC_NATURE = "org.eclipse.cdt.core.ccnature";

    public static Collection<IProject> getCDTProjects() {
        ArrayList<IProject> cdtProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && CdtUtils.isCdtProject(project)) {
                cdtProjects.add(project);
            }
            ++n2;
        }
        return cdtProjects;
    }

    public static boolean isCdtProject(IProject project) {
        try {
            return project != null && (project.hasNature(C_NATURE) || project.hasNature(CC_NATURE));
        }
        catch (CoreException e) {
            EclipseMessageUtils.error("CDT project check failed", e);
            return false;
        }
    }
}

