/*
 * Decompiled with CFR 0.152.
 */
package ghidra.xtext.sleigh.converter;

import java.math.BigInteger;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class IntValueConverter
extends AbstractLexerBasedConverter<BigInteger> {
    protected String toEscapedString(BigInteger value) {
        return value.toString();
    }

    protected void assertValidValue(BigInteger value) {
        super.assertValidValue((Object)value);
        if (value.compareTo(BigInteger.ZERO) < 0) {
            throw new ValueConverterException(String.valueOf(this.getRuleName()) + "-value may not be negative (value: " + value + ").", null, null);
        }
    }

    public BigInteger toValue(String string, INode node) {
        if (Strings.isEmpty((String)string)) {
            throw new ValueConverterException("Couldn't convert empty string to an int value.", node, null);
        }
        try {
            String parseString = string;
            int radix = 10;
            if (parseString.startsWith("0x") || parseString.startsWith("0X")) {
                parseString = string.substring(2);
                radix = 16;
            }
            if (parseString.startsWith("0b") || parseString.startsWith("0B")) {
                parseString = string.substring(2);
                radix = 2;
            }
            return new BigInteger(parseString, radix);
        }
        catch (NumberFormatException e) {
            throw new ValueConverterException("Couldn't convert '" + string + "' to a BigInteger value.", node, (Exception)e);
        }
    }
}

