/*
 * Decompiled with CFR 0.152.
 */
package ghidra.xtext.sleigh.formatting2;

import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import ghidra.xtext.sleigh.services.SleighGrammarAccess;
import ghidra.xtext.sleigh.sleigh.DefineTest;
import ghidra.xtext.sleigh.sleigh.Expression;
import ghidra.xtext.sleigh.sleigh.IsDefined;
import ghidra.xtext.sleigh.sleigh.MACROPARAMSYM;
import ghidra.xtext.sleigh.sleigh.Model;
import ghidra.xtext.sleigh.sleigh.NAMESYM;
import ghidra.xtext.sleigh.sleigh.OPERANDSYM;
import ghidra.xtext.sleigh.sleigh.USEROPSYM;
import ghidra.xtext.sleigh.sleigh.aligndef;
import ghidra.xtext.sleigh.sleigh.anystringlist;
import ghidra.xtext.sleigh.sleigh.anystringpart;
import ghidra.xtext.sleigh.sleigh.anysymbol;
import ghidra.xtext.sleigh.sleigh.assignSym;
import ghidra.xtext.sleigh.sleigh.atomic;
import ghidra.xtext.sleigh.sleigh.baseconstructor;
import ghidra.xtext.sleigh.sleigh.bitrangedef;
import ghidra.xtext.sleigh.sleigh.bitrangelist;
import ghidra.xtext.sleigh.sleigh.bitrangesingle;
import ghidra.xtext.sleigh.sleigh.constraint;
import ghidra.xtext.sleigh.sleigh.constraintAdd;
import ghidra.xtext.sleigh.sleigh.constraintAnd;
import ghidra.xtext.sleigh.sleigh.constraintDiv;
import ghidra.xtext.sleigh.sleigh.constraintInvert;
import ghidra.xtext.sleigh.sleigh.constraintLeft;
import ghidra.xtext.sleigh.sleigh.constraintMult;
import ghidra.xtext.sleigh.sleigh.constraintNegate;
import ghidra.xtext.sleigh.sleigh.constraintOr;
import ghidra.xtext.sleigh.sleigh.constraintRight;
import ghidra.xtext.sleigh.sleigh.constraintSinglePexpression;
import ghidra.xtext.sleigh.sleigh.constraintSub;
import ghidra.xtext.sleigh.sleigh.constraintXor;
import ghidra.xtext.sleigh.sleigh.constructprint;
import ghidra.xtext.sleigh.sleigh.contextDefs;
import ghidra.xtext.sleigh.sleigh.contextblock;
import ghidra.xtext.sleigh.sleigh.contextdef;
import ghidra.xtext.sleigh.sleigh.contextentry;
import ghidra.xtext.sleigh.sleigh.contextfielddef;
import ghidra.xtext.sleigh.sleigh.contextlist;
import ghidra.xtext.sleigh.sleigh.elleqRight;
import ghidra.xtext.sleigh.sleigh.endiandef;
import ghidra.xtext.sleigh.sleigh.exportStmt;
import ghidra.xtext.sleigh.sleigh.exportedSym;
import ghidra.xtext.sleigh.sleigh.exprAnd;
import ghidra.xtext.sleigh.sleigh.exprBoolAnd;
import ghidra.xtext.sleigh.sleigh.exprBoolOr;
import ghidra.xtext.sleigh.sleigh.exprBoolXor;
import ghidra.xtext.sleigh.sleigh.exprDiv;
import ghidra.xtext.sleigh.sleigh.exprEqual;
import ghidra.xtext.sleigh.sleigh.exprFAdd;
import ghidra.xtext.sleigh.sleigh.exprFDiv;
import ghidra.xtext.sleigh.sleigh.exprFEqual;
import ghidra.xtext.sleigh.sleigh.exprFGt;
import ghidra.xtext.sleigh.sleigh.exprFGtEqual;
import ghidra.xtext.sleigh.sleigh.exprFLess;
import ghidra.xtext.sleigh.sleigh.exprFLessEqual;
import ghidra.xtext.sleigh.sleigh.exprFMult;
import ghidra.xtext.sleigh.sleigh.exprFNegate;
import ghidra.xtext.sleigh.sleigh.exprFNotEqual;
import ghidra.xtext.sleigh.sleigh.exprFSub;
import ghidra.xtext.sleigh.sleigh.exprGt;
import ghidra.xtext.sleigh.sleigh.exprGtEqual;
import ghidra.xtext.sleigh.sleigh.exprLeft;
import ghidra.xtext.sleigh.sleigh.exprLess;
import ghidra.xtext.sleigh.sleigh.exprLoad;
import ghidra.xtext.sleigh.sleigh.exprLtEqual;
import ghidra.xtext.sleigh.sleigh.exprMinus;
import ghidra.xtext.sleigh.sleigh.exprMult;
import ghidra.xtext.sleigh.sleigh.exprNegate;
import ghidra.xtext.sleigh.sleigh.exprNotEqual;
import ghidra.xtext.sleigh.sleigh.exprOr;
import ghidra.xtext.sleigh.sleigh.exprRem;
import ghidra.xtext.sleigh.sleigh.exprRight;
import ghidra.xtext.sleigh.sleigh.exprSDiv;
import ghidra.xtext.sleigh.sleigh.exprSGt;
import ghidra.xtext.sleigh.sleigh.exprSGtEqual;
import ghidra.xtext.sleigh.sleigh.exprSLess;
import ghidra.xtext.sleigh.sleigh.exprSLtEqual;
import ghidra.xtext.sleigh.sleigh.exprSRem;
import ghidra.xtext.sleigh.sleigh.exprSRight;
import ghidra.xtext.sleigh.sleigh.exprSym;
import ghidra.xtext.sleigh.sleigh.exprXor;
import ghidra.xtext.sleigh.sleigh.exprrAdd;
import ghidra.xtext.sleigh.sleigh.fielddef;
import ghidra.xtext.sleigh.sleigh.intblist;
import ghidra.xtext.sleigh.sleigh.intbpart;
import ghidra.xtext.sleigh.sleigh.integerValue;
import ghidra.xtext.sleigh.sleigh.integervarnode;
import ghidra.xtext.sleigh.sleigh.isKeyword;
import ghidra.xtext.sleigh.sleigh.jumpdest;
import ghidra.xtext.sleigh.sleigh.localDefine;
import ghidra.xtext.sleigh.sleigh.macroDefine;
import ghidra.xtext.sleigh.sleigh.macroUse;
import ghidra.xtext.sleigh.sleigh.macrodef;
import ghidra.xtext.sleigh.sleigh.nameattach;
import ghidra.xtext.sleigh.sleigh.namesymlist;
import ghidra.xtext.sleigh.sleigh.oplist;
import ghidra.xtext.sleigh.sleigh.pAnd;
import ghidra.xtext.sleigh.sleigh.pNextSet;
import ghidra.xtext.sleigh.sleigh.pOr;
import ghidra.xtext.sleigh.sleigh.paramlist;
import ghidra.xtext.sleigh.sleigh.pcodeopdef;
import ghidra.xtext.sleigh.sleigh.pequation;
import ghidra.xtext.sleigh.sleigh.pexprAdd;
import ghidra.xtext.sleigh.sleigh.pexprAnd;
import ghidra.xtext.sleigh.sleigh.pexprDiv;
import ghidra.xtext.sleigh.sleigh.pexprInvert;
import ghidra.xtext.sleigh.sleigh.pexprLeft;
import ghidra.xtext.sleigh.sleigh.pexprMult;
import ghidra.xtext.sleigh.sleigh.pexprNegate;
import ghidra.xtext.sleigh.sleigh.pexprOr;
import ghidra.xtext.sleigh.sleigh.pexprRight;
import ghidra.xtext.sleigh.sleigh.pexprSub;
import ghidra.xtext.sleigh.sleigh.pexprXor;
import ghidra.xtext.sleigh.sleigh.printpiece;
import ghidra.xtext.sleigh.sleigh.rtlbody;
import ghidra.xtext.sleigh.sleigh.rtlmid;
import ghidra.xtext.sleigh.sleigh.singlePexpression;
import ghidra.xtext.sleigh.sleigh.sizedstar;
import ghidra.xtext.sleigh.sleigh.spaceprop;
import ghidra.xtext.sleigh.sleigh.spec;
import ghidra.xtext.sleigh.sleigh.statement;
import ghidra.xtext.sleigh.sleigh.subconstructor;
import ghidra.xtext.sleigh.sleigh.tokendef;
import ghidra.xtext.sleigh.sleigh.tokenprop;
import ghidra.xtext.sleigh.sleigh.valueattach;
import ghidra.xtext.sleigh.sleigh.valuepart;
import ghidra.xtext.sleigh.sleigh.valuepartdef;
import ghidra.xtext.sleigh.sleigh.valuesymlist;
import ghidra.xtext.sleigh.sleigh.varattach;
import ghidra.xtext.sleigh.sleigh.vardef;
import ghidra.xtext.sleigh.sleigh.vardeflist;
import ghidra.xtext.sleigh.sleigh.varlist;
import ghidra.xtext.sleigh.sleigh.varnodedef;
import ghidra.xtext.sleigh.sleigh.varpart;
import ghidra.xtext.sleigh.sleigh.varsymlist;
import ghidra.xtext.sleigh.sleigh.xrtl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionFinder;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class SleighFormatter
extends AbstractFormatter2 {
    @Inject
    @Extension
    private SleighGrammarAccess _sleighGrammarAccess;
    private HashMap<String, Integer> constructorPrintLenMap = CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"", (Object)0)});
    private HashMap<String, Integer> constructorPatternLenMap = CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"", (Object)0)});
    private HashMap<String, Integer> constructorContextLenMap = CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"", (Object)0)});
    private int maxTokenNameLen = 0;
    private int maxStartLen = 0;
    private int maxEndLen = 0;
    private boolean maxFound = false;
    private int maxtag = 0;

    protected void _format(Model model, @Extension IFormattableDocument document) {
        String name;
        Pair _mappedTo = Pair.of((Object)"", (Object)0);
        this.constructorPrintLenMap = CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo});
        Pair _mappedTo_1 = Pair.of((Object)"", (Object)0);
        this.constructorPatternLenMap = CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo_1});
        Pair _mappedTo_2 = Pair.of((Object)"", (Object)0);
        this.constructorContextLenMap = CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo_2});
        Object prev = null;
        EList<spec> _elements = model.getElements();
        for (spec spec2 : _elements) {
            if (prev != null && !spec2.getClass().equals(prev.getClass()) && !(prev instanceof macroDefine)) {
                Procedures.Procedure1 _function = it -> {
                    it.setNewLines(2);
                    it.setPriority(2);
                };
                document.append((EObject)prev, _function);
            }
            this.format(spec2, document);
            prev = spec2;
        }
        UnmodifiableIterator constructors = Iterators.filter((Iterator)model.eAllContents(), subconstructor.class);
        String lastName = "";
        while (constructors.hasNext()) {
            boolean _not;
            int _length;
            int _plus;
            int totalLen;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            subconstructor constLike = (subconstructor)constructors.next();
            name = constLike.getTableName().getName();
            isKeyword is = constLike.getPrint().getIs();
            IEObjectRegion printRegion = this.textRegionExtensions.regionForEObject((EObject)constLike.getPrint());
            if (printRegion == null) continue;
            int matchLen = 0;
            ISemanticRegionFinder _immediatelyPreceding = this.textRegionExtensions.immediatelyPreceding((EObject)constLike.getMatch().getConstraints());
            boolean bl = _tripleNotEquals = _immediatelyPreceding != null;
            if (_tripleNotEquals) {
                IEObjectRegion matchRegion = this.textRegionExtensions.regionForEObject((EObject)constLike.getMatch().getConstraints());
                matchLen = matchRegion.getLength();
                matchRegion.getOffset();
            } else {
                IEObjectRegion matchRegion_1 = this.textRegionExtensions.regionForEObject((EObject)constLike.getMatch());
                matchLen = matchRegion_1.getLength();
                matchRegion_1.getOffset();
            }
            int contextLen = 0;
            ISemanticRegionFinder _immediatelyPreceding_1 = this.textRegionExtensions.immediatelyPreceding((EObject)constLike.getCblock());
            boolean bl2 = _tripleNotEquals_1 = _immediatelyPreceding_1 != null;
            if (_tripleNotEquals_1) {
                boolean _tripleNotEquals_2;
                contextblock _cblock = constLike.getCblock();
                boolean bl3 = _tripleNotEquals_2 = _cblock != null;
                if (_tripleNotEquals_2) {
                    contextLen = this.textRegionExtensions.regionForEObject((EObject)constLike.getCblock()).getLength();
                }
            }
            String truncName = this.stripDigit(name);
            Integer printMaxLen = this.constructorPrintLenMap.get(truncName);
            Integer contextMaxLen = this.constructorContextLenMap.get(truncName);
            Integer matchMaxLen = this.constructorPatternLenMap.get(truncName);
            int printRegionlen = printRegion.getLength();
            int isprlen = this.textRegionExtensions.regionFor((EObject)is).keyword("is").getPreviousHiddenRegion().getLength();
            if (printRegionlen == 2) {
                isprlen = 0;
                printRegionlen = 1;
            }
            if ((totalLen = (_plus = (_length = name.length()) + printRegionlen) - isprlen) < printMaxLen) {
                int prLen = totalLen;
                Procedures.Procedure1 _function = it -> it.setSpace(Strings.repeat((String)" ", (int)(printMaxLen - prLen + 2)));
                document.prepend((EObject)is, _function);
                int _talLen = totalLen;
                totalLen = _talLen + (printMaxLen - prLen + 2);
            } else {
                Procedures.Procedure1 _function_1 = it -> it.setSpace("  ");
                document.prepend((EObject)is, _function_1);
                int _talLen_1 = totalLen;
                totalLen = _talLen_1 + 2;
            }
            int _talLen_2 = totalLen;
            totalLen = _talLen_2 + (matchLen + contextLen);
            int maxLBLen = printMaxLen + matchMaxLen + contextMaxLen + 2;
            if (totalLen < maxLBLen && maxLBLen < 120) {
                int prLen_1 = totalLen;
                Procedures.Procedure1 _function_2 = it -> {
                    it.setPriority(1);
                    it.setSpace(Strings.repeat((String)" ", (int)(maxLBLen - prLen_1 + 1)));
                };
                document.prepend(this.textRegionExtensions.regionFor((EObject)constLike.getBody()).keyword("{"), _function_2);
            } else {
                Procedures.Procedure1 _function_3 = it -> {
                    it.setPriority(1);
                    it.setSpace(" ");
                };
                document.prepend(this.textRegionExtensions.regionFor((EObject)constLike.getBody()).keyword("{"), _function_3);
            }
            boolean _equals = lastName.equals(truncName);
            boolean bl4 = _not = !_equals;
            if (_not) {
                Procedures.Procedure1 _function_4 = it -> {
                    it.setNewLines(2);
                    it.setPriority(1);
                };
                document.prepend((EObject)constLike, _function_4);
            }
            lastName = truncName;
        }
        UnmodifiableIterator baseconstructors = Iterators.filter((Iterator)model.eAllContents(), baseconstructor.class);
        name = "";
        Integer printMaxLen = this.constructorPrintLenMap.get(name);
        while (baseconstructors.hasNext()) {
            int _length_2;
            int _length_1;
            baseconstructor constLike = (baseconstructor)baseconstructors.next();
            isKeyword is = constLike.getPrint().getIs();
            IEObjectRegion printRegion = this.textRegionExtensions.regionForEObject((EObject)constLike.getPrint());
            if (printRegion == null) continue;
            int _length = name.length();
            int _plus = _length + 1;
            int _plus_1 = _plus + (_length_1 = printRegion.getLength());
            int totalLen = _plus_1 - (_length_2 = this.textRegionExtensions.regionFor((EObject)is).keyword("is").getPreviousHiddenRegion().getLength());
            if (totalLen < printMaxLen) {
                int prLen = totalLen;
                Procedures.Procedure1 _function = it -> it.setSpace(Strings.repeat((String)" ", (int)(printMaxLen - prLen)));
                document.prepend((EObject)is, _function);
                int _talLen = totalLen;
                totalLen = _talLen + (printMaxLen - prLen + 3);
                continue;
            }
            if (totalLen <= printMaxLen) continue;
            Procedures.Procedure1 _function_1 = it -> it.setSpace("  ");
            document.prepend((EObject)is, _function_1);
            int _talLen_1 = totalLen;
            totalLen = _talLen_1 + 3;
        }
    }

    public void computePrintLength(String name, constructprint print) {
        String truncName = this.stripDigit(name);
        Integer prLen = this.constructorPrintLenMap.getOrDefault(truncName, 0);
        isKeyword is = print.getIs();
        IEObjectRegion printRegion = this.textRegionExtensions.regionForEObject((EObject)print);
        int baseLen = 0;
        if (printRegion != null) {
            int _minus;
            int curPrLen = printRegion.getLength();
            IHiddenRegion curPrWhiteSpace = this.textRegionExtensions.regionFor((EObject)is).keyword("is").getPreviousHiddenRegion();
            int _length = name.toString().length();
            int _plus = _length + curPrLen;
            int _length_1 = curPrWhiteSpace.getLength();
            baseLen = _minus = _plus - _length_1;
        }
        if (baseLen > 40) {
            baseLen = 0;
        }
        if (baseLen >= prLen) {
            this.constructorPrintLenMap.put(truncName, baseLen);
        }
    }

    public String stripDigit(String str) {
        String retStr = str;
        while (Character.isDigit(retStr.charAt(retStr.length() - 1))) {
            int _length = retStr.length();
            int _minus = _length - 1;
            retStr = retStr.substring(0, _minus);
        }
        return retStr;
    }

    public void computeMatchLength(String name, pequation match, contextblock context) {
        String truncName = this.stripDigit(name);
        Integer allMatchLen = this.constructorPatternLenMap.getOrDefault(truncName, 0);
        if (match == null || match.getConstraints() == null) {
            return;
        }
        int matchLen = 0;
        int matchOffset = 0;
        if (match.getConstraints() != null && this.textRegionExtensions.immediatelyPreceding((EObject)match.getConstraints()) != null) {
            IEObjectRegion matchRegion = this.textRegionExtensions.regionForEObject((EObject)match.getConstraints());
            matchLen = matchRegion.getLength();
            matchOffset = matchRegion.getOffset();
        } else {
            IEObjectRegion matchRegion_1 = this.textRegionExtensions.regionForEObject((EObject)match);
            matchLen = matchRegion_1.getLength();
            matchOffset = matchRegion_1.getOffset();
        }
        if (matchLen >= allMatchLen) {
            this.constructorPatternLenMap.put(truncName, matchLen);
        }
        Integer allContextLen = this.constructorContextLenMap.getOrDefault(truncName, 0);
        int contextLen = 0;
        if (context != null && this.textRegionExtensions.immediatelyPreceding((EObject)context) != null) {
            IEObjectRegion contextRegion = this.textRegionExtensions.regionForEObject((EObject)context);
            contextLen = contextRegion.getLength();
            if (matchOffset == 0) {
                contextLen = 0;
            }
        }
        if (contextLen >= allContextLen) {
            this.constructorContextLenMap.put(truncName, contextLen);
        }
    }

    protected void _format(macroDefine macroDefine2, @Extension IFormattableDocument document) {
        document.format((Object)macroDefine2.getDefinename());
        document.format((Object)macroDefine2.getTests());
        document.format((Object)macroDefine2.getSym());
        EList<IsDefined> _isdefined = macroDefine2.getIsdefined();
        for (IsDefined isDefined : _isdefined) {
            document.format((Object)isDefined);
        }
        document.format((Object)macroDefine2.getSymref());
    }

    protected void _format(DefineTest definetest, @Extension IFormattableDocument document) {
        this.format(definetest.getTest(), document);
        this.format(definetest.getSymref(), document);
        this.format(definetest.getIsdefined(), document);
        this.format(definetest.getAndtest(), document);
        this.format(definetest.getOrtest(), document);
    }

    protected void _format(endiandef endiandef2, @Extension IFormattableDocument document) {
        this.format(endiandef2.getIs_define(), document);
    }

    protected void _format(aligndef aligndef2, @Extension IFormattableDocument document) {
        this.format(aligndef2.getAlign(), document);
    }

    protected void _format(tokendef tokendef2, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.setNewLines(1, 2, 3);
        document.surround((EObject)tokendef2, _function);
        this.format(tokendef2.getSize(), document);
        this.format(tokendef2.getFields(), document);
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)tokendef2).keyword(";"), _function_1);
    }

    protected void _format(tokenprop tokenprop2, @Extension IFormattableDocument document) {
        this.maxTokenNameLen = 0;
        this.maxStartLen = 0;
        this.maxEndLen = 0;
        this.maxFound = false;
        this.maxtag = 0;
        EList<EObject> _tokens = tokenprop2.getTokens();
        for (EObject tokens : _tokens) {
            this.format(tokens, document);
        }
        this.maxFound = true;
        EList<EObject> _tokens_1 = tokenprop2.getTokens();
        for (EObject tokens_1 : _tokens_1) {
            this.format(tokens_1, document);
        }
    }

    protected void _format(contextdef contextdef2, @Extension IFormattableDocument document) {
        this.format(contextdef2.getFields(), document);
    }

    protected void _format(contextDefs contextdefs, @Extension IFormattableDocument document) {
        this.maxTokenNameLen = 0;
        this.maxStartLen = 0;
        this.maxEndLen = 0;
        this.maxFound = false;
        this.maxtag = 0;
        EList<EObject> _contextDefs = contextdefs.getContextDefs();
        for (EObject contextDefs2 : _contextDefs) {
            this.format(contextDefs2, document);
        }
        this.maxFound = true;
        EList<EObject> _contextDefs_1 = contextdefs.getContextDefs();
        for (EObject contextDefs_1 : _contextDefs_1) {
            this.format(contextDefs_1, document);
        }
    }

    protected void _format(fielddef fielddef2, @Extension IFormattableDocument document) {
        boolean _isSigned;
        boolean hastag;
        this.format(fielddef2.getStart(), document);
        this.format(fielddef2.getEnd(), document);
        int len = fielddef2.getName().length();
        int slen = fielddef2.getStart().getValue().length();
        int elen = fielddef2.getEnd().getValue().length();
        boolean bl = hastag = fielddef2.isSigned() || fielddef2.isHex() || fielddef2.isDec();
        if (this.maxFound) {
            int padlen = this.maxTokenNameLen - len + 1;
            Procedures.Procedure1 _function = it -> it.setNewLines(1, 1, 2);
            Procedures.Procedure1 _function_1 = it -> it.indent();
            document.surround((EObject)((fielddef)document.prepend((EObject)fielddef2, _function)), _function_1);
            Procedures.Procedure1 _function_2 = it -> it.setSpace(Strings.repeat((String)" ", (int)padlen));
            document.prepend(this.textRegionExtensions.regionFor((EObject)fielddef2).keyword("="), _function_2);
            Procedures.Procedure1 _function_3 = it -> it.setSpace(Strings.repeat((String)" ", (int)(this.maxStartLen - slen)));
            document.append(this.textRegionExtensions.regionFor((EObject)fielddef2).keyword("("), _function_3);
            Procedures.Procedure1 _function_4 = it -> it.setSpace(Strings.repeat((String)" ", (int)(this.maxEndLen - elen)));
            Procedures.Procedure1 _function_5 = it -> it.noSpace();
            document.prepend(document.append(this.textRegionExtensions.regionFor((EObject)fielddef2).keyword(","), _function_4), _function_5);
            if (!hastag) {
                Procedures.Procedure1 _function_6 = it -> it.noSpace();
                Procedures.Procedure1 _function_7 = it -> it.setSpace(Strings.repeat((String)" ", (int)(this.maxtag + 1)));
                document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)fielddef2).keyword(")"), _function_6), _function_7);
            } else {
                Procedures.Procedure1 _function_8 = it -> it.noSpace();
                document.prepend(this.textRegionExtensions.regionFor((EObject)fielddef2).keyword(")"), _function_8);
            }
            Procedures.Procedure1 _function_9 = it -> it.setSpace(" ");
            document.append(this.textRegionExtensions.regionFor((EObject)fielddef2).keyword("="), _function_9);
            Procedures.Procedure1 _function_10 = it -> it.oneSpace();
            document.prepend(this.textRegionExtensions.regionFor((EObject)fielddef2).keyword("signed"), _function_10);
        } else if (len > this.maxTokenNameLen) {
            this.maxTokenNameLen = len;
        }
        if (this.maxStartLen < slen) {
            this.maxStartLen = slen;
        }
        if (this.maxEndLen < elen) {
            this.maxEndLen = elen;
        }
        if (_isSigned = fielddef2.isSigned()) {
            this.maxtag = 6;
        } else if (fielddef2.isHex() || fielddef2.isDec()) {
            this.maxtag = 3;
        }
    }

    protected void _format(macroUse macrouse, @Extension IFormattableDocument document) {
        this.format(macrouse.getDefine(), document);
    }

    protected void _format(contextfielddef contextfielddef2, @Extension IFormattableDocument document) {
        boolean hastag;
        this.format(contextfielddef2.getStart(), document);
        this.format(contextfielddef2.getEnd(), document);
        int len = contextfielddef2.getName().length();
        int slen = contextfielddef2.getStart().getValue().length();
        int elen = contextfielddef2.getEnd().getValue().length();
        boolean bl = hastag = contextfielddef2.isSigned() || contextfielddef2.isNoflow() || contextfielddef2.isHex() || contextfielddef2.isDec();
        if (this.maxFound) {
            int padlen = this.maxTokenNameLen - len + 1;
            Procedures.Procedure1 _function = it -> it.setNewLines(1, 1, 2);
            Procedures.Procedure1 _function_1 = it -> it.indent();
            document.surround((EObject)((contextfielddef)document.prepend((EObject)contextfielddef2, _function)), _function_1);
            Procedures.Procedure1 _function_2 = it -> it.setSpace(Strings.repeat((String)" ", (int)padlen));
            document.prepend(this.textRegionExtensions.regionFor((EObject)contextfielddef2).keyword("="), _function_2);
            Procedures.Procedure1 _function_3 = it -> it.setSpace(Strings.repeat((String)" ", (int)(this.maxStartLen - slen)));
            document.append(this.textRegionExtensions.regionFor((EObject)contextfielddef2).keyword("("), _function_3);
            Procedures.Procedure1 _function_4 = it -> it.setSpace(Strings.repeat((String)" ", (int)(this.maxEndLen - elen)));
            Procedures.Procedure1 _function_5 = it -> it.noSpace();
            document.prepend(document.append(this.textRegionExtensions.regionFor((EObject)contextfielddef2).keyword(","), _function_4), _function_5);
            Procedures.Procedure1 _function_6 = it -> it.noSpace();
            document.prepend(this.textRegionExtensions.regionFor((EObject)contextfielddef2).keyword(")"), _function_6);
            Procedures.Procedure1 _function_7 = it -> it.setSpace(" ");
            document.append(this.textRegionExtensions.regionFor((EObject)contextfielddef2).keyword("="), _function_7);
            Procedures.Procedure1 _function_8 = it -> it.oneSpace();
            document.prepend(this.textRegionExtensions.regionFor((EObject)contextfielddef2).keyword("signed"), _function_8);
            Procedures.Procedure1 _function_9 = it -> it.oneSpace();
            document.prepend(this.textRegionExtensions.regionFor((EObject)contextfielddef2).keyword("noflow"), _function_9);
            if (!hastag) {
                Procedures.Procedure1 _function_10 = it -> it.noSpace();
                Procedures.Procedure1 _function_11 = it -> it.setSpace(Strings.repeat((String)" ", (int)(this.maxtag + 1)));
                document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)contextfielddef2).keyword(")"), _function_10), _function_11);
            } else {
                Procedures.Procedure1 _function_12 = it -> it.noSpace();
                document.prepend(this.textRegionExtensions.regionFor((EObject)contextfielddef2).keyword(")"), _function_12);
            }
        } else if (len > this.maxTokenNameLen) {
            this.maxTokenNameLen = len;
        }
        if (this.maxStartLen < slen) {
            this.maxStartLen = slen;
        }
        if (this.maxEndLen < elen) {
            this.maxEndLen = elen;
        }
        if (contextfielddef2.isSigned() || contextfielddef2.isNoflow()) {
            this.maxtag = 6;
        } else if (contextfielddef2.isHex() || contextfielddef2.isDec()) {
            this.maxtag = 3;
        }
    }

    protected void _format(spaceprop spaceprop2, @Extension IFormattableDocument document) {
        this.format(spaceprop2.getSpace(), document);
        this.format(spaceprop2.getSize(), document);
        this.format(spaceprop2.getWordsize(), document);
    }

    protected void _format(varnodedef varnodedef2, @Extension IFormattableDocument document) {
        this.format(varnodedef2.getOffset(), document);
        this.format(varnodedef2.getSize(), document);
        this.format(varnodedef2.getVars(), document);
    }

    protected void _format(vardeflist vars, @Extension IFormattableDocument document) {
        EList<vardef> _varDefList = vars.getVarDefList();
        for (vardef varDefList : _varDefList) {
            this.format(varDefList, document);
        }
        boolean _isMultiline = this.textRegionExtensions.isMultiline((EObject)vars);
        if (_isMultiline) {
            ISemanticRegion open = this.textRegionExtensions.regionFor((EObject)vars).keyword("[");
            ISemanticRegion close = this.textRegionExtensions.regionFor((EObject)vars).keyword("]");
            Procedures.Procedure1 _function = it -> it.indent();
            document.interior(open, close, _function);
            Procedures.Procedure1 _function_1 = it -> it.newLine();
            document.append(open, _function_1);
            Procedures.Procedure1 _function_2 = it -> it.newLine();
            document.prepend(close, _function_2);
            EList<vardef> vlist = vars.getVarDefList();
            int maxLen = 0;
            for (vardef v : vlist) {
                boolean _not;
                int len = 1;
                boolean _isIsempty = v.isIsempty();
                boolean bl = _not = !_isIsempty;
                if (_not) {
                    len = v.getVarname().getName().length();
                }
                if (len <= maxLen) continue;
                maxLen = len;
            }
            if (maxLen > 20) {
                maxLen = 20;
            }
            int previousLen = 0;
            for (vardef v_1 : vlist) {
                int spaceLen;
                boolean _isIsempty_1;
                boolean _not;
                int len = 1;
                boolean _isIsempty = v_1.isIsempty();
                boolean bl = _not = !_isIsempty;
                if (_not) {
                    len = v_1.getVarname().getName().length();
                }
                if (this.textRegionExtensions.nextHiddenRegion((EObject)v_1) != null && this.textRegionExtensions.nextHiddenRegion((EObject)v_1).isMultiline()) {
                    Procedures.Procedure1 _function_3 = it -> it.newLine();
                    document.append((EObject)v_1, _function_3);
                }
                if (previousLen != 0) {
                    int prevLen = previousLen;
                    Procedures.Procedure1 _function_4 = it -> it.setSpace(Strings.repeat((String)" ", (int)prevLen));
                    document.prepend((EObject)v_1, _function_4);
                    previousLen = 0;
                }
                previousLen = (_isIsempty_1 = v_1.isIsempty()) ? maxLen - 1 + 1 : (len < maxLen ? (spaceLen = maxLen - len + 1) : 1);
            }
        }
    }

    protected void _format(vardef vardef2, @Extension IFormattableDocument document) {
        this.format(vardef2.getVarname(), document);
    }

    protected void _format(bitrangedef bitrangedef2, @Extension IFormattableDocument document) {
        this.format(bitrangedef2.getList(), document);
    }

    protected void _format(bitrangelist bitrangelist2, @Extension IFormattableDocument document) {
        EList<bitrangesingle> _bitrangeEntries = bitrangelist2.getBitrangeEntries();
        for (bitrangesingle bitrangeEntries : _bitrangeEntries) {
            this.format(bitrangeEntries, document);
        }
    }

    protected void _format(bitrangesingle bitrangesingle2, @Extension IFormattableDocument document) {
        this.format(bitrangesingle2.getStart(), document);
        this.format(bitrangesingle2.getEnd(), document);
    }

    protected void _format(pcodeopdef pcodeopdef2, @Extension IFormattableDocument document) {
        EList<USEROPSYM> _ops = pcodeopdef2.getOps();
        for (USEROPSYM ops : _ops) {
            this.format(ops, document);
        }
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)pcodeopdef2).keyword(";"), _function);
    }

    protected void _format(valueattach valueattach2, @Extension IFormattableDocument document) {
        this.format(valueattach2.getValuelist(), document);
        this.format(valueattach2.getBlist(), document);
    }

    protected void _format(nameattach nameattach2, @Extension IFormattableDocument document) {
        this.format(nameattach2.getValuelist(), document);
        this.format(nameattach2.getSlist(), document);
    }

    protected void _format(varattach varattach2, @Extension IFormattableDocument document) {
        this.format(varattach2.getValuelist(), document);
        this.format(varattach2.getVlist(), document);
    }

    protected void _format(macrodef macrodef2, @Extension IFormattableDocument document) {
        this.format(macrodef2.getArgs(), document);
        this.format(macrodef2.getBody(), document);
    }

    protected void _format(rtlbody rtlbody2, @Extension IFormattableDocument document) {
        boolean _isUnimpl;
        xrtl body = rtlbody2.getBody();
        if (body != null) {
            this.format(body, document);
        }
        ISemanticRegion open = this.textRegionExtensions.regionFor((EObject)rtlbody2).keyword("{");
        ISemanticRegion close = this.textRegionExtensions.regionFor((EObject)rtlbody2).keyword("}");
        Procedures.Procedure1 _function = it -> {
            it.indent();
            it.setPriority(3);
        };
        document.interior(open, close, _function);
        boolean _isMultiline = this.textRegionExtensions.isMultiline((EObject)rtlbody2);
        if (_isMultiline) {
            Procedures.Procedure1 _function_1 = it -> it.oneSpace();
            document.prepend(open, _function_1);
            Procedures.Procedure1 _function_2 = it -> it.newLine();
            document.prepend(close, _function_2);
        }
        if (_isUnimpl = rtlbody2.isUnimpl()) {
            Procedures.Procedure1 _function_3 = it -> {
                it.newLine();
                it.indent();
                it.setPriority(3);
            };
            document.prepend((EObject)rtlbody2, _function_3);
        }
    }

    protected void _format(baseconstructor baseconstructor2, @Extension IFormattableDocument document) {
        int _length_1;
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)baseconstructor2).keyword(":"), _function);
        this.format(baseconstructor2.getPrint(), document);
        this.format(baseconstructor2.getMatch(), document);
        this.format(baseconstructor2.getCblock(), document);
        this.format(baseconstructor2.getBody(), document);
        Integer allBaseLen = this.constructorPrintLenMap.getOrDefault("", 0);
        isKeyword is = baseconstructor2.getPrint().getIs();
        IEObjectRegion printRegion = this.textRegionExtensions.regionForEObject((EObject)baseconstructor2.getPrint());
        if (printRegion == null) {
            return;
        }
        int _length = printRegion.getLength();
        int baseLen = _length - (_length_1 = this.textRegionExtensions.regionFor((EObject)is).keyword("is").getPreviousHiddenRegion().getLength());
        if (baseLen > 40) {
            baseLen = 0;
        }
        if (baseLen >= allBaseLen) {
            this.constructorPrintLenMap.put("", baseLen);
        }
    }

    protected void _format(subconstructor sub, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)sub).keyword(":"), _function);
        this.format(sub.getTableName(), document);
        this.format(sub.getPrint(), document);
        this.format(sub.getMatch(), document);
        this.format(sub.getCblock(), document);
        this.format(sub.getBody(), document);
        ISemanticRegion open = this.textRegionExtensions.regionFor((EObject)sub.getBody()).keyword("{");
        ISemanticRegion close = this.textRegionExtensions.regionFor((EObject)sub.getBody()).keyword("}");
        rtlbody body = sub.getBody();
        if (open != null && close != null) {
            boolean _not;
            this.textRegionExtensions.regionForEObject((EObject)body).getLength();
            boolean _isMultiline = this.textRegionExtensions.isMultiline((EObject)sub.getBody());
            boolean bl = _not = !_isMultiline;
            if (_not) {
                Procedures.Procedure1 _function_1 = it -> it.setNewLines(0);
                Procedures.Procedure1 _function_2 = it -> it.oneSpace();
                document.append(document.prepend(open, _function_1), _function_2);
                Procedures.Procedure1 _function_3 = it -> it.oneSpace();
                document.prepend(close, _function_3);
                Consumer<statement> _function_4 = it -> {
                    Consumer<ISemanticRegion> _function_5 = it_1 -> {
                        Procedures.Procedure1 _function_6 = it_2 -> it_2.setSpace("");
                        Procedures.Procedure1 _function_7 = it_2 -> it_2.setSpace(" ");
                        document.append(document.prepend(it_1, _function_6), _function_7);
                    };
                    this.textRegionExtensions.regionFor((EObject)it).keywords(new String[]{";"}).forEach(_function_5);
                };
                body.getBody().getStatements().getRtllist().forEach(_function_4);
                Consumer<ISemanticRegion> _function_5 = it -> {
                    Procedures.Procedure1 _function_6 = it_1 -> it_1.setSpace("");
                    Procedures.Procedure1 _function_7 = it_1 -> it_1.setSpace(" ");
                    document.append(document.prepend(it, _function_6), _function_7);
                };
                this.textRegionExtensions.regionFor((EObject)body.getBody().getExport()).keywords(new String[]{";"}).forEach(_function_5);
                Consumer<statement> _function_6 = it -> {
                    Consumer<ISemanticRegion> _function_7 = it_1 -> {
                        Procedures.Procedure1 _function_8 = it_2 -> it_2.setSpace("");
                        Procedures.Procedure1 _function_9 = it_2 -> it_2.setSpace(" ");
                        document.append(document.prepend(it_1, _function_8), _function_9);
                    };
                    this.textRegionExtensions.regionFor((EObject)it).keywords(new String[]{";"}).forEach(_function_7);
                };
                body.getBody().getStatements().getRtllist().forEach(_function_6);
            } else if (this.textRegionExtensions.regionForEObject((EObject)sub.getBody().getBody()).getLength() > 0 && this.textRegionExtensions.isMultiline((EObject)sub.getBody().getBody())) {
                Consumer<statement> _function_7 = it -> {
                    Consumer<ISemanticRegion> _function_8 = it_1 -> {
                        if (it_1.getNextHiddenRegion() != null && it_1.getNextHiddenRegion().isMultiline()) {
                            Procedures.Procedure1 _function_9 = it_2 -> it_2.newLine();
                            document.append(it_1, _function_9);
                        } else {
                            Procedures.Procedure1 _function_10 = it_2 -> it_2.setSpace(" ");
                            document.append(it_1, _function_10);
                        }
                    };
                    this.textRegionExtensions.regionFor((EObject)it).keywords(new String[]{";"}).forEach(_function_8);
                };
                body.getBody().getStatements().getRtllist().forEach(_function_7);
                Consumer<ISemanticRegion> _function_8 = it -> {
                    if (it.getNextHiddenRegion() != null && it.getNextHiddenRegion().isMultiline()) {
                        Procedures.Procedure1 _function_9 = it_1 -> it_1.newLine();
                        document.append(it, _function_9);
                    } else {
                        Procedures.Procedure1 _function_10 = it_1 -> it_1.setSpace(" ");
                        document.append(it, _function_10);
                    }
                };
                this.textRegionExtensions.regionFor((EObject)body.getBody().getExport()).keywords(new String[]{";"}).forEach(_function_8);
                Consumer<statement> _function_9 = it -> {
                    if (this.textRegionExtensions.nextHiddenRegion((EObject)it) != null && this.textRegionExtensions.nextHiddenRegion((EObject)it).isMultiline()) {
                        Procedures.Procedure1 _function_10 = it_1 -> it_1.newLine();
                        document.append((EObject)it, _function_10);
                    } else {
                        Procedures.Procedure1 _function_11 = it_1 -> it_1.setSpace(" ");
                        document.append((EObject)it, _function_11);
                    }
                };
                body.getBody().getStatements().getRtllist().forEach(_function_9);
            }
        }
        this.computePrintLength(sub.getTableName().getName(), sub.getPrint());
        this.computeMatchLength(sub.getTableName().getName(), sub.getMatch(), sub.getCblock());
    }

    protected void _format(constructprint constructprint2, @Extension IFormattableDocument document) {
        EList<printpiece> _printpieces = constructprint2.getPrintpieces();
        for (printpiece printpieces : _printpieces) {
            this.format(printpieces, document);
        }
        this.format(constructprint2.getIs(), document);
    }

    protected void _format(printpiece printpiece2, @Extension IFormattableDocument document) {
        this.format(printpiece2.getSym(), document);
    }

    protected void _format(pexprAdd pexpradd, @Extension IFormattableDocument document) {
        this.format(pexpradd.getRight(), document);
        this.format(pexpradd.getLeft(), document);
    }

    protected void _format(pexprSub pexprsub, @Extension IFormattableDocument document) {
        this.format(pexprsub.getRight(), document);
        this.format(pexprsub.getLeft(), document);
    }

    protected void _format(pexprMult pexprmult, @Extension IFormattableDocument document) {
        this.format(pexprmult.getRight(), document);
        this.format(pexprmult.getLeft(), document);
    }

    protected void _format(pexprLeft pexprleft, @Extension IFormattableDocument document) {
        this.format(pexprleft.getRight(), document);
        this.format(pexprleft.getLeft(), document);
    }

    protected void _format(pexprRight pexprright, @Extension IFormattableDocument document) {
        this.format(pexprright.getRight(), document);
        this.format(pexprright.getLeft(), document);
    }

    protected void _format(pexprAnd pexprand, @Extension IFormattableDocument document) {
        this.format(pexprand.getRight(), document);
        this.format(pexprand.getLeft(), document);
    }

    protected void _format(pexprOr pexpror, @Extension IFormattableDocument document) {
        this.format(pexpror.getRight(), document);
        this.format(pexpror.getLeft(), document);
    }

    protected void _format(pexprXor pexprxor, @Extension IFormattableDocument document) {
        this.format(pexprxor.getRight(), document);
        this.format(pexprxor.getLeft(), document);
    }

    protected void _format(pexprDiv pexprdiv, @Extension IFormattableDocument document) {
        this.format(pexprdiv.getRight(), document);
        this.format(pexprdiv.getLeft(), document);
    }

    protected void _format(pexprNegate pexprnegate, @Extension IFormattableDocument document) {
        this.format(pexprnegate.getLeft(), document);
    }

    protected void _format(pexprInvert pexprinvert, @Extension IFormattableDocument document) {
        this.format(pexprinvert.getLeft(), document);
    }

    protected void _format(singlePexpression singlepexpression, @Extension IFormattableDocument document) {
        this.format(singlepexpression.getIntval(), document);
        this.format(singlepexpression.getSym(), document);
        this.format(singlepexpression.getRight(), document);
    }

    protected void _format(constraintAdd constraintadd, @Extension IFormattableDocument document) {
        this.format(constraintadd.getRight(), document);
        this.format(constraintadd.getLeft(), document);
    }

    protected void _format(constraintSub constraintsub, @Extension IFormattableDocument document) {
        this.format(constraintsub.getRight(), document);
        this.format(constraintsub.getLeft(), document);
    }

    protected void _format(constraintMult constraintmult, @Extension IFormattableDocument document) {
        this.format(constraintmult.getRight(), document);
        this.format(constraintmult.getLeft(), document);
    }

    protected void _format(constraintLeft constraintleft, @Extension IFormattableDocument document) {
        this.format(constraintleft.getRight(), document);
        this.format(constraintleft.getLeft(), document);
    }

    protected void _format(constraintRight constraintright, @Extension IFormattableDocument document) {
        this.format(constraintright.getRight(), document);
        this.format(constraintright.getLeft(), document);
    }

    protected void _format(constraintAnd constraintand, @Extension IFormattableDocument document) {
        this.format(constraintand.getRight(), document);
        this.format(constraintand.getLeft(), document);
    }

    protected void _format(constraintOr constraintor, @Extension IFormattableDocument document) {
        this.format(constraintor.getRight(), document);
        this.format(constraintor.getLeft(), document);
    }

    protected void _format(constraintXor constraintxor, @Extension IFormattableDocument document) {
        this.format(constraintxor.getRight(), document);
        this.format(constraintxor.getLeft(), document);
    }

    protected void _format(constraintDiv constraintdiv, @Extension IFormattableDocument document) {
        this.format(constraintdiv.getRight(), document);
        this.format(constraintdiv.getLeft(), document);
    }

    protected void _format(constraintNegate constraintnegate, @Extension IFormattableDocument document) {
        this.format(constraintnegate.getExpr(), document);
    }

    protected void _format(constraintInvert constraintinvert, @Extension IFormattableDocument document) {
        this.format(constraintinvert.getExpr(), document);
    }

    protected void _format(constraintSinglePexpression constraintsinglepexpression, @Extension IFormattableDocument document) {
        this.format(constraintsinglepexpression.getIntval(), document);
        this.format(constraintsinglepexpression.getSym(), document);
        this.format(constraintsinglepexpression.getRight(), document);
    }

    protected void _format(pequation pequation2, @Extension IFormattableDocument document) {
        this.format(pequation2.getConstraints(), document);
    }

    protected void _format(pNextSet pnextset, @Extension IFormattableDocument document) {
        this.format(pnextset.getRight(), document);
        this.format(pnextset.getLeft(), document);
    }

    protected void _format(pAnd pand, @Extension IFormattableDocument document) {
        this.format(pand.getRight(), document);
        this.format(pand.getLeft(), document);
    }

    protected void _format(pOr por, @Extension IFormattableDocument document) {
        this.format(por.getRight(), document);
        this.format(por.getLeft(), document);
    }

    protected void _format(atomic atomic2, @Extension IFormattableDocument document) {
        this.format(atomic2.getDefine(), document);
        this.format(atomic2.getRight(), document);
    }

    protected void _format(constraint constraint2, @Extension IFormattableDocument document) {
        this.format(constraint2.getValue(), document);
    }

    protected void _format(contextblock contextblock2, @Extension IFormattableDocument document) {
        this.format(contextblock2.getBlock(), document);
    }

    protected void _format(contextlist contextlist2, @Extension IFormattableDocument document) {
        EList<contextentry> _entry = contextlist2.getEntry();
        for (contextentry entry : _entry) {
            this.format(entry, document);
        }
    }

    protected void _format(contextentry contextentry2, @Extension IFormattableDocument document) {
        this.format(contextentry2.getRhs(), document);
        this.format(contextentry2.getTsym(), document);
    }

    protected void _format(OPERANDSYM operandsym, @Extension IFormattableDocument document) {
        this.format(operandsym.getRhs(), document);
    }

    protected void _format(xrtl xrtl2, @Extension IFormattableDocument document) {
        this.format(xrtl2.getStatements(), document);
        this.format(xrtl2.getExport(), document);
        this.format(xrtl2.getAdditionalStatements(), document);
    }

    protected void _format(exportStmt exportstmt, @Extension IFormattableDocument document) {
        this.format(exportstmt.getResultsize(), document);
        this.format(exportstmt.getResult(), document);
    }

    protected void _format(exportedSym exportedsym, @Extension IFormattableDocument document) {
        this.format(exportedsym.getVarnode(), document);
        this.format(exportedsym.getSize(), document);
        this.format(exportedsym.getConst(), document);
    }

    protected void _format(rtlmid rtlmid2, @Extension IFormattableDocument document) {
        EList<statement> _rtllist = rtlmid2.getRtllist();
        for (statement rtllist : _rtllist) {
            this.format(rtllist, document);
        }
        EList<macroUse> _macro = rtlmid2.getMacro();
        for (macroUse macro : _macro) {
            this.format(macro, document);
        }
    }

    protected void _format(statement statement2, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.setNewLines(0, 1, 2);
        document.prepend((EObject)statement2, _function);
        this.format(statement2.getSection_name(), document);
        this.format(statement2.getLhs(), document);
        this.format(statement2.getRhs(), document);
        this.format(statement2.getPtrsize(), document);
        this.format(statement2.getLhsexpr(), document);
        this.format(statement2.getStart(), document);
        this.format(statement2.getEnd(), document);
        this.format(statement2.getCrossvnode(), document);
        this.format(statement2.getDelayslot(), document);
        this.format(statement2.getDest(), document);
        this.format(statement2.getIfexpr(), document);
        this.format(statement2.getGotodest(), document);
        this.format(statement2.getArgs(), document);
        this.format(statement2.getLabel(), document);
    }

    protected void _format(assignSym assignsym, @Extension IFormattableDocument document) {
        this.format(assignsym.getLocal(), document);
        this.format(assignsym.getDefine(), document);
    }

    protected void _format(localDefine localdefine, @Extension IFormattableDocument document) {
        this.format(localdefine.getSym(), document);
        this.format(localdefine.getSize(), document);
    }

    protected void _format(exprrAdd exprradd, @Extension IFormattableDocument document) {
        this.format(exprradd.getRight(), document);
        this.format(exprradd.getLeft(), document);
    }

    protected void _format(exprMinus exprminus, @Extension IFormattableDocument document) {
        this.format(exprminus.getRight(), document);
        this.format(exprminus.getLeft(), document);
    }

    protected void _format(exprEqual exprequal, @Extension IFormattableDocument document) {
        this.format(exprequal.getRight(), document);
        this.format(exprequal.getLeft(), document);
    }

    protected void _format(exprNotEqual exprnotequal, @Extension IFormattableDocument document) {
        this.format(exprnotequal.getRight(), document);
        this.format(exprnotequal.getLeft(), document);
    }

    protected void _format(exprLess exprless, @Extension IFormattableDocument document) {
        this.format(exprless.getRight(), document);
        this.format(exprless.getLeft(), document);
    }

    protected void _format(exprGtEqual exprgtequal, @Extension IFormattableDocument document) {
        this.format(exprgtequal.getRight(), document);
        this.format(exprgtequal.getLeft(), document);
    }

    protected void _format(exprLtEqual exprltequal, @Extension IFormattableDocument document) {
        this.format(exprltequal.getRight(), document);
        this.format(exprltequal.getLeft(), document);
    }

    protected void _format(exprGt exprgt, @Extension IFormattableDocument document) {
        this.format(exprgt.getRight(), document);
        this.format(exprgt.getLeft(), document);
    }

    protected void _format(exprSLess exprsless, @Extension IFormattableDocument document) {
        this.format(exprsless.getRight(), document);
        this.format(exprsless.getLeft(), document);
    }

    protected void _format(exprSGtEqual exprsgtequal, @Extension IFormattableDocument document) {
        this.format(exprsgtequal.getRight(), document);
        this.format(exprsgtequal.getLeft(), document);
    }

    protected void _format(exprSLtEqual exprsltequal, @Extension IFormattableDocument document) {
        this.format(exprsltequal.getRight(), document);
        this.format(exprsltequal.getLeft(), document);
    }

    protected void _format(exprSGt exprsgt, @Extension IFormattableDocument document) {
        this.format(exprsgt.getRight(), document);
        this.format(exprsgt.getLeft(), document);
    }

    protected void _format(exprXor exprxor, @Extension IFormattableDocument document) {
        this.format(exprxor.getRight(), document);
        this.format(exprxor.getLeft(), document);
    }

    protected void _format(exprAnd exprand, @Extension IFormattableDocument document) {
        this.format(exprand.getRight(), document);
        this.format(exprand.getLeft(), document);
    }

    protected void _format(exprOr expror, @Extension IFormattableDocument document) {
        this.format(expror.getRight(), document);
        this.format(expror.getLeft(), document);
    }

    protected void _format(exprLeft exprleft, @Extension IFormattableDocument document) {
        this.format(exprleft.getRight(), document);
        this.format(exprleft.getLeft(), document);
    }

    protected void _format(exprRight exprright, @Extension IFormattableDocument document) {
        this.format(exprright.getRight(), document);
        this.format(exprright.getLeft(), document);
    }

    protected void _format(exprSRight exprsright, @Extension IFormattableDocument document) {
        this.format(exprsright.getRight(), document);
        this.format(exprsright.getLeft(), document);
    }

    protected void _format(exprMult exprmult, @Extension IFormattableDocument document) {
        this.format(exprmult.getRight(), document);
        this.format(exprmult.getLeft(), document);
    }

    protected void _format(exprDiv exprdiv, @Extension IFormattableDocument document) {
        this.format(exprdiv.getRight(), document);
        this.format(exprdiv.getLeft(), document);
    }

    protected void _format(exprSDiv exprsdiv, @Extension IFormattableDocument document) {
        this.format(exprsdiv.getRight(), document);
        this.format(exprsdiv.getLeft(), document);
    }

    protected void _format(exprRem exprrem, @Extension IFormattableDocument document) {
        this.format(exprrem.getRight(), document);
        this.format(exprrem.getLeft(), document);
    }

    protected void _format(exprSRem exprsrem, @Extension IFormattableDocument document) {
        this.format(exprsrem.getRight(), document);
        this.format(exprsrem.getLeft(), document);
    }

    protected void _format(exprBoolXor exprboolxor, @Extension IFormattableDocument document) {
        this.format(exprboolxor.getRight(), document);
        this.format(exprboolxor.getLeft(), document);
    }

    protected void _format(exprBoolAnd exprbooland, @Extension IFormattableDocument document) {
        this.format(exprbooland.getRight(), document);
        this.format(exprbooland.getLeft(), document);
    }

    protected void _format(exprBoolOr exprboolor, @Extension IFormattableDocument document) {
        this.format(exprboolor.getRight(), document);
        this.format(exprboolor.getLeft(), document);
    }

    protected void _format(exprFEqual exprfequal, @Extension IFormattableDocument document) {
        this.format(exprfequal.getRight(), document);
        this.format(exprfequal.getLeft(), document);
    }

    protected void _format(exprFNotEqual exprfnotequal, @Extension IFormattableDocument document) {
        this.format(exprfnotequal.getRight(), document);
        this.format(exprfnotequal.getLeft(), document);
    }

    protected void _format(exprFLess exprfless, @Extension IFormattableDocument document) {
        this.format(exprfless.getRight(), document);
        this.format(exprfless.getLeft(), document);
    }

    protected void _format(exprFGt exprfgt, @Extension IFormattableDocument document) {
        this.format(exprfgt.getRight(), document);
        this.format(exprfgt.getLeft(), document);
    }

    protected void _format(exprFLessEqual exprflessequal, @Extension IFormattableDocument document) {
        this.format(exprflessequal.getRight(), document);
        this.format(exprflessequal.getLeft(), document);
    }

    protected void _format(exprFGtEqual exprfgtequal, @Extension IFormattableDocument document) {
        this.format(exprfgtequal.getRight(), document);
        this.format(exprfgtequal.getLeft(), document);
    }

    protected void _format(exprFAdd exprfadd, @Extension IFormattableDocument document) {
        this.format(exprfadd.getRight(), document);
        this.format(exprfadd.getLeft(), document);
    }

    protected void _format(exprFSub exprfsub, @Extension IFormattableDocument document) {
        this.format(exprfsub.getRight(), document);
        this.format(exprfsub.getLeft(), document);
    }

    protected void _format(exprFMult exprfmult, @Extension IFormattableDocument document) {
        this.format(exprfmult.getRight(), document);
        this.format(exprfmult.getLeft(), document);
    }

    protected void _format(exprFDiv exprfdiv, @Extension IFormattableDocument document) {
        this.format(exprfdiv.getRight(), document);
        this.format(exprfdiv.getLeft(), document);
    }

    protected void _format(exprNegate exprnegate, @Extension IFormattableDocument document) {
        this.format(exprnegate.getExpr(), document);
    }

    protected void _format(exprFNegate exprfnegate, @Extension IFormattableDocument document) {
        this.format(exprfnegate.getExpr(), document);
    }

    protected void _format(exprLoad exprload, @Extension IFormattableDocument document) {
        this.format(exprload.getLoc(), document);
        this.format(exprload.getExpr(), document);
    }

    protected void _format(Expression expression, @Extension IFormattableDocument document) {
        this.format(expression.getVnode(), document);
        this.format(expression.getRight(), document);
        this.format(expression.getOp1(), document);
        this.format(expression.getOp2(), document);
    }

    protected void _format(exprSym exprsym, @Extension IFormattableDocument document) {
        this.format(exprsym.getSize(), document);
        this.format(exprsym.getStart(), document);
        this.format(exprsym.getEnd(), document);
        this.format(exprsym.getInode(), document);
    }

    protected void _format(sizedstar sizedstar2, @Extension IFormattableDocument document) {
        this.format(sizedstar2.getSpace(), document);
        this.format(sizedstar2.getSize(), document);
    }

    protected void _format(jumpdest jumpdest2, @Extension IFormattableDocument document) {
        this.format(jumpdest2.getInst_start(), document);
        this.format(jumpdest2.getInst_end(), document);
        this.format(jumpdest2.getConst(), document);
        this.format(jumpdest2.getSpace(), document);
    }

    protected void _format(integervarnode integervarnode2, @Extension IFormattableDocument document) {
        this.format(integervarnode2.getReladdr(), document);
        this.format(integervarnode2.getConst(), document);
        this.format(integervarnode2.getSize(), document);
        this.format(integervarnode2.getInode(), document);
    }

    protected void _format(intblist intblist2, @Extension IFormattableDocument document) {
        EList<intbpart> _args = intblist2.getArgs();
        for (intbpart args : _args) {
            this.format(args, document);
        }
    }

    protected void _format(intbpart intbpart2, @Extension IFormattableDocument document) {
        this.format(intbpart2.getValue(), document);
    }

    protected void _format(anystringlist anystringlist2, @Extension IFormattableDocument document) {
        EList<anystringpart> _namelist = anystringlist2.getNamelist();
        for (anystringpart namelist : _namelist) {
            this.format(namelist, document);
        }
    }

    protected void _format(anystringpart anystringpart2, @Extension IFormattableDocument document) {
        this.format(anystringpart2.getSym(), document);
    }

    protected void _format(valuesymlist valuesymlist2, @Extension IFormattableDocument document) {
        EList<valuepart> _valuelist = valuesymlist2.getValuelist();
        for (valuepart valuelist : _valuelist) {
            this.format(valuelist, document);
        }
        this.format(valuesymlist2.getValue(), document);
    }

    protected void _format(namesymlist namesymlist2, @Extension IFormattableDocument document) {
        EList<NAMESYM> _valuelist = namesymlist2.getValuelist();
        for (NAMESYM valuelist : _valuelist) {
            this.format(valuelist, document);
        }
        this.format(namesymlist2.getValue(), document);
    }

    protected void _format(varsymlist varsymlist2, @Extension IFormattableDocument document) {
        EList<valuepartdef> _valuelist = varsymlist2.getValuelist();
        for (valuepartdef valuelist : _valuelist) {
            this.format(valuelist, document);
        }
    }

    protected void _format(varlist varlist2, @Extension IFormattableDocument document) {
        EList<varpart> _varDefList = varlist2.getVarDefList();
        for (varpart varDefList : _varDefList) {
            this.format(varDefList, document);
        }
    }

    protected void _format(paramlist paramlist2, @Extension IFormattableDocument document) {
        EList<Expression> _parameters = paramlist2.getParameters();
        for (Expression parameters : _parameters) {
            this.format(parameters, document);
        }
    }

    protected void _format(oplist oplist2, @Extension IFormattableDocument document) {
        EList<MACROPARAMSYM> _args = oplist2.getArgs();
        for (MACROPARAMSYM args : _args) {
            this.format(args, document);
        }
    }

    protected void _format(anysymbol anysymbol2, @Extension IFormattableDocument document) {
        this.format(anysymbol2.getSym(), document);
    }

    protected void _format(integerValue integervalue, @Extension IFormattableDocument document) {
        this.format(integervalue.getSym(), document);
    }

    protected void _format(elleqRight elleqright, @Extension IFormattableDocument document) {
        this.format(elleqright.getLeft(), document);
    }

    public void format(Object constraintsinglepexpression, IFormattableDocument document) {
        if (constraintsinglepexpression instanceof constraintSinglePexpression) {
            this._format((constraintSinglePexpression)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof singlePexpression) {
            this._format((singlePexpression)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof constraintInvert) {
            this._format((constraintInvert)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pexprInvert) {
            this._format((pexprInvert)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof constraintNegate) {
            this._format((constraintNegate)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pexprNegate) {
            this._format((pexprNegate)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof constraintDiv) {
            this._format((constraintDiv)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pexprDiv) {
            this._format((pexprDiv)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof constraintXor) {
            this._format((constraintXor)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pexprXor) {
            this._format((pexprXor)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof constraintOr) {
            this._format((constraintOr)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pexprOr) {
            this._format((pexprOr)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof constraint) {
            this._format((constraint)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof constraintAnd) {
            this._format((constraintAnd)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pexprAnd) {
            this._format((pexprAnd)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof atomic) {
            this._format((atomic)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof constraintRight) {
            this._format((constraintRight)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pexprRight) {
            this._format((pexprRight)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof constraintLeft) {
            this._format((constraintLeft)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pexprLeft) {
            this._format((pexprLeft)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof baseconstructor) {
            this._format((baseconstructor)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof constraintMult) {
            this._format((constraintMult)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof elleqRight) {
            this._format((elleqRight)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pexprMult) {
            this._format((pexprMult)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof spaceprop) {
            this._format((spaceprop)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof subconstructor) {
            this._format((subconstructor)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof bitrangedef) {
            this._format((bitrangedef)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof bitrangesingle) {
            this._format((bitrangesingle)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof constraintSub) {
            this._format((constraintSub)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof contextdef) {
            this._format((contextdef)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof contextfielddef) {
            this._format((contextfielddef)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof fielddef) {
            this._format((fielddef)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof macrodef) {
            this._format((macrodef)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof nameattach) {
            this._format((nameattach)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pOr) {
            this._format((pOr)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pcodeopdef) {
            this._format((pcodeopdef)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pexprSub) {
            this._format((pexprSub)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof tokendef) {
            this._format((tokendef)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof valueattach) {
            this._format((valueattach)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof varattach) {
            this._format((varattach)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof varnodedef) {
            this._format((varnodedef)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof XtextResource) {
            this._format((XtextResource)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof OPERANDSYM) {
            this._format((OPERANDSYM)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof aligndef) {
            this._format((aligndef)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof assignSym) {
            this._format((assignSym)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof constraintAdd) {
            this._format((constraintAdd)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof contextDefs) {
            this._format((contextDefs)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof endiandef) {
            this._format((endiandef)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprAnd) {
            this._format((exprAnd)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprBoolAnd) {
            this._format((exprBoolAnd)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprBoolOr) {
            this._format((exprBoolOr)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprBoolXor) {
            this._format((exprBoolXor)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprDiv) {
            this._format((exprDiv)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprEqual) {
            this._format((exprEqual)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprFAdd) {
            this._format((exprFAdd)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprFDiv) {
            this._format((exprFDiv)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprFEqual) {
            this._format((exprFEqual)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprFGt) {
            this._format((exprFGt)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprFGtEqual) {
            this._format((exprFGtEqual)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprFLess) {
            this._format((exprFLess)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprFLessEqual) {
            this._format((exprFLessEqual)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprFMult) {
            this._format((exprFMult)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprFNegate) {
            this._format((exprFNegate)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprFNotEqual) {
            this._format((exprFNotEqual)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprFSub) {
            this._format((exprFSub)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprGt) {
            this._format((exprGt)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprGtEqual) {
            this._format((exprGtEqual)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprLeft) {
            this._format((exprLeft)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprLess) {
            this._format((exprLess)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprLoad) {
            this._format((exprLoad)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprLtEqual) {
            this._format((exprLtEqual)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprMinus) {
            this._format((exprMinus)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprMult) {
            this._format((exprMult)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprNegate) {
            this._format((exprNegate)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprNotEqual) {
            this._format((exprNotEqual)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprOr) {
            this._format((exprOr)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprRem) {
            this._format((exprRem)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprRight) {
            this._format((exprRight)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprSDiv) {
            this._format((exprSDiv)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprSGt) {
            this._format((exprSGt)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprSGtEqual) {
            this._format((exprSGtEqual)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprSLess) {
            this._format((exprSLess)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprSLtEqual) {
            this._format((exprSLtEqual)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprSRem) {
            this._format((exprSRem)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprSRight) {
            this._format((exprSRight)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprXor) {
            this._format((exprXor)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprrAdd) {
            this._format((exprrAdd)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof integervarnode) {
            this._format((integervarnode)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof macroDefine) {
            this._format((macroDefine)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof macroUse) {
            this._format((macroUse)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pAnd) {
            this._format((pAnd)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pexprAdd) {
            this._format((pexprAdd)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof DefineTest) {
            this._format((DefineTest)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof Expression) {
            this._format((Expression)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof Model) {
            this._format((Model)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof anystringlist) {
            this._format((anystringlist)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof anystringpart) {
            this._format((anystringpart)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof anysymbol) {
            this._format((anysymbol)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof bitrangelist) {
            this._format((bitrangelist)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof constructprint) {
            this._format((constructprint)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof contextblock) {
            this._format((contextblock)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof contextentry) {
            this._format((contextentry)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof contextlist) {
            this._format((contextlist)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exportStmt) {
            this._format((exportStmt)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exportedSym) {
            this._format((exportedSym)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof exprSym) {
            this._format((exprSym)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof intblist) {
            this._format((intblist)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof intbpart) {
            this._format((intbpart)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof integerValue) {
            this._format((integerValue)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof jumpdest) {
            this._format((jumpdest)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof localDefine) {
            this._format((localDefine)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof namesymlist) {
            this._format((namesymlist)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof oplist) {
            this._format((oplist)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pNextSet) {
            this._format((pNextSet)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof paramlist) {
            this._format((paramlist)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof pequation) {
            this._format((pequation)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof printpiece) {
            this._format((printpiece)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof rtlbody) {
            this._format((rtlbody)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof rtlmid) {
            this._format((rtlmid)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof sizedstar) {
            this._format((sizedstar)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof statement) {
            this._format((statement)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof tokenprop) {
            this._format((tokenprop)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof valuesymlist) {
            this._format((valuesymlist)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof vardef) {
            this._format((vardef)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof vardeflist) {
            this._format((vardeflist)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof varlist) {
            this._format((varlist)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof varsymlist) {
            this._format((varsymlist)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof xrtl) {
            this._format((xrtl)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression instanceof EObject) {
            this._format((EObject)constraintsinglepexpression, document);
            return;
        }
        if (constraintsinglepexpression == null) {
            this._format(null, document);
            return;
        }
        if (constraintsinglepexpression != null) {
            this._format(constraintsinglepexpression, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(constraintsinglepexpression, document).toString());
    }
}

