/*
 * Decompiled with CFR 0.152.
 */
package ghidra.xtext.sleigh.scoping;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import ghidra.xtext.sleigh.sleigh.LOCALSYM;
import ghidra.xtext.sleigh.sleigh.aliasSym;
import ghidra.xtext.sleigh.sleigh.assignSym;
import ghidra.xtext.sleigh.sleigh.constraint;
import ghidra.xtext.sleigh.sleigh.constructor;
import ghidra.xtext.sleigh.sleigh.contextblock;
import ghidra.xtext.sleigh.sleigh.contextentry;
import ghidra.xtext.sleigh.sleigh.exportedSym;
import ghidra.xtext.sleigh.sleigh.exprSym;
import ghidra.xtext.sleigh.sleigh.globalLoc;
import ghidra.xtext.sleigh.sleigh.macrodef;
import ghidra.xtext.sleigh.sleigh.pexprSym;
import ghidra.xtext.sleigh.sleigh.printpiece;
import ghidra.xtext.sleigh.sleigh.rtlbody;
import ghidra.xtext.sleigh.sleigh.rtlmid;
import ghidra.xtext.sleigh.sleigh.statement;
import ghidra.xtext.sleigh.sleigh.xrtl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.ScopeBasedSelectable;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;

public class SleighScopeProvider
extends AbstractDeclarativeScopeProvider {
    public IScope getScope(EObject context, EReference ref) {
        IScope scope = super.getScope(context, ref);
        return scope;
    }

    public IScope scope_assignSym_symref(assignSym context, EReference eReference) {
        IScope localScope = this.symbolsDefinedBefore(context.eContainer(), context);
        rtlbody cont = (rtlbody)EcoreUtil2.getContainerOfType((EObject)context, rtlbody.class);
        IScope superscope = super.getDelegate().getScope((EObject)cont, eReference);
        return this.createFilteredLocalScope(superscope, localScope, eReference);
    }

    public IScope scope_exprSym_vnode(exprSym context, EReference eReference) {
        IScope localScope = this.symbolsDefinedBefore(context.eContainer(), context);
        rtlbody cont = (rtlbody)EcoreUtil2.getContainerOfType((EObject)context, rtlbody.class);
        IScope superscope = super.getDelegate().getScope((EObject)cont, eReference);
        return this.createFilteredLocalScope(superscope, localScope, eReference);
    }

    public IScope scope_exportedSym_symref(exportedSym context, EReference eReference) {
        IScope _xblockexpression = null;
        IScope localScope = this.symbolsDefinedBefore(context.eContainer(), context);
        rtlbody cont = (rtlbody)EcoreUtil2.getContainerOfType((EObject)context, rtlbody.class);
        IScope superscope = super.getDelegate().getScope((EObject)cont, eReference);
        _xblockexpression = this.createFilteredLocalScope(superscope, localScope, eReference);
        return _xblockexpression;
    }

    public IScope scope_pexprSym_sym(pexprSym context, EReference eReference) {
        IScope _xblockexpression = null;
        IScope localScope = this.symbolsDefinedBefore(context.eContainer(), context);
        constructor cont = (constructor)EcoreUtil2.getContainerOfType((EObject)context, constructor.class);
        IScope superscope = super.getDelegate().getScope((EObject)cont, eReference);
        _xblockexpression = this.createFilteredLocalScope(superscope, localScope, eReference);
        return _xblockexpression;
    }

    public IScope scope_constraint_sym(constraint context, EReference eReference) {
        IScope scope;
        IScope _xblockexpression = null;
        constructor cont = (constructor)EcoreUtil2.getContainerOfType((EObject)context, constructor.class);
        IScope superscope = super.getDelegate().getScope((EObject)cont, eReference);
        _xblockexpression = scope = this.createFilteredLocalScope(superscope, IScope.NULLSCOPE, eReference);
        return _xblockexpression;
    }

    public IScope scope_aliasSym_symref(aliasSym context, EReference eReference) {
        IScope localScope;
        IScope _xblockexpression = null;
        constructor cont = (constructor)EcoreUtil2.getContainerOfType((EObject)context, constructor.class);
        _xblockexpression = localScope = this.printPieceScope(cont, IScope.NULLSCOPE);
        return _xblockexpression;
    }

    public IScope scope_contextentry_lhs(contextentry context, EReference eReference) {
        IScope _xblockexpression = null;
        constructor cont = (constructor)EcoreUtil2.getContainerOfType((EObject)context, constructor.class);
        IScope localScope = this.printPieceScope(cont, IScope.NULLSCOPE);
        IScope superscope = super.getDelegate().getScope((EObject)cont, eReference);
        _xblockexpression = this.createFilteredLocalScope(superscope, localScope, eReference);
        return _xblockexpression;
    }

    public IScope scope_globalLoc_tsym(globalLoc context, EReference eReference) {
        IScope _xblockexpression = null;
        constructor cont = (constructor)EcoreUtil2.getContainerOfType((EObject)context, constructor.class);
        IScope localScope = this.printPieceScope(cont, IScope.NULLSCOPE);
        IScope superscope = super.getDelegate().getScope((EObject)cont, eReference);
        _xblockexpression = this.createFilteredLocalScope(superscope, localScope, eReference);
        return _xblockexpression;
    }

    public IScope createFilteredLocalScope(IScope supscope, IScope localScope, EReference eReference) {
        IScope scope;
        IScope _xblockexpression = null;
        FilteringScope filtscope = new FilteringScope(supscope, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                EObject sym = input.getEObjectOrProxy();
                boolean notAliasOrLocal = !(sym instanceof LOCALSYM) && !(sym instanceof aliasSym);
                return notAliasOrLocal;
            }
        });
        ScopeBasedSelectable _scopeBasedSelectable = new ScopeBasedSelectable((IScope)filtscope);
        _xblockexpression = scope = SelectableBasedScope.createScope((IScope)localScope, (ISelectable)_scopeBasedSelectable, (EClass)eReference.getEReferenceType(), (boolean)false);
        return _xblockexpression;
    }

    protected IScope _symbolsDefinedBefore(EObject context, EObject o) {
        return this.symbolsDefinedBefore(context.eContainer(), o);
    }

    protected IScope _symbolsDefinedBefore(macrodef context, EObject o) {
        return Scopes.scopeFor(context.getArgs().getArgs(), (IScope)this.symbolsDefinedBefore(context, o.eContainer()));
    }

    protected IScope _symbolsDefinedBefore(constructor s, EObject o) {
        IScope _xblockexpression = null;
        IScope scope = Scopes.scopeFor((Iterable)s.eContents());
        _xblockexpression = this.printPieceScope(s, scope);
        return _xblockexpression;
    }

    protected IScope _symbolsDefinedBefore(contextblock s, EObject o) {
        IScope _xblockexpression = null;
        IScope scope = Scopes.scopeFor((Iterable)s.eContents(), (IScope)this.symbolsDefinedBefore(s.eContainer(), o.eContainer()));
        constructor cont = (constructor)EcoreUtil2.getContainerOfType((EObject)s, constructor.class);
        _xblockexpression = this.printPieceScope(cont, scope);
        return _xblockexpression;
    }

    protected IScope _symbolsDefinedBefore(rtlbody b, EObject o) {
        IScope _xblockexpression = null;
        IScope scope = Scopes.scopeFor(this.variablesDeclaredBefore((List<statement>)b.getBody().getStatements().getRtllist(), o));
        constructor cont = (constructor)EcoreUtil2.getContainerOfType((EObject)b, constructor.class);
        _xblockexpression = this.printPieceScope(cont, scope);
        return _xblockexpression;
    }

    protected IScope _symbolsDefinedBefore(rtlmid b, EObject o) {
        return this.symbolsDefinedBefore(b.eContainer(), o);
    }

    protected IScope _symbolsDefinedBefore(xrtl b, EObject o) {
        boolean _notEquals;
        IScope _xblockexpression = null;
        List<LOCALSYM> syms = this.variablesDeclaredBefore((List<statement>)b.getStatements().getRtllist(), null);
        rtlmid _additionalStatements = b.getAdditionalStatements();
        boolean bl = _notEquals = !Objects.equal((Object)_additionalStatements, null);
        if (_notEquals) {
            syms.addAll(this.variablesDeclaredBefore((List<statement>)b.getAdditionalStatements().getRtllist(), null));
        }
        IScope scope = Scopes.scopeFor(syms);
        constructor cont = (constructor)EcoreUtil2.getContainerOfType((EObject)b, constructor.class);
        _xblockexpression = this.printPieceScope(cont, scope);
        return _xblockexpression;
    }

    public IScope printPieceScope(constructor cont, IScope outerScope) {
        IScope localScope;
        IScope _xblockexpression = null;
        boolean _equals = Objects.equal((Object)cont, null);
        if (_equals) {
            return outerScope;
        }
        List<aliasSym> vars = this.variablesDeclaredIn(cont);
        Function q = QualifiedName.wrapper((Function)new Function<aliasSym, String>(){

            public String apply(aliasSym input) {
                String _xblockexpression = null;
                boolean _equals = Objects.equal((Object)input, null);
                if (_equals) {
                    return null;
                }
                _xblockexpression = input.getSym();
                return _xblockexpression;
            }
        });
        _xblockexpression = localScope = Scopes.scopeFor(vars, (Function)q, (IScope)outerScope);
        return _xblockexpression;
    }

    private List<aliasSym> variablesDeclaredIn(constructor b) {
        Iterator iter = b.getPrint().getPrintpieces().iterator();
        ArrayList<aliasSym> list = new ArrayList<aliasSym>();
        while (iter.hasNext()) {
            printpiece piece = (printpiece)iter.next();
            aliasSym _sym = piece.getSym();
            if (!(_sym instanceof aliasSym)) continue;
            list.add(piece.getSym());
        }
        return list;
    }

    private List<LOCALSYM> variablesDeclaredBefore(List<statement> list, EObject o) {
        boolean _notEquals;
        int _size = list.size();
        int end = _size - 1;
        boolean bl = _notEquals = !Objects.equal((Object)o, null);
        if (_notEquals) {
            end = list.indexOf(o);
        }
        List<statement> sublist = list.subList(0, end + 1);
        Iterator<statement> iter = sublist.iterator();
        ArrayList<LOCALSYM> locList = new ArrayList<LOCALSYM>();
        while (iter.hasNext()) {
            statement obj = iter.next();
            if (!(obj instanceof statement)) continue;
            statement stmt = obj;
            if (!Objects.equal((Object)stmt.getLhs(), null) && !Objects.equal((Object)stmt.getLhs().getLocal(), null) && stmt.getLhs().getLocal().getSym() instanceof LOCALSYM) {
                LOCALSYM _sym = stmt.getLhs().getLocal().getSym();
                locList.add(_sym);
            }
            if (Objects.equal((Object)stmt.getLdef(), null) || !(stmt.getLdef().getSym() instanceof LOCALSYM)) continue;
            LOCALSYM _sym_1 = stmt.getLdef().getSym();
            locList.add(_sym_1);
        }
        return locList;
    }

    public IScope symbolsDefinedBefore(EObject s, EObject o) {
        if (s instanceof constructor) {
            return this._symbolsDefinedBefore((constructor)s, o);
        }
        if (s instanceof macrodef) {
            return this._symbolsDefinedBefore((macrodef)s, o);
        }
        if (s instanceof contextblock) {
            return this._symbolsDefinedBefore((contextblock)s, o);
        }
        if (s instanceof rtlbody) {
            return this._symbolsDefinedBefore((rtlbody)s, o);
        }
        if (s instanceof rtlmid) {
            return this._symbolsDefinedBefore((rtlmid)s, o);
        }
        if (s instanceof xrtl) {
            return this._symbolsDefinedBefore((xrtl)s, o);
        }
        if (s != null) {
            return this._symbolsDefinedBefore(s, o);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(s, o).toString());
    }
}

