/*
 * Decompiled with CFR 0.152.
 */
package ghidra.xtext.sleigh.validation;

import com.google.common.base.Objects;
import ghidra.xtext.sleigh.sleigh.Model;
import ghidra.xtext.sleigh.sleigh.SleighPackage;
import ghidra.xtext.sleigh.sleigh.VARSYM;
import ghidra.xtext.sleigh.sleigh.constraint;
import ghidra.xtext.sleigh.sleigh.contextdef;
import ghidra.xtext.sleigh.sleigh.contextfielddef;
import ghidra.xtext.sleigh.sleigh.fielddef;
import ghidra.xtext.sleigh.sleigh.tokendef;
import ghidra.xtext.sleigh.sleigh.vardef;
import ghidra.xtext.sleigh.sleigh.varnodedef;
import ghidra.xtext.sleigh.validation.AbstractSleighValidator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;

public class SleighValidator
extends AbstractSleighValidator {
    private HashMap<Object, HashMap<String, HashSet<Object>>> typeMap;

    @Check
    public void checkModelInitialize(Model m) {
        HashMap _hashMap = new HashMap();
        this.typeMap = _hashMap;
    }

    public boolean addNameEntryToSet(HashMap<String, HashSet<Object>> map, String name, Object other) {
        boolean _xblockexpression = false;
        HashSet<Object> set = map.get(name);
        boolean _equals = Objects.equal(set, null);
        if (_equals) {
            HashSet _hashSet = new HashSet();
            set = _hashSet;
            map.put(name, set);
        }
        _xblockexpression = set.add(other);
        return _xblockexpression;
    }

    @Check
    public void checkTokenNameIsUnique(fielddef f) {
        boolean _checkDuplicate = this.checkDuplicate(f);
        if (_checkDuplicate) {
            this.warning("token field names have to be unique", (EStructuralFeature)SleighPackage.eINSTANCE.getfielddef_Name());
            return;
        }
    }

    public boolean checkDuplicate(fielddef f) {
        HashSet<Object> set;
        Class<tokendef> type = tokendef.class;
        HashMap<String, HashSet<Object>> map = this.typeMap.get(type);
        boolean _equals = Objects.equal(map, null);
        if (_equals) {
            HashMap _hashMap = new HashMap();
            map = _hashMap;
            this.typeMap.put(type, map);
            List defList = EcoreUtil2.getAllContentsOfType((EObject)EcoreUtil.getRootContainer((EObject)f, (boolean)true), type);
            for (tokendef def : defList) {
                for (fielddef other : EcoreUtil2.getAllContentsOfType((EObject)def, fielddef.class)) {
                    String name = other.getName();
                    this.addNameEntryToSet(map, name, other);
                }
            }
        }
        return !Objects.equal(set = map.get(f.getName()), null) && set.size() > 1;
    }

    @Check
    public void checkTokenNameIsUnique(contextfielddef f) {
        boolean _checkDuplicate = this.checkDuplicate(f);
        if (_checkDuplicate) {
            this.warning("context field names have to be unique", (EStructuralFeature)SleighPackage.eINSTANCE.getcontextfielddef_Name());
            return;
        }
    }

    public boolean checkDuplicate(contextfielddef f) {
        HashSet<Object> set;
        Class<contextdef> type = contextdef.class;
        HashMap<String, HashSet<Object>> map = this.typeMap.get(type);
        boolean _equals = Objects.equal(map, null);
        if (_equals) {
            HashMap _hashMap = new HashMap();
            map = _hashMap;
            this.typeMap.put(type, map);
            List defList = EcoreUtil2.getAllContentsOfType((EObject)EcoreUtil.getRootContainer((EObject)f, (boolean)true), type);
            for (contextdef def : defList) {
                for (contextfielddef other : EcoreUtil2.getAllContentsOfType((EObject)def, contextfielddef.class)) {
                    String name = other.getName();
                    this.addNameEntryToSet(map, name, other);
                }
            }
        }
        return !Objects.equal(set = map.get(f.getName()), null) && set.size() > 1;
    }

    @Check
    public void checkTokenNameIsUnique(VARSYM v) {
        boolean _checkDuplicate = this.checkDuplicate(v);
        if (_checkDuplicate) {
            this.warning("var names have to be unique", (EStructuralFeature)SleighPackage.eINSTANCE.getVARSYM_Name());
            return;
        }
    }

    public boolean checkDuplicate(VARSYM v) {
        HashSet<Object> set;
        Class<varnodedef> type = varnodedef.class;
        HashMap<String, HashSet<Object>> map = this.typeMap.get(type);
        boolean _equals = Objects.equal(map, null);
        if (_equals) {
            HashMap _hashMap = new HashMap();
            map = _hashMap;
            this.typeMap.put(type, map);
            List defList = EcoreUtil2.getAllContentsOfType((EObject)EcoreUtil.getRootContainer((EObject)v, (boolean)true), type);
            for (varnodedef def : defList) {
                for (vardef other : EcoreUtil2.getAllContentsOfType((EObject)def, vardef.class)) {
                    String name = other.getVarname().getName();
                    this.addNameEntryToSet(map, name, other);
                }
            }
        }
        return !Objects.equal(set = map.get(v.getName()), null) && set.size() > 1;
    }

    @Check
    public void checkWarnExpensiveOperation(constraint c) {
        String op = c.getCompareOp();
        if (Objects.equal((Object)op, null) || op.equals("=")) {
            return;
        }
        this.warning("comparison can be expensive, and should be used sparingly", (EStructuralFeature)SleighPackage.eINSTANCE.getconstraint_CompareOp());
    }
}

