/*
 * Decompiled with CFR 0.152.
 */
package ghidra.xtext.sleigh.ui;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import ghidra.xtext.sleigh.sleigh.DefineSym;
import ghidra.xtext.sleigh.sleigh.SUBTABLESYM;
import ghidra.xtext.sleigh.sleigh.aliasSym;
import ghidra.xtext.sleigh.sleigh.integerValue;
import ghidra.xtext.sleigh.sleigh.macroDefine;
import ghidra.xtext.sleigh.sleigh.printpiece;
import ghidra.xtext.sleigh.sleigh.subconstructor;
import java.math.BigInteger;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class SleighEObjectHoverProvider
extends DefaultEObjectHoverProvider {
    private EObject model;

    public boolean hasHover(EObject o) {
        if (o instanceof integerValue) {
            return true;
        }
        return super.hasHover(o);
    }

    public String getFirstLine(EObject o) {
        String label = this.getLabel(o);
        String str = o.eClass().getName();
        boolean _equals = Objects.equal((Object)label, null);
        if (_equals) {
            String _str = str;
            str = String.valueOf(_str);
        } else {
            str = " <b>" + label + "</b>";
        }
        return str;
    }

    public String getLabel(EObject element) {
        if (element instanceof DefineSym) {
            String _name = ((DefineSym)element).getName();
            String _plus = " <b>" + _name;
            return String.valueOf(_plus) + "</b>";
        }
        return super.getLabel(element);
    }

    public String getDocumentation(EObject element) {
        boolean _matched = false;
        if (element instanceof DefineSym) {
            _matched = true;
            return this.getDefineSymText((DefineSym)element);
        }
        if (!_matched && element instanceof SUBTABLESYM) {
            _matched = true;
            return this.getSubTableText((SUBTABLESYM)element);
        }
        if (!_matched && element instanceof aliasSym) {
            _matched = true;
            return this.getSubTableText((aliasSym)element);
        }
        if (!_matched && element instanceof integerValue) {
            _matched = true;
            return this.getIntegerFormats((integerValue)element);
        }
        return super.getDocumentation(element);
    }

    public String getIntegerFormats(integerValue value) {
        boolean _equals;
        String _plus_3;
        String _plus_1;
        String retStr = "";
        BigInteger valueOf = this.getIntValue(value);
        String _string = valueOf.toString(2);
        String _plus = String.valueOf(retStr) + "<p style=\"color:red;line-height:50%;\">" + "0b" + _string;
        retStr = _plus_1 = String.valueOf(_plus) + "</p>\n";
        String _string_1 = valueOf.toString(16);
        String _plus_2 = String.valueOf(retStr) + "<p style=\"color:red;line-height:50%;\">" + "0x" + _string_1;
        retStr = _plus_3 = String.valueOf(_plus_2) + "</p>\n";
        String _string_2 = valueOf.toString(10);
        String _plus_4 = String.valueOf(retStr) + "<p style=\"color:red;line-height:50%;\">" + "  " + _string_2;
        String _plus_5 = String.valueOf(_plus_4) + "</p>\n";
        int _length = (retStr = _plus_5).length();
        boolean bl = _equals = _length == 0;
        if (_equals) {
            return value.getValue();
        }
        return retStr;
    }

    public BigInteger getIntValue(integerValue value) {
        String parseString = value.getValue();
        String string = value.getValue();
        boolean _isEmpty = Strings.isEmpty((String)parseString);
        if (_isEmpty) {
            throw new NumberFormatException("Couldn't convert empty string to an int value.");
        }
        try {
            int radix = 10;
            if (parseString.startsWith("0x") || parseString.startsWith("0X")) {
                parseString = string.substring(2);
                radix = 16;
            }
            if (parseString.startsWith("0b") || parseString.startsWith("0B")) {
                parseString = string.substring(2);
                radix = 2;
            }
            return new BigInteger(parseString, radix);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                throw new NumberFormatException("Couldn't convert '" + string + "' to a BigInteger value.");
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public String getDefineSymText(DefineSym element) {
        boolean _equals;
        String retStr = "";
        this.model = (EObject)element.eResource().getContents().get(0);
        UnmodifiableIterator macDefs = Iterators.filter((Iterator)this.model.eAllContents(), macroDefine.class);
        while (macDefs.hasNext()) {
            String _plus_1;
            String _name_1;
            String _name;
            boolean _equals_1;
            macroDefine next = (macroDefine)macDefs.next();
            _equals = next.getDefineType().equals("@define");
            if (!_equals || !(_equals_1 = Objects.equal((Object)(_name = next.getDefinename().getName()), (Object)(_name_1 = element.getName())))) continue;
            String _value = next.getValue();
            String _plus = String.valueOf(retStr) + "<p style=\"color:red;line-height:100%;\">" + _value;
            retStr = _plus_1 = String.valueOf(_plus) + "</p>\n";
        }
        int _length = retStr.length();
        boolean bl = _equals = _length == 0;
        if (_equals) {
            return element.getName();
        }
        return retStr;
    }

    public String getSubTableText(SUBTABLESYM element) {
        boolean _equals;
        String retStr = "";
        this.model = (EObject)element.eResource().getContents().get(0);
        UnmodifiableIterator subs = Iterators.filter((Iterator)this.model.eAllContents(), subconstructor.class);
        while (subs.hasNext()) {
            String _plus_3;
            String _name_1;
            subconstructor next = (subconstructor)subs.next();
            String _name = next.getTableName().getName();
            boolean _equals2 = Objects.equal((Object)_name, (Object)(_name_1 = element.getName()));
            if (!_equals2) continue;
            String _formatString = this.formatString((EList<printpiece>)next.getPrint().getPrintpieces());
            String _plus = String.valueOf(retStr) + "<p style=\"color:red;line-height:100%;\">" + _formatString;
            String _plus_1 = String.valueOf(_plus) + " is ";
            String _formatConstraintString = this.formatConstraintString((EObject)next.getMatch().getConstraints());
            String _plus_2 = String.valueOf(_plus_1) + _formatConstraintString;
            retStr = _plus_3 = String.valueOf(_plus_2) + "</p>\n";
        }
        int _length = retStr.length();
        boolean bl = _equals = _length == 0;
        if (_equals) {
            return element.getName();
        }
        return retStr;
    }

    public String getSubTableText(aliasSym element) {
        boolean _equals;
        boolean _notEquals;
        String retStr = "";
        this.model = (EObject)element.eResource().getContents().get(0);
        UnmodifiableIterator subs = Iterators.filter((Iterator)this.model.eAllContents(), subconstructor.class);
        while (subs.hasNext()) {
            String _plus_3;
            String _sym;
            subconstructor next = (subconstructor)subs.next();
            String _name = next.getTableName().getName();
            boolean _equals2 = Objects.equal((Object)_name, (Object)(_sym = element.getSym()));
            if (!_equals2) continue;
            String _formatString = this.formatString((EList<printpiece>)next.getPrint().getPrintpieces());
            String _plus = String.valueOf(retStr) + "<p style=\"color:red;line-height:100%;\">" + _formatString;
            String _plus_1 = String.valueOf(_plus) + " is ";
            String _formatConstraintString = this.formatConstraintString((EObject)next.getMatch().getConstraints());
            String _plus_2 = String.valueOf(_plus_1) + _formatConstraintString;
            retStr = _plus_3 = String.valueOf(_plus_2) + "</p>\n";
        }
        int _length = retStr.length();
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            return retStr;
        }
        UnmodifiableIterator macDefs = Iterators.filter((Iterator)this.model.eAllContents(), macroDefine.class);
        while (macDefs.hasNext()) {
            String _plus_1;
            String _sym;
            String _name;
            boolean _equals_1;
            macroDefine next = (macroDefine)macDefs.next();
            boolean _equals3 = next.getDefineType().equals("@define");
            if (!_equals3 || !(_equals_1 = Objects.equal((Object)(_name = next.getDefinename().getName()), (Object)(_sym = element.getSym())))) continue;
            String _value = next.getValue();
            String _plus = String.valueOf(retStr) + "<p style=\"color:red;line-height:100%;\">" + _value;
            retStr = _plus_1 = String.valueOf(_plus) + "</p>\n";
        }
        int _length_1 = retStr.length();
        boolean bl2 = _equals = _length_1 == 0;
        if (_equals) {
            return element.getSym();
        }
        return retStr;
    }

    public String formatString(EList<printpiece> list) {
        String _xblockexpression = null;
        String str = "<span style=\"color:#0000FF;\">";
        for (printpiece piece : list) {
            String _str = piece.getStr();
            boolean _equals = Objects.equal((Object)_str, null);
            if (_equals) {
                boolean _notEquals;
                aliasSym _sym = piece.getSym();
                boolean bl = _notEquals = !Objects.equal((Object)_sym, null);
                if (_notEquals) {
                    String _str_1 = str;
                    String _sym_1 = piece.getSym().getSym();
                    str = String.valueOf(_str_1) + _sym_1;
                    continue;
                }
                str = "{empty}";
                continue;
            }
            String _str_2 = str;
            String _str_3 = piece.getStr();
            str = String.valueOf(_str_2) + _str_3;
        }
        String _str = str;
        _xblockexpression = str = String.valueOf(_str) + "</span>";
        return _xblockexpression;
    }

    public String formatConstraintString(EObject o) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)o);
        return node.getText();
    }
}

