/*
 * Decompiled with CFR 0.152.
 */
package ghidra.xtext.sleigh.ui;

import ghidra.xtext.sleigh.sleigh.CONTEXTSYM;
import ghidra.xtext.sleigh.sleigh.LOCALSYM;
import ghidra.xtext.sleigh.sleigh.SUBTABLESYM;
import ghidra.xtext.sleigh.sleigh.TOKENSYM;
import ghidra.xtext.sleigh.sleigh.VARSYM;
import ghidra.xtext.sleigh.sleigh.aliasSym;
import ghidra.xtext.sleigh.sleigh.anysymbol;
import ghidra.xtext.sleigh.sleigh.assignSym;
import ghidra.xtext.sleigh.sleigh.constraint;
import ghidra.xtext.sleigh.sleigh.exprSym;
import ghidra.xtext.sleigh.sleigh.fielddef;
import ghidra.xtext.sleigh.sleigh.isKeyword;
import ghidra.xtext.sleigh.sleigh.pexprSym;
import ghidra.xtext.sleigh.sleigh.printpiece;
import ghidra.xtext.sleigh.sleigh.valuepart;
import ghidra.xtext.sleigh.sleigh.varpart;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.ide.editor.syntaxcoloring.DefaultSemanticHighlightingCalculator;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.impl.TerminalRuleImpl;
import org.eclipse.xtext.nodemodel.BidiIterator;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.HiddenLeafNode;
import org.eclipse.xtext.nodemodel.impl.LeafNode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;

public class SleighHighlightingCalculator
extends DefaultSemanticHighlightingCalculator {
    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        if (resource == null || resource.getParseResult() == null) {
            return;
        }
        super.provideHighlightingFor(resource, acceptor, cancelIndicator);
        ICompositeNode root = resource.getParseResult().getRootNode();
        BidiTreeIterator it = root.getAsTreeIterable().iterator();
        while (it.hasNext()) {
            INode node = (INode)it.next();
            EObject grammarElement = node.getGrammarElement();
            EObject semanticElement = node.getSemanticElement();
            this.printNodeInfo(node, grammarElement, semanticElement);
            if (semanticElement instanceof VARSYM) {
                this.setNodeStyle(acceptor, node, "Variable");
                continue;
            }
            if (semanticElement instanceof CONTEXTSYM) {
                this.setNodeStyle(acceptor, node, "Context Field");
                continue;
            }
            if (semanticElement instanceof LOCALSYM) {
                this.setNodeStyle(acceptor, node, "Local Symbol");
                continue;
            }
            if (semanticElement instanceof TOKENSYM) {
                this.setNodeStyle(acceptor, node, "Token Field");
                continue;
            }
            if (semanticElement instanceof fielddef) {
                this.setNodeStyle(acceptor, node, "Token Field");
                continue;
            }
            if (semanticElement instanceof anysymbol) {
                this.setStyle(acceptor, node, semanticElement);
                continue;
            }
            if (grammarElement instanceof CrossReference) {
                EObject vnode;
                exprSym sym;
                CrossReference cfr_ignored_0 = (CrossReference)grammarElement;
                EObject semElem = semanticElement;
                if (semElem instanceof varpart || semElem instanceof valuepart) {
                    this.setNodeStyle(acceptor, node, "Variable");
                    continue;
                }
                if (semElem instanceof LOCALSYM) {
                    this.setNodeStyle(acceptor, node, "Local Symbol");
                    continue;
                }
                if (semElem instanceof exprSym) {
                    sym = (exprSym)semElem;
                    vnode = sym.getVnode();
                    if (vnode == null) continue;
                    this.setStyle(acceptor, node, vnode);
                    continue;
                }
                if (semElem instanceof assignSym) {
                    sym = (assignSym)semElem;
                    vnode = sym.getSymref();
                    if (vnode == null) continue;
                    this.setStyle(acceptor, node, vnode);
                    continue;
                }
                if (semElem instanceof constraint) {
                    sym = (constraint)semElem;
                    vnode = sym.getSym();
                    if (vnode == null) continue;
                    this.setStyle(acceptor, node, vnode);
                    continue;
                }
                if (semElem instanceof pexprSym) {
                    sym = (pexprSym)semElem;
                    vnode = sym.getSym();
                    if (vnode == null) continue;
                    this.setStyle(acceptor, node, vnode);
                    continue;
                }
                if (!(semElem instanceof aliasSym)) continue;
                System.out.println("  semElem=" + semElem);
                continue;
            }
            if (semanticElement instanceof isKeyword) {
                this.setStyles(acceptor, (BidiIterator<INode>)it, "keyword");
                continue;
            }
            if (semanticElement instanceof aliasSym && semanticElement.eContainer() instanceof printpiece) {
                this.setStyles(acceptor, (BidiIterator<INode>)it, "Print Piece");
                continue;
            }
            if (semanticElement instanceof printpiece) {
                this.setStyles(acceptor, (BidiIterator<INode>)it, "Print Piece");
                continue;
            }
            if (!(node instanceof HiddenLeafNode) || !(grammarElement instanceof TerminalRuleImpl)) continue;
            this.processHiddenNode(acceptor, (HiddenLeafNode)node);
        }
    }

    private void setStyle(IHighlightedPositionAcceptor acceptor, INode n, EObject vnode) {
        if (vnode instanceof LOCALSYM) {
            this.setNodeStyle(acceptor, n, "Local Symbol");
        } else if (vnode instanceof VARSYM) {
            this.setNodeStyle(acceptor, n, "Variable");
        } else if (vnode instanceof SUBTABLESYM) {
            this.setNodeStyle(acceptor, n, "SubTable");
        } else if (vnode instanceof fielddef) {
            this.setNodeStyle(acceptor, n, "Token Field");
        }
    }

    private void setNodeStyle(IHighlightedPositionAcceptor acceptor, INode n, String styleName) {
        acceptor.addPosition(n.getOffset(), n.getLength(), new String[]{styleName});
    }

    private void printNodeInfo(INode node, EObject grammarElement, EObject semanticElement) {
        if (grammarElement != null) {
            grammarElement.getClass().getSimpleName();
        }
        if (semanticElement != null) {
            semanticElement.getClass().getSimpleName();
        }
        if (grammarElement instanceof TerminalRuleImpl) {
            return;
        }
        if (!(node instanceof LeafNode)) {
            return;
        }
    }

    void setStyles(IHighlightedPositionAcceptor acceptor, BidiIterator<INode> it, String ... styles) {
        String[] stringArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!it.hasNext()) {
                return;
            }
            INode n3 = this.skipWhiteSpace(acceptor, it);
            if (n3 != null && s != null) {
                acceptor.addPosition(n3.getOffset(), n3.getLength(), new String[]{s});
            }
            ++n2;
        }
    }

    INode skipWhiteSpace(IHighlightedPositionAcceptor acceptor, BidiIterator<INode> it) {
        INode n = null;
        while (it.hasNext() && (n = (INode)it.next()).getClass() == HiddenLeafNode.class) {
            this.processHiddenNode(acceptor, (HiddenLeafNode)n);
        }
        return n;
    }

    INode skipWhiteSpaceBackwards(IHighlightedPositionAcceptor acceptor, BidiIterator<INode> it) {
        INode n = null;
        while (it.hasPrevious() && (n = (INode)it.previous()).getClass() == HiddenLeafNode.class) {
            this.processHiddenNode(acceptor, (HiddenLeafNode)n);
        }
        return n;
    }

    void processHiddenNode(IHighlightedPositionAcceptor acceptor, HiddenLeafNode node) {
        TerminalRuleImpl ge;
        String name;
        if (node.getGrammarElement() instanceof TerminalRuleImpl && ((name = (ge = (TerminalRuleImpl)node.getGrammarElement()).getName()).equalsIgnoreCase("PDL_COMMENT") || name.equalsIgnoreCase("ML_COMMENT") || name.equalsIgnoreCase("SL_COMMENT"))) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"comment"});
        }
    }
}

