/*
 * Decompiled with CFR 0.152.
 */
package ghidra.xtext.sleigh.ui;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;

public class SleighHighlightingConfiguration
extends DefaultHighlightingConfiguration {
    public static final String CONTEXTFIELD = "Context Field";
    public static final String TOKENFIELD = "Token Field";
    public static final String SYMBOL = "Symbol";
    public static final String VARIABLE = "Variable";
    public static final String ATTACHEDSYM = "Attached Symbol";
    public static final String PRINTPIECE = "Print Piece";
    public static final String LOCAL = "Local Symbol";
    public static final String SUBTABLE = "SubTable";

    public void configure(IHighlightingConfigurationAcceptor acceptor) {
        super.configure(acceptor);
        this.addType(acceptor, CONTEXTFIELD, 50, 50, 0, 2);
        this.addType(acceptor, TOKENFIELD, 50, 50, 0, 0);
        this.addType(acceptor, SYMBOL, 50, 50, 50, 0);
        this.addType(acceptor, VARIABLE, 106, 62, 63, 1);
        this.addType(acceptor, ATTACHEDSYM, 50, 50, 50, 1);
        this.addType(acceptor, PRINTPIECE, 0, 0, 255, 1);
        this.addType(acceptor, LOCAL, 40, 40, 40, 2);
        this.addType(acceptor, SUBTABLE, 192, 82, 5, 0);
    }

    public void addType(IHighlightingConfigurationAcceptor acceptor, String s, int r, int g, int b, int style) {
        this.addType(acceptor, s, new RGB(r, g, b), style);
    }

    public void addType(IHighlightingConfigurationAcceptor acceptor, String s, RGB rgb, int style) {
        TextStyle textStyle = new TextStyle();
        textStyle.setBackgroundColor(new RGB(255, 255, 255));
        textStyle.setColor(rgb);
        textStyle.setStyle(style);
        acceptor.acceptDefaultHighlighting(s, s, textStyle);
    }
}

