/*
 * Decompiled with CFR 0.152.
 */
package ghidra.xtext.sleigh.ui.console;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class ConsoleHyperlinking
implements IPatternMatchListenerDelegate {
    private static final String compilingBase = "Compiling ";
    private static final String failedBase = " failed to compile";
    private static final String javaPrefix = "[java] ";
    private Map<String, IFile> fFileNameToIFile = new HashMap<String, IFile>();
    private static String lastBase = "";
    private TextConsole console;

    public void matchFound(PatternMatchEvent event) {
        block7: {
            try {
                int _indexOf_1;
                boolean _notEquals_1;
                boolean _notEquals;
                int offset = event.getOffset();
                int length = event.getLength();
                String _str = this.console.getDocument().get(offset, length);
                boolean setBase = false;
                int _indexOf = _str.indexOf(compilingBase);
                boolean bl = _notEquals = _indexOf != -1;
                if (_notEquals) {
                    _str = _str.replace(compilingBase, "");
                    setBase = true;
                    int _offset = offset;
                    int _length = compilingBase.length();
                    offset = _offset + _length;
                    int _length_1 = length;
                    int _length_2 = compilingBase.length();
                    length = _length_1 - _length_2;
                }
                boolean bl2 = _notEquals_1 = (_indexOf_1 = _str.indexOf(failedBase)) != -1;
                if (_notEquals_1) {
                    _str = _str.replace(failedBase, "");
                    _str = _str.replace(javaPrefix, "");
                    setBase = true;
                    int _offset_1 = offset;
                    int _length_3 = javaPrefix.length();
                    offset = _offset_1 + _length_3;
                    int _length_4 = length;
                    int _length_5 = failedBase.length();
                    int _length_6 = javaPrefix.length();
                    int _plus = _length_5 + _length_6;
                    length = _length_4 - _plus;
                }
                int indexOfColon = _str.indexOf(":");
                String fileName = "";
                int lineNumber = 1;
                if (indexOfColon != -1) {
                    fileName = _str.substring(0, indexOfColon);
                    lineNumber = Integer.valueOf(_str.substring(indexOfColon + 1));
                } else {
                    fileName = _str;
                }
                IFile file = this.getIFile(fileName, setBase);
                if (file != null) {
                    FileLink link = new FileLink(file, null, -1, -1, lineNumber);
                    this.console.addHyperlink((IHyperlink)link, offset, length);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof BadLocationException || _t instanceof NumberFormatException) break block7;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    public void connect(TextConsole console) {
        this.console = console;
        lastBase = "";
    }

    public void disconnect() {
        this.console = null;
        this.fFileNameToIFile.clear();
    }

    public IFile getIFile(String filePath, boolean setBase) {
        if (filePath == null) {
            return null;
        }
        IFile file = this.fFileNameToIFile.get(filePath);
        if (file == null) {
            int _length_1;
            boolean _greaterThan;
            boolean _lessEqualsThan;
            File f = new Path(filePath).toFile();
            URI uri = f.toURI();
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
            int _length = files.length;
            boolean bl = _lessEqualsThan = _length <= 0;
            if (_lessEqualsThan) {
                f = new Path(String.valueOf(lastBase) + Character.valueOf('/') + filePath).toFile();
                f.toURI();
                uri = f.toURI();
                files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
            }
            boolean bl2 = _greaterThan = (_length_1 = files.length) > 0;
            if (_greaterThan) {
                file = files[0];
                this.fFileNameToIFile.put(filePath, file);
                if (setBase) {
                    lastBase = f.getParent();
                }
            }
        }
        return file;
    }
}

