/*
 * Decompiled with CFR 0.152.
 */
package ghidra.xtext.sleigh.ui.labeling;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import ghidra.xtext.sleigh.sleigh.DefineSym;
import ghidra.xtext.sleigh.sleigh.DefineUsage;
import ghidra.xtext.sleigh.sleigh.SUBTABLESYM;
import ghidra.xtext.sleigh.sleigh.VARSYM;
import ghidra.xtext.sleigh.sleigh.aliasSym;
import ghidra.xtext.sleigh.sleigh.baseconstructor;
import ghidra.xtext.sleigh.sleigh.constraint;
import ghidra.xtext.sleigh.sleigh.constructprint;
import ghidra.xtext.sleigh.sleigh.contextfielddef;
import ghidra.xtext.sleigh.sleigh.fielddef;
import ghidra.xtext.sleigh.sleigh.integerValue;
import ghidra.xtext.sleigh.sleigh.macroDefine;
import ghidra.xtext.sleigh.sleigh.printpiece;
import ghidra.xtext.sleigh.sleigh.subconstructor;
import ghidra.xtext.sleigh.sleigh.valuepartdef;
import ghidra.xtext.sleigh.sleigh.varattach;
import ghidra.xtext.sleigh.sleigh.varnodedef;
import ghidra.xtext.sleigh.sleigh.varpart;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

public class SleighLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    private IQualifiedNameProvider nameProvider;
    private QualifiedName qn;
    private EObject model;
    private Iterator<varattach> varatt;
    private String possible;

    @Inject
    public SleighLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    public String text(EObject eObject) {
        this.qn = this.nameProvider.getFullyQualifiedName(eObject);
        boolean _equals = Objects.equal((Object)this.qn, null);
        if (_equals) {
            return this.getObjectText(eObject);
        }
        return this.qn.toString();
    }

    public String getObjectText(EObject element) {
        Object _doGetText;
        String _switchResult = null;
        boolean _matched = false;
        if (element instanceof macroDefine) {
            _matched = true;
            _switchResult = ((macroDefine)element).getDefineType();
        }
        if (!_matched && element instanceof VARSYM) {
            _matched = true;
            String _name = ((VARSYM)element).getName();
            String _plus = String.valueOf(_name) + " : ";
            EObject _eContainer = ((VARSYM)element).eContainer().eContainer();
            String _sizeStr = this.getSizeStr(((varnodedef)_eContainer).getSize());
            _switchResult = String.valueOf(_plus) + _sizeStr;
        }
        if (!_matched && element instanceof SUBTABLESYM) {
            _matched = true;
            _switchResult = ((SUBTABLESYM)element).getName();
        }
        if (!_matched && element instanceof contextfielddef) {
            _matched = true;
            _switchResult = ((contextfielddef)element).getName();
        }
        if (!_matched && element instanceof fielddef) {
            _matched = true;
            _switchResult = ((fielddef)element).getName();
        }
        if (!_matched && element instanceof subconstructor) {
            _matched = true;
            _doGetText = this.doGetText(((subconstructor)element).getTableName());
            _switchResult = _doGetText + ":";
        }
        if (!_matched && element instanceof baseconstructor) {
            _matched = true;
            _doGetText = this.doGetText(((baseconstructor)element).getPrint());
            _switchResult = ":" + _doGetText;
        }
        if (!_matched && element instanceof constructprint) {
            _matched = true;
            _switchResult = this.formatString((EList<printpiece>)((constructprint)element).getPrintpieces());
        }
        if (!_matched && element instanceof constraint) {
            _matched = true;
            _switchResult = this.getBaseName(((constraint)element).eClass());
        }
        if (!_matched) {
            _switchResult = element.getClass().getSimpleName();
        }
        return _switchResult;
    }

    public StyledString getfielddefText(fielddef element) {
        String len = this.getVarAttachesForElement((EObject)element);
        String _name = element.getName();
        String _plus = "field " + _name;
        StyledString _convertToStyledString = this.convertToStyledString(_plus);
        String _value = element.getStart().getValue();
        String _plus_1 = "  " + len + " " + "  (" + _value;
        String _plus_2 = String.valueOf(_plus_1) + ",";
        String _value_1 = element.getEnd().getValue();
        String _plus_3 = String.valueOf(_plus_2) + _value_1;
        String _plus_4 = String.valueOf(_plus_3) + ")";
        String _xifexpression = null;
        boolean _isSigned = element.isSigned();
        _xifexpression = _isSigned ? " signed" : "";
        String _plus_5 = String.valueOf(_plus_4) + _xifexpression;
        return _convertToStyledString.append(_plus_5, StyledString.QUALIFIER_STYLER).append("\n\n" + this.possible);
    }

    public StyledString getcontextfielddefText(contextfielddef element) {
        String len = this.getVarAttachesForElement((EObject)element);
        String _name = element.getName();
        String _plus = "context " + _name;
        StyledString _convertToStyledString = this.convertToStyledString(_plus);
        String _value = element.getStart().getValue();
        String _plus_1 = "  " + len + " " + "  (" + _value;
        String _plus_2 = String.valueOf(_plus_1) + ",";
        String _value_1 = element.getEnd().getValue();
        String _plus_3 = String.valueOf(_plus_2) + _value_1;
        String _plus_4 = String.valueOf(_plus_3) + ")";
        String _xifexpression = null;
        boolean _isSigned = element.isSigned();
        _xifexpression = _isSigned ? " signed" : "";
        String _plus_5 = String.valueOf(_plus_4) + _xifexpression;
        return _convertToStyledString.append(_plus_5, StyledString.QUALIFIER_STYLER).append("\n\n" + this.possible);
    }

    protected String getVarAttachesForElement(EObject element) {
        String _xblockexpression = null;
        this.model = (EObject)element.eResource().getContents().get(0);
        this.varatt = Iterators.filter((Iterator)this.model.eAllContents(), varattach.class);
        this.possible = "";
        String len = "";
        while (this.varatt.hasNext()) {
            varattach next = this.varatt.next();
            ListIterator vlist = next.getValuelist().getValuelist().listIterator();
            while (vlist.hasNext()) {
                valuepartdef v = (valuepartdef)vlist.next();
                boolean _equals = v.getSym().equals(element);
                if (!_equals) continue;
                Iterator viter = next.getVlist().getVarDefList().iterator();
                this.possible = "attached to: ";
                while (viter.hasNext()) {
                    String _plus_1;
                    boolean _notEquals_1;
                    boolean _notEquals;
                    varpart varname = (varpart)viter.next();
                    VARSYM vref = varname.getVarpart();
                    boolean bl = _notEquals = !Objects.equal((Object)vref, null);
                    if (!_notEquals) continue;
                    varnodedef vdef = (varnodedef)EcoreUtil2.getContainerOfType((EObject)vref, varnodedef.class);
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)vdef, null);
                    if (_notEquals_1) {
                        String size;
                        len = size = vdef.getSize().getValue();
                    }
                    String _name = vref.getName();
                    String _plus = String.valueOf(this.possible) + _name;
                    this.possible = _plus_1 = String.valueOf(_plus) + " ";
                }
            }
        }
        _xblockexpression = len;
        return _xblockexpression;
    }

    public Object getDefineSymText(DefineSym element) {
        boolean _equals;
        String retStr = "";
        this.model = (EObject)element.eResource().getContents().get(0);
        UnmodifiableIterator macDefs = Iterators.filter((Iterator)this.model.eAllContents(), macroDefine.class);
        this.possible = "";
        while (macDefs.hasNext()) {
            String _plus_1;
            String _name_1;
            String _name;
            boolean _equals_1;
            macroDefine next = (macroDefine)macDefs.next();
            _equals = next.getDefineType().equals("@define");
            if (!_equals || !(_equals_1 = Objects.equal((Object)(_name = next.getDefinename().getName()), (Object)(_name_1 = element.getName())))) continue;
            String _value = next.getValue();
            String _plus = String.valueOf(retStr) + _value;
            retStr = _plus_1 = String.valueOf(_plus) + "\r\n";
        }
        int _length = retStr.length();
        boolean bl = _equals = _length == 0;
        if (_equals) {
            return super.doGetText((Object)element);
        }
        return retStr;
    }

    protected Object doGetText(Object element) {
        Object _doGetText;
        String _xblockexpression = null;
        boolean _equals = Objects.equal((Object)element, null);
        if (_equals) {
            return null;
        }
        Object _switchResult = null;
        boolean _matched = false;
        if (element instanceof macroDefine) {
            _matched = true;
            _switchResult = ((macroDefine)element).getDefineType();
        }
        if (!_matched && element instanceof VARSYM) {
            _matched = true;
            String _name = ((VARSYM)element).getName();
            String _plus = String.valueOf(_name) + " : ";
            String _sizeStr = this.getSizeStr(((varnodedef)EcoreUtil2.getContainerOfType((EObject)((EObject)element), varnodedef.class)).getSize());
            _switchResult = String.valueOf(_plus) + _sizeStr;
        }
        if (!_matched && element instanceof SUBTABLESYM) {
            _matched = true;
            _switchResult = ((SUBTABLESYM)element).getName();
        }
        if (!_matched && element instanceof contextfielddef) {
            _matched = true;
            _switchResult = this.getcontextfielddefText((contextfielddef)element);
        }
        if (!_matched && element instanceof fielddef) {
            _matched = true;
            _switchResult = this.getfielddefText((fielddef)element);
        }
        if (!_matched && element instanceof subconstructor) {
            _matched = true;
            _doGetText = this.doGetText(((subconstructor)element).getTableName());
            _switchResult = _doGetText + ":";
        }
        if (!_matched && element instanceof baseconstructor) {
            _matched = true;
            _doGetText = this.doGetText(((baseconstructor)element).getPrint());
            _switchResult = ":" + _doGetText;
        }
        if (!_matched && element instanceof constructprint) {
            _matched = true;
            _switchResult = this.formatString((EList<printpiece>)((constructprint)element).getPrintpieces());
        }
        if (!_matched && element instanceof constraint) {
            _matched = true;
            _switchResult = this.doGetText(((constraint)element).getSym());
        }
        if (!_matched && element instanceof DefineSym) {
            _matched = true;
            _switchResult = this.getDefineSymText((DefineSym)element);
        }
        if (!_matched) {
            _switchResult = super.doGetText(element);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public String getSizeStr(integerValue size) {
        boolean _notEquals_1;
        boolean _notEquals;
        String _value = size.getValue();
        boolean bl = _notEquals = !Objects.equal((Object)_value, null);
        if (_notEquals) {
            return size.getValue();
        }
        DefineUsage _sym = size.getSym();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_sym, null);
        if (_notEquals_1) {
            return this.getText(size.getSym());
        }
        return "?";
    }

    public String getBaseName(Object element) {
        String _name = element.getClass().getName();
        int _lastIndexOf = element.getClass().getName().lastIndexOf(".");
        int _plus = _lastIndexOf + 1;
        return _name.substring(_plus);
    }

    public String formatString(EList<printpiece> list) {
        String _xblockexpression = null;
        String str = "";
        for (printpiece piece : list) {
            String _str = piece.getStr();
            boolean _equals = Objects.equal((Object)_str, null);
            if (_equals) {
                boolean _notEquals;
                aliasSym _sym = piece.getSym();
                boolean bl = _notEquals = !Objects.equal((Object)_sym, null);
                if (_notEquals) {
                    String _str_1 = str;
                    String _sym_1 = piece.getSym().getSym();
                    str = String.valueOf(_str_1) + _sym_1;
                    continue;
                }
                str = "{empty}";
                continue;
            }
            String _str_2 = str;
            String _str_3 = piece.getStr();
            str = String.valueOf(_str_2) + _str_3;
        }
        _xblockexpression = str;
        return _xblockexpression;
    }

    protected Object doGetImage(Object element) {
        Object _switchResult = null;
        boolean _matched = false;
        if (!_matched) {
            _switchResult = super.doGetImage(element);
        }
        return _switchResult;
    }
}

