/*
 * Decompiled with CFR 0.152.
 */
package ghidra.xtext.sleigh.ui.quickfix;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import ghidra.xtext.sleigh.sleigh.Expression;
import ghidra.xtext.sleigh.sleigh.LOCALSYM;
import ghidra.xtext.sleigh.sleigh.Model;
import ghidra.xtext.sleigh.sleigh.SUBTABLESYM;
import ghidra.xtext.sleigh.sleigh.SleighFactory;
import ghidra.xtext.sleigh.sleigh.USEROPSYM;
import ghidra.xtext.sleigh.sleigh.VARSYM;
import ghidra.xtext.sleigh.sleigh.assignSym;
import ghidra.xtext.sleigh.sleigh.constraint;
import ghidra.xtext.sleigh.sleigh.constructor;
import ghidra.xtext.sleigh.sleigh.constructprint;
import ghidra.xtext.sleigh.sleigh.exprSym;
import ghidra.xtext.sleigh.sleigh.fielddef;
import ghidra.xtext.sleigh.sleigh.integerValue;
import ghidra.xtext.sleigh.sleigh.isKeyword;
import ghidra.xtext.sleigh.sleigh.lhsvarnode;
import ghidra.xtext.sleigh.sleigh.localDefine;
import ghidra.xtext.sleigh.sleigh.macroOrPcode;
import ghidra.xtext.sleigh.sleigh.pNextSet;
import ghidra.xtext.sleigh.sleigh.pcodeopdef;
import ghidra.xtext.sleigh.sleigh.pequation;
import ghidra.xtext.sleigh.sleigh.printpiece;
import ghidra.xtext.sleigh.sleigh.rtlbody;
import ghidra.xtext.sleigh.sleigh.statement;
import ghidra.xtext.sleigh.sleigh.subconstructor;
import ghidra.xtext.sleigh.sleigh.tokendef;
import ghidra.xtext.sleigh.sleigh.valuepartdef;
import ghidra.xtext.sleigh.sleigh.varattach;
import ghidra.xtext.sleigh.sleigh.varnodedef;
import ghidra.xtext.sleigh.sleigh.varpart;
import ghidra.xtext.sleigh.sleigh.vnoderef;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class SleighQuickfixProvider
extends DefaultQuickfixProvider {
    private integerValue len;

    @Fix(value="org.eclipse.xtext.diagnostics.Diagnostic.Linking")
    public void createMissingVariable(Issue issue, IssueResolutionAcceptor acceptor) {
        String _simpleName_2;
        String _simpleName_1;
        String message = issue.getMessage();
        String to = this.getToName(message);
        String linkName = this.getLinkName(message);
        macroOrPcode.class.getSimpleName().toString();
        boolean _matched = false;
        String _simpleName = macroOrPcode.class.getSimpleName();
        if (Objects.equal((Object)to, (Object)_simpleName)) {
            _matched = true;
            this.missingPseudoOp(issue, acceptor, to, linkName);
        }
        if (!_matched && Objects.equal((Object)to, (Object)(_simpleName_1 = lhsvarnode.class.getSimpleName()))) {
            _matched = true;
            this.createLocalVarnode(issue, acceptor, to, linkName);
        }
        if (!_matched && Objects.equal((Object)to, (Object)(_simpleName_2 = EObject.class.getSimpleName()))) {
            _matched = true;
            this.missingEObjectLink(issue, acceptor, to, linkName);
        }
    }

    public void missingPseudoOp(Issue issue, IssueResolutionAcceptor acceptor, String to, String linkName) {
        ISemanticModification _function = (element, context) -> {
            constructor currentEntity = (constructor)EcoreUtil2.getContainerOfType((EObject)element, constructor.class);
            EObject _eContainer = currentEntity.eContainer();
            Model model = (Model)_eContainer;
            pcodeopdef _createpcodeopdef = SleighFactory.eINSTANCE.createpcodeopdef();
            Procedures.Procedure1 _function_1 = it -> {
                EList _ops = it.getOps();
                USEROPSYM _createUSEROPSYM = SleighFactory.eINSTANCE.createUSEROPSYM();
                Procedures.Procedure1 _function_2 = it_1 -> {
                    try {
                        it_1.setName(context.getXtextDocument().get(issue.getOffset().intValue(), issue.getLength().intValue()));
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                USEROPSYM _doubleArrow = (USEROPSYM)ObjectExtensions.operator_doubleArrow((Object)_createUSEROPSYM, (Procedures.Procedure1)_function_2);
                _ops.add((Object)_doubleArrow);
            };
            pcodeopdef newdef = (pcodeopdef)ObjectExtensions.operator_doubleArrow((Object)_createpcodeopdef, (Procedures.Procedure1)_function_1);
            model.getElements().add(model.getElements().indexOf((Object)currentEntity), (Object)newdef);
        };
        acceptor.accept(issue, "Create pcodeop '" + linkName + "'", "Create pcodeop '" + linkName + "'", "", _function);
    }

    public Object missingEObjectLink(final Issue issue, final IssueResolutionAcceptor acceptor, final String to, final String linkName) {
        Object _xblockexpression = null;
        IModificationContext modificationContext = this.getModificationContextFactory().createModificationContext(issue);
        IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        _xblockexpression = xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource state) throws Exception {
                EObject cause = state.getResourceSet().getEObject(issue.getUriToProblem(), false);
                if (cause instanceof constraint) {
                    SleighQuickfixProvider.this.missingConstraint(issue, acceptor, to, linkName, cause);
                    SleighQuickfixProvider.this.missingSubConstructor(issue, acceptor, to, linkName, cause);
                }
            }
        });
        return _xblockexpression;
    }

    public void missingConstraint(Issue issue, IssueResolutionAcceptor acceptor, String to, String linkName, EObject cause) {
        ISemanticModification _function = (element, context) -> {
            boolean _lessEqualsThan;
            EObject _rootContainer = EcoreUtil2.getRootContainer((EObject)cause);
            Model root = (Model)_rootContainer;
            List tokendefs = EcoreUtil2.getAllContentsOfType((EObject)root, tokendef.class);
            int _size = tokendefs.size();
            boolean bl = _lessEqualsThan = _size <= 0;
            if (_lessEqualsThan) {
                return;
            }
            tokendef tokendef2 = (tokendef)tokendefs.get(0);
            fielddef _createfielddef = SleighFactory.eINSTANCE.createfielddef();
            Procedures.Procedure1 _function_1 = it -> {
                it.setName(linkName);
                integerValue _createintegerValue = SleighFactory.eINSTANCE.createintegerValue();
                Procedures.Procedure1 _function_2 = it_1 -> it_1.setValue("0");
                integerValue _doubleArrow = (integerValue)ObjectExtensions.operator_doubleArrow((Object)_createintegerValue, (Procedures.Procedure1)_function_2);
                it.setStart(_doubleArrow);
                integerValue _createintegerValue_1 = SleighFactory.eINSTANCE.createintegerValue();
                Procedures.Procedure1 _function_3 = it_1 -> it_1.setValue("0");
                integerValue _doubleArrow_1 = (integerValue)ObjectExtensions.operator_doubleArrow((Object)_createintegerValue_1, (Procedures.Procedure1)_function_3);
                it.setEnd(_doubleArrow_1);
            };
            fielddef newfielddef = (fielddef)ObjectExtensions.operator_doubleArrow((Object)_createfielddef, (Procedures.Procedure1)_function_1);
            tokendef2.getFields().getTokens().add((Object)newfielddef);
        };
        acceptor.accept(issue, "Create fieldef '" + linkName + "'", "Create fieldef '" + linkName + "'", "", _function);
    }

    public void missingSubConstructor(Issue issue, IssueResolutionAcceptor acceptor, String to, String linkName, EObject cause) {
        ISemanticModification _function = (element, context) -> {
            EObject _rootContainer = EcoreUtil.getRootContainer((EObject)cause);
            Model model = (Model)_rootContainer;
            constructor container = (constructor)EcoreUtil2.getContainerOfType((EObject)cause, constructor.class);
            subconstructor _createsubconstructor = SleighFactory.eINSTANCE.createsubconstructor();
            Procedures.Procedure1 _function_1 = it -> {
                SUBTABLESYM _createSUBTABLESYM = SleighFactory.eINSTANCE.createSUBTABLESYM();
                Procedures.Procedure1 _function_2 = it_1 -> it_1.setName(linkName);
                SUBTABLESYM _doubleArrow = (SUBTABLESYM)ObjectExtensions.operator_doubleArrow((Object)_createSUBTABLESYM, (Procedures.Procedure1)_function_2);
                it.setTableName(_doubleArrow);
                constructprint _createconstructprint = SleighFactory.eINSTANCE.createconstructprint();
                Procedures.Procedure1 _function_3 = it_1 -> {
                    printpiece _createprintpiece = SleighFactory.eINSTANCE.createprintpiece();
                    Procedures.Procedure1 _function_4 = it_2 -> it_2.setStr("");
                    printpiece pp = (printpiece)ObjectExtensions.operator_doubleArrow((Object)_createprintpiece, (Procedures.Procedure1)_function_4);
                    it_1.getPrintpieces().add((Object)pp);
                    isKeyword _createisKeyword = SleighFactory.eINSTANCE.createisKeyword();
                    Procedures.Procedure1 _function_5 = it_2 -> {};
                    isKeyword _doubleArrow_1 = (isKeyword)ObjectExtensions.operator_doubleArrow((Object)_createisKeyword, (Procedures.Procedure1)_function_5);
                    it_1.setIs(_doubleArrow_1);
                };
                constructprint _doubleArrow_1 = (constructprint)ObjectExtensions.operator_doubleArrow((Object)_createconstructprint, (Procedures.Procedure1)_function_3);
                it.setPrint(_doubleArrow_1);
                pequation _createpequation = SleighFactory.eINSTANCE.createpequation();
                Procedures.Procedure1 _function_4 = it_1 -> {
                    constraint _createconstraint = SleighFactory.eINSTANCE.createconstraint();
                    Procedures.Procedure1 _function_5 = it_2 -> it_2.setIsepsilon(true);
                    constraint _doubleArrow_2 = (constraint)ObjectExtensions.operator_doubleArrow((Object)_createconstraint, (Procedures.Procedure1)_function_5);
                    it_1.setConstraints((pNextSet)_doubleArrow_2);
                };
                pequation _doubleArrow_2 = (pequation)ObjectExtensions.operator_doubleArrow((Object)_createpequation, (Procedures.Procedure1)_function_4);
                it.setMatch(_doubleArrow_2);
                rtlbody _creatertlbody = SleighFactory.eINSTANCE.creatertlbody();
                Procedures.Procedure1 _function_5 = it_1 -> it_1.setUnimpl(true);
                rtlbody _doubleArrow_3 = (rtlbody)ObjectExtensions.operator_doubleArrow((Object)_creatertlbody, (Procedures.Procedure1)_function_5);
                it.setBody(_doubleArrow_3);
            };
            subconstructor sub = (subconstructor)ObjectExtensions.operator_doubleArrow((Object)_createsubconstructor, (Procedures.Procedure1)_function_1);
            model.getElements().add(model.getElements().indexOf((Object)container), (Object)sub);
        };
        acceptor.accept(issue, "Create SubConstruct '" + linkName + "'", "Create SubConstruct '" + linkName + "'", "", _function);
    }

    public void createLocalVarnode(Issue issue, IssueResolutionAcceptor acceptor, String to, String linkName) {
        ISemanticModification _function = (element, context) -> {
            integerValue s = this.findElementSize(element);
            boolean _equals = Objects.equal((Object)s, null);
            if (_equals) {
                assignSym _createassignSym = SleighFactory.eINSTANCE.createassignSym();
                Procedures.Procedure1 _function_1 = it -> {
                    localDefine _createlocalDefine = SleighFactory.eINSTANCE.createlocalDefine();
                    Procedures.Procedure1 _function_2 = it_1 -> {
                        LOCALSYM _createLOCALSYM = SleighFactory.eINSTANCE.createLOCALSYM();
                        Procedures.Procedure1 _function_3 = it_2 -> it_2.setName(linkName);
                        LOCALSYM _doubleArrow = (LOCALSYM)ObjectExtensions.operator_doubleArrow((Object)_createLOCALSYM, (Procedures.Procedure1)_function_3);
                        it_1.setSym(_doubleArrow);
                    };
                    localDefine _doubleArrow = (localDefine)ObjectExtensions.operator_doubleArrow((Object)_createlocalDefine, (Procedures.Procedure1)_function_2);
                    it.setLocal(_doubleArrow);
                };
                assignSym newdef = (assignSym)ObjectExtensions.operator_doubleArrow((Object)_createassignSym, (Procedures.Procedure1)_function_1);
                EcoreUtil.replace((EObject)element, (EObject)newdef);
            } else {
                assignSym _createassignSym_1 = SleighFactory.eINSTANCE.createassignSym();
                Procedures.Procedure1 _function_2 = it -> {
                    localDefine _createlocalDefine = SleighFactory.eINSTANCE.createlocalDefine();
                    Procedures.Procedure1 _function_3 = it_1 -> {
                        LOCALSYM _createLOCALSYM = SleighFactory.eINSTANCE.createLOCALSYM();
                        Procedures.Procedure1 _function_4 = it_2 -> it_2.setName(linkName);
                        LOCALSYM _doubleArrow = (LOCALSYM)ObjectExtensions.operator_doubleArrow((Object)_createLOCALSYM, (Procedures.Procedure1)_function_4);
                        it_1.setSym(_doubleArrow);
                        integerValue _createintegerValue = SleighFactory.eINSTANCE.createintegerValue();
                        Procedures.Procedure1 _function_5 = it_2 -> {
                            it_2.setValue(s.getValue());
                            it_2.setSym(s.getSym());
                        };
                        integerValue _doubleArrow_1 = (integerValue)ObjectExtensions.operator_doubleArrow((Object)_createintegerValue, (Procedures.Procedure1)_function_5);
                        it_1.setSize(_doubleArrow_1);
                    };
                    localDefine _doubleArrow = (localDefine)ObjectExtensions.operator_doubleArrow((Object)_createlocalDefine, (Procedures.Procedure1)_function_3);
                    it.setLocal(_doubleArrow);
                };
                assignSym newdef_1 = (assignSym)ObjectExtensions.operator_doubleArrow((Object)_createassignSym_1, (Procedures.Procedure1)_function_2);
                EcoreUtil.replace((EObject)element, (EObject)newdef_1);
            }
        };
        acceptor.accept(issue, "Create local '" + linkName + "'", "Create local '" + linkName + "'", "", _function);
    }

    public integerValue findElementSize(EObject element) {
        statement currentEntity = (statement)EcoreUtil2.getContainerOfType((EObject)element, statement.class);
        Expression rhs = currentEntity.getRhs();
        integerValue s = this.findSize(rhs);
        return s;
    }

    public integerValue findSize(Expression rhs) {
        this.len = null;
        if (rhs instanceof exprSym) {
            return this.getExprSymLength((exprSym)rhs);
        }
        List vlist = EcoreUtil2.getAllContentsOfType((EObject)rhs, exprSym.class);
        Consumer<exprSym> _function = it -> this.getExprSymLength((exprSym)it);
        vlist.forEach(_function);
        return this.len;
    }

    public integerValue getExprSymLength(exprSym sym) {
        boolean _notEquals;
        integerValue _xifexpression_2;
        boolean _equals;
        integerValue _xifexpression_1;
        integerValue _xifexpression;
        integerValue _xblockexpression_1;
        integerValue _xblockexpression = null;
        EObject node = sym.getVnode();
        integerValue _switchResult = null;
        boolean _matched = false;
        if (node instanceof VARSYM) {
            _matched = true;
            _xblockexpression_1 = null;
            varnodedef def = (varnodedef)EcoreUtil2.getContainerOfType((EObject)node, varnodedef.class);
            _xifexpression = null;
            if (!Objects.equal((Object)def, null) && !Objects.equal((Object)def.getSize(), null)) {
                _xifexpression_1 = null;
                _equals = Objects.equal((Object)this.len, null);
                if (_equals) {
                    _xifexpression_1 = this.len = def.getSize();
                }
                _xifexpression = _xifexpression_1;
            } else {
                _xifexpression_2 = null;
                integerValue _size = def.getSize();
                boolean bl = _notEquals = !Objects.equal((Object)this.len, (Object)_size);
                if (_notEquals) {
                    this.len = null;
                    _xifexpression_2 = null;
                }
                _xifexpression = _xifexpression_2;
            }
            _switchResult = _xblockexpression_1 = _xifexpression;
        }
        if (!_matched && node instanceof fielddef) {
            _matched = true;
            _switchResult = this.len = this.findVarAttachLen((fielddef)node);
        }
        if (!_matched && node instanceof LOCALSYM) {
            _matched = true;
            _xblockexpression_1 = null;
            localDefine ldef = (localDefine)EcoreUtil2.getContainerOfType((EObject)node, localDefine.class);
            _xifexpression = null;
            if (!Objects.equal((Object)ldef, null) && !Objects.equal((Object)ldef.getSize(), null)) {
                _xifexpression_1 = null;
                _equals = Objects.equal((Object)this.len, null);
                if (_equals) {
                    _xifexpression_1 = this.len = ldef.getSize();
                }
                _xifexpression = _xifexpression_1;
            } else {
                _xifexpression_2 = null;
                integerValue _size = ldef.getSize();
                boolean bl = _notEquals = !Objects.equal((Object)this.len, (Object)_size);
                if (_notEquals) {
                    this.len = null;
                    _xifexpression_2 = null;
                }
                _xifexpression = _xifexpression_2;
            }
            _switchResult = _xblockexpression_1 = _xifexpression;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public integerValue findVarAttachLen(fielddef fdef) {
        EObject model = (EObject)fdef.eResource().getContents().get(0);
        UnmodifiableIterator varatt = Iterators.filter((Iterator)model.eAllContents(), varattach.class);
        while (varatt.hasNext()) {
            varattach next = (varattach)varatt.next();
            ListIterator vlist = next.getValuelist().getValuelist().listIterator();
            while (vlist.hasNext()) {
                valuepartdef v = (valuepartdef)vlist.next();
                boolean _equals = v.getSym().equals(fdef);
                if (!_equals) continue;
                for (varpart varname : next.getVlist().getVarDefList()) {
                    boolean _notEquals_1;
                    boolean _notEquals;
                    VARSYM vref = varname.getVarpart();
                    boolean bl = _notEquals = !Objects.equal((Object)vref, null);
                    if (!_notEquals) continue;
                    varnodedef vdef = (varnodedef)EcoreUtil2.getContainerOfType((EObject)vref, varnodedef.class);
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)vdef, null);
                    if (!_notEquals_1) continue;
                    integerValue size = vdef.getSize();
                    return size;
                }
            }
        }
        return null;
    }

    public void findVnodeSize(vnoderef ref) {
        String _iD = EcoreUtil.getID((EObject)ref);
        String _plus = "  printit " + _iD;
        System.out.println(_plus);
    }

    public String getLinkName(String str) {
        int end = str.lastIndexOf("'");
        int start = str.lastIndexOf("'", end - 1);
        return str.substring(start + 1, end);
    }

    public String getToName(String str) {
        int index = str.indexOf("reference to ");
        if (index == -1) {
            return null;
        }
        int _length = "reference to ".length();
        int start = index + _length;
        String refStr = str.substring(start);
        refStr = refStr.substring(0, refStr.indexOf(" "));
        return refStr;
    }
}

