/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.fs.hfscommon;

import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFile;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFileRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.jparted.lib.fs.FSAttributes;
import org.catacombae.jparted.lib.fs.FSFile;
import org.catacombae.jparted.lib.fs.FSFork;
import org.catacombae.jparted.lib.fs.FSForkType;
import org.catacombae.jparted.lib.fs.hfscommon.HFSCommonFSAttributes;
import org.catacombae.jparted.lib.fs.hfscommon.HFSCommonFSFork;
import org.catacombae.jparted.lib.fs.hfscommon.HFSCommonFileSystemHandler;

public class HFSCommonFSFile
extends FSFile {
    private final HFSCommonFileSystemHandler parent;
    private final CommonHFSCatalogLeafRecord keyRecord;
    private final CommonHFSCatalogFileRecord fileRecord;
    private final CommonHFSCatalogFile catalogFile;
    private final HFSCommonFSAttributes attributes;
    private final FSFork dataFork;
    private final FSFork resourceFork;

    HFSCommonFSFile(HFSCommonFileSystemHandler iParent, CommonHFSCatalogFileRecord iFileRecord) {
        this(iParent, null, iFileRecord);
    }

    HFSCommonFSFile(HFSCommonFileSystemHandler iParent, CommonHFSCatalogLeafRecord iHardLinkRecord, CommonHFSCatalogFileRecord iFileRecord) {
        super(iParent);
        if (iParent == null) {
            throw new IllegalArgumentException("iParent must not be null!");
        }
        if (iFileRecord == null) {
            throw new IllegalArgumentException("iFileRecord must not be null!");
        }
        this.parent = iParent;
        this.fileRecord = iFileRecord;
        this.keyRecord = iHardLinkRecord != null ? iHardLinkRecord : iFileRecord;
        this.catalogFile = this.fileRecord.getData();
        this.attributes = new HFSCommonFSAttributes(this, this.catalogFile);
        this.dataFork = new HFSCommonFSFork(this, FSForkType.DATA, this.catalogFile.getDataFork());
        this.resourceFork = new HFSCommonFSFork(this, FSForkType.MACOS_RESOURCE, this.catalogFile.getResourceFork());
    }

    public FSAttributes getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.parent.getProperNodeName(this.keyRecord);
    }

    public FSFork getMainFork() {
        return this.getForkByType(FSForkType.DATA);
    }

    public FSFork[] getAllForks() {
        return new FSFork[]{this.dataFork, this.resourceFork};
    }

    public FSFork getForkByType(FSForkType type) {
        switch (type) {
            case DATA: {
                return this.dataFork;
            }
            case MACOS_RESOURCE: {
                return this.resourceFork;
            }
        }
        return null;
    }

    public long getCombinedLength() {
        return this.dataFork.getLength() + this.resourceFork.getLength();
    }

    ReadableRandomAccessStream getReadableDataForkStream() {
        return this.parent.getReadableDataForkStream(this.fileRecord);
    }

    ReadableRandomAccessStream getReadableResourceForkStream() {
        return this.parent.getReadableResourceForkStream(this.fileRecord);
    }

    HFSCommonFileSystemHandler getFileSystemHandler() {
        return this.parent;
    }

    public CommonHFSCatalogFile getInternalCatalogFile() {
        return this.catalogFile;
    }
}

