/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.xml;

import java.nio.charset.Charset;
import java.util.List;
import org.catacombae.dmgextractor.io.SynchronizedRandomAccessStream;
import org.catacombae.xml.Attribute;
import org.catacombae.xml.Attribute2;
import org.catacombae.xml.ExternalID;
import org.catacombae.xml.NodeBuilder;
import org.catacombae.xml.XMLContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeBuilderContentHandler
extends XMLContentHandler {
    private NodeBuilder nodeBuilder;
    private SynchronizedRandomAccessStream sras;
    private Charset encoding;

    public NodeBuilderContentHandler(NodeBuilder nodeBuilder, SynchronizedRandomAccessStream sras, Charset encoding) {
        super(encoding);
        this.nodeBuilder = nodeBuilder;
        this.sras = sras;
        this.encoding = encoding;
    }

    @Override
    public void xmlDecl(String version, String encoding, Boolean standalone) {
    }

    @Override
    public void pi(String id, String content) {
    }

    @Override
    public void comment(String comment) {
    }

    @Override
    public void doctype(String name, ExternalID eid) {
    }

    @Override
    public void cdata(String cdata) {
        try {
            this.nodeBuilder.characters(cdata.toCharArray(), 0, cdata.length());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void emptyElement(String name, List<Attribute> attributes) {
        try {
            this.startElement(name, attributes);
            this.endElement(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startElement(String name, List<Attribute> attributes) {
        try {
            Attribute2[] attrs = new Attribute2[attributes.size()];
            int i = 0;
            for (Attribute a : attributes) {
                attrs[i++] = new Attribute2("", a.identifier, "CDATA", "", a.value.toString());
            }
            this.nodeBuilder.startElementInternal(null, null, name, attrs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void endElement(String name) {
        try {
            this.nodeBuilder.endElement(null, null, name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void chardata(int beginLine, int beginColumn, int endLine, int endColumn) {
        this.nodeBuilder.characters(this.sras, this.encoding, beginLine, beginColumn, endLine, endColumn);
    }

    @Override
    public void reference(String ref) {
        try {
            if (ref.startsWith("&#")) {
                int[] codePoints = new int[]{ref.startsWith("&#x") ? Integer.parseInt(ref.substring(3), 16) : Integer.parseInt(ref.substring(2), 10)};
                char[] cp_ca = Character.toChars(codePoints[0]);
                this.nodeBuilder.characters(cp_ca, 0, cp_ca.length);
            } else {
                System.out.println("WARNING: Encountered external references, which cannot be resolved with this version of the parser.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

