/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.xml;

import java.io.PrintStream;
import java.io.Reader;
import java.util.LinkedList;
import org.catacombae.dmgextractor.Util;
import org.catacombae.dmgextractor.io.ConcatenatedReader;
import org.catacombae.xml.Attribute2;
import org.catacombae.xml.XMLElement;
import org.catacombae.xml.XMLText;

public class XMLNode
extends XMLElement {
    public final String namespaceURI;
    public final String sName;
    public final String qName;
    public final Attribute2[] attrs;
    public final XMLNode parent;
    private final LinkedList<XMLElement> children;

    public XMLNode(String namespaceURI, String sName, String qName, Attribute2[] attrs, XMLNode parent) {
        this.namespaceURI = namespaceURI;
        this.sName = sName;
        this.qName = qName;
        this.attrs = attrs;
        this.parent = parent;
        this.children = new LinkedList();
    }

    public void addChild(XMLElement x) {
        this.children.addLast(x);
    }

    public void printTree(PrintStream pw) {
        this._printTree(pw, 0);
    }

    protected void _printTree(PrintStream pw, int level) {
        for (int i = 0; i < level; ++i) {
            pw.print(" ");
        }
        pw.print("<");
        pw.print(this.qName);
        for (Attribute2 a : this.attrs) {
            pw.print(" " + a.qName + "=" + a.value);
        }
        pw.println(">");
        for (XMLElement xe : this.children) {
            xe._printTree(pw, level + 1);
        }
        for (int i = 0; i < level; ++i) {
            pw.print(" ");
        }
        pw.println("</" + this.qName + ">");
    }

    public XMLElement[] getChildren() {
        return this.children.toArray(new XMLElement[this.children.size()]);
    }

    public XMLNode cd(String type) {
        for (XMLElement xn : this.getChildren()) {
            if (!(xn instanceof XMLNode) || !((XMLNode)xn).qName.equals(type)) continue;
            return (XMLNode)xn;
        }
        return null;
    }

    public XMLNode cdkey(String key) {
        boolean keyFound = false;
        for (XMLElement xn : this.getChildren()) {
            if (!(xn instanceof XMLNode)) continue;
            if (keyFound) {
                return (XMLNode)xn;
            }
            if (!((XMLNode)xn).qName.equals("key")) continue;
            for (XMLElement xn2 : ((XMLNode)xn).getChildren()) {
                try {
                    String s;
                    if (!(xn2 instanceof XMLText) || !(s = Util.readFully(((XMLText)xn2).getText())).equals(key)) continue;
                    keyFound = true;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    public Reader getKeyValue(String key) {
        XMLNode keyNode = this.cdkey(key);
        XMLElement[] nodeChildren = keyNode.getChildren();
        if (nodeChildren.length != 1) {
            LinkedList<Reader> collectedReaders = new LinkedList<Reader>();
            for (XMLElement xe : keyNode.getChildren()) {
                if (!(xe instanceof XMLText)) continue;
                try {
                    Reader xt = ((XMLText)xe).getText();
                    collectedReaders.addLast(xt);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ConcatenatedReader result = collectedReaders.size() == 0 ? null : new ConcatenatedReader(collectedReaders.toArray(new Reader[collectedReaders.size()]));
            return result;
        }
        if (nodeChildren[0] instanceof XMLText) {
            try {
                return ((XMLText)nodeChildren[0]).getText();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

