/*
 * Copyright (c) 2007 CACE Technologies, Davis (California)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * I/O control codes and structures used for the communication between 
 * the user level code and the airpcap-n driver.
 *
 */

#ifndef _ATH_CAP_IOCTLS_H_
#define _ATH_CAP_IOCTLS_H_

//
// For some reason, cygnus includes a definition of C_ASSERT
// that doesn't work if you use C_ASSERT in a header file, 
// after each structure definition
//
#ifndef _MSC_VER
#ifdef C_ASSERT
#undef C_ASSERT
#endif //C_ASSERT
#define C_ASSERT(expr) extern char __C_ASSERT__[(expr)?1:-1]
#endif //_MSC_VER

#define DEVICE_NAME_0_W				L"\\Device\\Ath5008Cap"
#define DEVICE_GLOBAL_NAME_0_W		L"\\\\.\\Global\\Ath5008Cap" 
#define DEVICE_GLOBAL_NAME_0_A		"\\\\.\\Global\\Ath5008Cap" 
#define SYM_LINK_0_W				L"\\DosDevices\\Ath5008Cap"
#define ATHEROS_ADAPTER_NAME_0_A	"\\Device\\ath_cace00"
#define ATHEROS_ADAPTER_NAME_0_W	L"\\Device\\ath_cace00"

#define DEVICE_NAME_1_W				L"\\Device\\Ath5008Cap1"
#define DEVICE_GLOBAL_NAME_1_W		L"\\\\.\\Global\\Ath5008Cap1" 
#define DEVICE_GLOBAL_NAME_1_A		"\\\\.\\Global\\Ath5008Cap1" 
#define SYM_LINK_1_W				L"\\DosDevices\\Ath5008Cap1"
#define ATHEROS_ADAPTER_NAME_1_A	"\\Device\\ath_cace01"
#define ATHEROS_ADAPTER_NAME_1_W	L"\\Device\\ath_cace01"

#define ATHEROS_ADAPTER_DESC_A		"AirPcap N Wireless Capture Device"
#define ATHEROS_ADAPTER_DESC_W		L"AirPcap N Wireless Capture Device"

#define ATH_CAP_PARAM_LINKTYPE_A	"CaptureLinkType"
#define ATH_CAP_PARAM_CHANNELFREQ_A	"CaptureChannelFrequency"
#define ATH_CAP_PARAM_EXTCHANNEL_A	"CaptureChannelExtension"
#define ATH_CAP_PARAM_ENFCSRECEPTION_A "CaptureEnableFcsReception"
#define ATH_CAP_PARAM_RXERRORFILTER_A "CaptureReceiveErrorFilter"
#define ATH_CAP_PARAM_BUFFERSIZE_A	"CaptureBufferSize"
#define ATH_CAP_PARAM_MINTOCOPY_A	"CaptureMinToCopy"
#define ATH_CAP_PARAM_WEPKEYS_A		"WepKeys"

#ifdef ATH_CAP_USE_DEVICE_1
#define DEVICE_NAME_W				DEVICE_NAME_1_W		
#define DEVICE_GLOBAL_NAME_W		DEVICE_GLOBAL_NAME_1_W
#define DEVICE_GLOBAL_NAME_A		DEVICE_GLOBAL_NAME_1_A
#define SYM_LINK_W					SYM_LINK_1_W
#define ATHEROS_ADAPTER_NAME_A		ATHEROS_ADAPTER_NAME_1_A
#define ATHEROS_ADAPTER_NAME_W		ATHEROS_ADAPTER_NAME_1_W
#endif //ATH_CAP_USE_DEVICE_1

#ifdef ATH_CAP_USE_DEVICE_0
#define DEVICE_NAME_W				DEVICE_NAME_0_W		
#define DEVICE_GLOBAL_NAME_W		DEVICE_GLOBAL_NAME_0_W
#define DEVICE_GLOBAL_NAME_A		DEVICE_GLOBAL_NAME_0_A
#define SYM_LINK_W					SYM_LINK_0_W
#define ATHEROS_ADAPTER_NAME_A		ATHEROS_ADAPTER_NAME_0_A
#define ATHEROS_ADAPTER_NAME_W		ATHEROS_ADAPTER_NAME_0_W
#endif //ATH_CAP_USE_DEVICE_0

#define ATH_CAP_IOCTL_BINDTOADAPTER			CTL_CODE(FILE_DEVICE_UNKNOWN,	2049,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_SETCAPTUREBUFFERSIZE	CTL_CODE(FILE_DEVICE_UNKNOWN,	2050,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_SETREADEVENT			CTL_CODE(FILE_DEVICE_UNKNOWN,	2051,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_SETREADMINTOCOPY		CTL_CODE(FILE_DEVICE_UNKNOWN,	2052,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_SETCHANNELINFO		CTL_CODE(FILE_DEVICE_UNKNOWN,	2053,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_GETCHANNELINFO		CTL_CODE(FILE_DEVICE_UNKNOWN,	2054,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_SETHEADERTYPE			CTL_CODE(FILE_DEVICE_UNKNOWN,	2055,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_GETHEADERTYPE			CTL_CODE(FILE_DEVICE_UNKNOWN,	2056,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_GETCAPTUREBUFFERSIZE	CTL_CODE(FILE_DEVICE_UNKNOWN,	2057,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_SETBPFFILTER			CTL_CODE(FILE_DEVICE_UNKNOWN,	2058,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_GETMACADDRESS			CTL_CODE(FILE_DEVICE_UNKNOWN,	2059,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_GETSTATISTICS			CTL_CODE(FILE_DEVICE_UNKNOWN,	2060,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_GETNETGCFGINSTANCEID	CTL_CODE(FILE_DEVICE_UNKNOWN,	2061,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_GETSUPPORTEDCHANNELINFO CTL_CODE(FILE_DEVICE_UNKNOWN,	2062,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	

#define ATH_CAP_IOCTL_SETERRORFILTER		CTL_CODE(FILE_DEVICE_UNKNOWN,	2065,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_GETERRORFILTER		CTL_CODE(FILE_DEVICE_UNKNOWN,	2066,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	

#define ATH_CAP_IOCTL_SETFCSRECEPTION		CTL_CODE(FILE_DEVICE_UNKNOWN,	2067,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_GETFCSRECEPTION		CTL_CODE(FILE_DEVICE_UNKNOWN,	2068,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	

#define ATH_CAP_IOCTL_GETREADMINTOCOPY		CTL_CODE(FILE_DEVICE_UNKNOWN,	2069,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	

// NOT USED
//#define ATH_CAP_IOCTL_SETKEYS				CTL_CODE(FILE_DEVICE_UNKNOWN,	2075,	METHOD_BUFFERED,	FILE_ANY_ACCESS)
//#define ATH_CAP_IOCTL_GETKEYS				CTL_CODE(FILE_DEVICE_UNKNOWN,	2076,	METHOD_BUFFERED,	FILE_ANY_ACCESS)

//
// These IOCTLs set and get the default values for the device
//
#define ATH_CAP_IOCTL_SETHEADERTYPE_DEV			CTL_CODE(FILE_DEVICE_UNKNOWN,	2070,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_SETCAPTUREBUFFERSIZE_DEV	CTL_CODE(FILE_DEVICE_UNKNOWN,	2071,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_SETERRORFILTER_DEV		CTL_CODE(FILE_DEVICE_UNKNOWN,	2072,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_SETFCSRECEPTION_DEV		CTL_CODE(FILE_DEVICE_UNKNOWN,	2073,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	
#define ATH_CAP_IOCTL_SETREADMINTOCOPY_DEV		CTL_CODE(FILE_DEVICE_UNKNOWN,	2074,	METHOD_BUFFERED,	FILE_ANY_ACCESS)	

#define ATH_CAP_IOCTL_SETKEYS_DEV				CTL_CODE(FILE_DEVICE_UNKNOWN,	2077,	METHOD_BUFFERED,	FILE_ANY_ACCESS)
#define ATH_CAP_IOCTL_GETKEYS_DEV				CTL_CODE(FILE_DEVICE_UNKNOWN,	2078,	METHOD_BUFFERED,	FILE_ANY_ACCESS)
#define ATH_CAP_IOCTL_SETKEYS_DRV				CTL_CODE(FILE_DEVICE_UNKNOWN,	2079,	METHOD_BUFFERED,	FILE_ANY_ACCESS)
#define ATH_CAP_IOCTL_GETKEYS_DRV				CTL_CODE(FILE_DEVICE_UNKNOWN,	2080,	METHOD_BUFFERED,	FILE_ANY_ACCESS)

#define ATH_CAP_IOCTL_SETDECRYPTIONSTATE		CTL_CODE(FILE_DEVICE_UNKNOWN,	2081,	METHOD_BUFFERED,	FILE_ANY_ACCESS)
#define ATH_CAP_IOCTL_SETDECRYPTIONSTATE_DRV	CTL_CODE(FILE_DEVICE_UNKNOWN,	2082,	METHOD_BUFFERED,	FILE_ANY_ACCESS)
#define ATH_CAP_IOCTL_GETDECRYPTIONSTATE		CTL_CODE(FILE_DEVICE_UNKNOWN,	2083,	METHOD_BUFFERED,	FILE_ANY_ACCESS)

#define ATH_CAP_IOCTL_GETNUMLEDS				CTL_CODE(FILE_DEVICE_UNKNOWN,	2084,	METHOD_BUFFERED,	FILE_ANY_ACCESS)
#define ATH_CAP_IOCTL_TURNLEDON					CTL_CODE(FILE_DEVICE_UNKNOWN,	2085,	METHOD_BUFFERED,	FILE_ANY_ACCESS)
#define ATH_CAP_IOCTL_TURNLEDOFF				CTL_CODE(FILE_DEVICE_UNKNOWN,	2086,	METHOD_BUFFERED,	FILE_ANY_ACCESS)

//                                            //
// The next IOCTL CODE is   --->  2087  <---  //
//                                            //

#define ATH_ERRORFILTER_OK				((ULONG)0x00000001)
#define ATH_ERRORFILTER_FCSERROR		((ULONG)0x00000002)
#define ATH_ERRORFILTER_PHYERROR		((ULONG)0x00000004)
#define ATH_ERRORFILTER_ZEROLENPACKET	((ULONG)0x00000008)

typedef struct _ATH_CACE_CHANNEL
{
	ULONG Frequency;
	CHAR ExtChannel;
	UCHAR Reserved[3];
}
	ATH_CACE_CHANNEL;

C_ASSERT(sizeof(ATH_CACE_CHANNEL) == 8);

typedef enum _ATH_CACE_HEADER_TYPE
{
	ATH_CACE_HEADER_TYPE_80211		= 0,
	ATH_CACE_HEADER_TYPE_PPI		= 1,
	ATH_CACE_HEADER_TYPE_RADIOTAP	= 2,
}
	ATH_CACE_HEADER_TYPE;

typedef struct _ATH_CAP_STATISTICS
{
	ULONGLONG	Received;
	ULONGLONG	ReceivedOk;
	ULONGLONG	ReceivedPhyError;
	ULONGLONG	ReceivedCrcError;
	ULONGLONG	Captured;
	ULONGLONG	DroppedBufferFull;
	ULONGLONG	DroppedByFilter;

}
	ATH_CAP_STATISTICS, *PATH_CAP_STATISTICS;

C_ASSERT(sizeof(ATH_CAP_STATISTICS) == 56);

#endif //_ATH_CAP_IOCTLS_H_

