/*
 * Copyright (c) 2006 - 2007 CACE Technologies, Davis (California)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef IOCTLS_H
#define IOCTLS_H

#ifndef CTL_CODE
	#pragma message("CTL_CODE undefined. Include winioctl.h or wdm.h")
#endif

//
// ioctls
//
#define IOCTL_SETCHANNEL				CTL_CODE(FILE_DEVICE_UNKNOWN, 2056, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETCHANNEL				CTL_CODE(FILE_DEVICE_UNKNOWN, 2057, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETLINKLAYER				CTL_CODE(FILE_DEVICE_UNKNOWN, 2058, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETLINKLAYER				CTL_CODE(FILE_DEVICE_UNKNOWN, 2059, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETFILTER					CTL_CODE(FILE_DEVICE_UNKNOWN, 2060, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETSTATS					CTL_CODE(FILE_DEVICE_UNKNOWN, 2061, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SMINTOCOPY				CTL_CODE(FILE_DEVICE_UNKNOWN, 2062, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETBSIZE					CTL_CODE(FILE_DEVICE_UNKNOWN, 2064, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETBSIZE					CTL_CODE(FILE_DEVICE_UNKNOWN, 2065, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETMACADDR				CTL_CODE(FILE_DEVICE_UNKNOWN, 2066, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_STORECONFIG				CTL_CODE(FILE_DEVICE_UNKNOWN, 2067, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_LOADCONFIG				CTL_CODE(FILE_DEVICE_UNKNOWN, 2068, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETCRCPRESENCE			CTL_CODE(FILE_DEVICE_UNKNOWN, 2069, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETCRCPRESENCE			CTL_CODE(FILE_DEVICE_UNKNOWN, 2070, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETKEYS					CTL_CODE(FILE_DEVICE_UNKNOWN, 2071, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETKEYS					CTL_CODE(FILE_DEVICE_UNKNOWN, 2072, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETCRCVALIDATION			CTL_CODE(FILE_DEVICE_UNKNOWN, 2073, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETCRCVALIDATION			CTL_CODE(FILE_DEVICE_UNKNOWN, 2074, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_TURNLEDON					CTL_CODE(FILE_DEVICE_UNKNOWN, 2075, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_TURNLEDOFF				CTL_CODE(FILE_DEVICE_UNKNOWN, 2076, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SENDPACKET				CTL_CODE(FILE_DEVICE_UNKNOWN, 2077, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETSHAREDEVENT			CTL_CODE(FILE_DEVICE_UNKNOWN, 2078, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETDECRYPTIONSTATUS		CTL_CODE(FILE_DEVICE_UNKNOWN, 2079, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETDECRYPTIONSTATUS		CTL_CODE(FILE_DEVICE_UNKNOWN, 2080, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETCCACOUNT				CTL_CODE(FILE_DEVICE_UNKNOWN, 2081, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETDRIVERKEYS				CTL_CODE(FILE_DEVICE_UNKNOWN, 2083, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETDRIVERKEYS				CTL_CODE(FILE_DEVICE_UNKNOWN, 2084, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETDRIVERDECRYPTIONSTATUS	CTL_CODE(FILE_DEVICE_UNKNOWN, 2085, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETDRIVERDECRYPTIONSTATUS	CTL_CODE(FILE_DEVICE_UNKNOWN, 2086, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETCHANNELBAND			CTL_CODE(FILE_DEVICE_UNKNOWN, 2087, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETCHANNELBAND			CTL_CODE(FILE_DEVICE_UNKNOWN, 2088, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETMONITORMODE			CTL_CODE(FILE_DEVICE_UNKNOWN, 2089, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETMONITORMODE			CTL_CODE(FILE_DEVICE_UNKNOWN, 2090, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETSUPPORTEDCHANNELINFO	CTL_CODE(FILE_DEVICE_UNKNOWN, 2091, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETFREQUENCY				CTL_CODE(FILE_DEVICE_UNKNOWN, 2092, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETFREQUENCY				CTL_CODE(FILE_DEVICE_UNKNOWN, 2093, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETMACADDR				CTL_CODE(FILE_DEVICE_UNKNOWN, 2094, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETUSBID					CTL_CODE(FILE_DEVICE_UNKNOWN, 2095, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETTRANSMISSIONLOCK		CTL_CODE(FILE_DEVICE_UNKNOWN, 2096, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETTRANSMISSIONLOCK		CTL_CODE(FILE_DEVICE_UNKNOWN, 2097, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETCHANNELLOCK			CTL_CODE(FILE_DEVICE_UNKNOWN, 2098, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETCHANNELLOCK			CTL_CODE(FILE_DEVICE_UNKNOWN, 2099, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETTXPOWER				CTL_CODE(FILE_DEVICE_UNKNOWN, 3000, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETTXPOWER				CTL_CODE(FILE_DEVICE_UNKNOWN, 3001, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_SETFREQUENCY_EX			CTL_CODE(FILE_DEVICE_UNKNOWN, 3002, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETFREQUENCY_EX			CTL_CODE(FILE_DEVICE_UNKNOWN, 3003, METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_GETHWTIMESTAMP			CTL_CODE(FILE_DEVICE_UNKNOWN, 3004, METHOD_IN_DIRECT, FILE_ANY_ACCESS)

//
// Tx Header Structure
//
#ifndef __MINGW32__
#pragma pack(push)
#pragma pack(1)

#endif // __MINGW32__
typedef struct _AIRPCAP_TX_HEADER
{
	ULONG Length;	//length in bytes of the packet, no alignment
	ULONG Rate;
	ULONG Power;
	ULONG Flags;
}
#ifdef __MINGW32__
__attribute__((__packed__))
#endif // __MINGW32__
AIRPCAP_TX_HEADER, *PAIRPCAP_TX_HEADER;

#define AIRPCAP_TX_HEADER_FLAG_N_RATE		0x00000001
#define AIRPCAP_TX_HEADER_FLAG_SGI			0x00000002
#define AIRPCAP_TX_HEADER_FLAG_40MHZ		0x00000004
#define AIRPCAP_TX_HEADER_FLAG_AMPDU_FIRST	0x00000008
#define AIRPCAP_TX_HEADER_FLAG_AMPDU_MIDDLE	0x00000010
#define AIRPCAP_TX_HEADER_FLAG_AMPDU_LAST	0x00000020

#ifndef __MINGW32__
#pragma pack(pop)
#endif // __MINGW32__

#endif
