/*
 * Copyright (c) 2007 CACE Technologies, Davis (California)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 */

#ifndef __KEYSTORE_H___C8877C57_6707_4e5a_BA8A_04D49E96F43D
#define __KEYSTORE_H___C8877C57_6707_4e5a_BA8A_04D49E96F43D

//
// Writes the keys to the global key store. 
// \param pKeysCollection The keys to be saved
// \param Ebuf In case of error it contains a meaningful description of the error
// \return TRUE in case of success, FALSE otherwise. Ebuf contains the description of the error
// 
//  Implementation note. The global key store is a registry key whose permission is set to R/W everyone
//                       so that everyone can change the keys
//
//  Note: this function performs a check against the key validity and fails in case some info is bogus
//
BOOL WriteKeysToAirpcapGlobalKeyStore(PAirpcapKeysCollection pKeysCollection, char *Ebuf);

//
// Reads the keys from the global key store. 
// \param pKeysCollection Pointer to a user allocated AirpcapKeysCollection structure. On success
//        it will contain the returned keys.
// \param PKeysCollectionSize Pointer to a caller-allocated integer. 
//        On input, the size of the pKeysCollection structure *including* the 
//        the bytes to store the keys at the end of the structure itself. On success, the number of
//        bytes actually used. On failure, if the buffer was not large enough it will contain the 
//        number of needed bytes. In any other type of failure it will contain 0.
// \param Ebuf In case of error it contains a meaningful description of the error
// \return TRUE in case of success, FALSE otherwise. Ebuf contains the description of the error
// 
//  Implementation note. The global key store is a registry key whose permission is set to R/W everyone
//                       so that everyone can change the keys
//
BOOL ReadKeysFromAirpcapGlobalKeyStore(PAirpcapKeysCollection pKeysCollection, UINT* PKeysCollectionSize, char *Ebuf);

//
// Reads the global decryption status from the global key store. 
// \param PDecryptionState Pointer to a user allocated variable. On success
//        it will contain the current global decryption state (Enabled or disabled).
//        By default the decryption state is set to ON.
// \param Ebuf In case of error it contains a meaningful description of the error
// \return TRUE in case of success, FALSE otherwise. Ebuf contains the description of the error
// 
//  Implementation note. The global key store is a registry key whose permission is set to R/W everyone
//                       so that everyone can change the keys
//
BOOL ReadDecryptionStateFromAirpcapGlobalKeyStore(PAirpcapDecryptionState PDecryptionState, char *Ebuf);

//
// Writes the global decryption status to the global key store. 
// \param DecryptionState New decryption status to be written to the registry.
// \param Ebuf In case of error it contains a meaningful description of the error
// \return TRUE in case of success, FALSE otherwise. Ebuf contains the description of the error
// 
//  Implementation note. The global key store is a registry key whose permission is set to R/W everyone
//                       so that everyone can change the keys
//
BOOL WriteDecryptionStateToAirpcapGlobalKeyStore(AirpcapDecryptionState DecryptionState, char *Ebuf);


#endif //__KEYSTORE_H___C8877C57_6707_4e5a_BA8A_04D49E96F43D
