#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BUFFER_SIZE 64
#define NUM_STUDENTS 3

typedef struct {
    char name[BUFFER_SIZE];
} Student;

void print_student_name(Student *students, int index) {
    if (index < 0 || index >= NUM_STUDENTS) {
        printf("Invalid index.\n");
        return;
    }

    printf("Student name at index %d: \n", index);
    // Creating a format string vulnerability
    printf(students[index].name);
    printf("\n");
}

void add_student(Student *students, int index) {
    if (index < 0 || index >= NUM_STUDENTS) {
        printf("Invalid index.\n");
        return;
    }

    char buffer[BUFFER_SIZE];
    printf("Enter student name: \n");
    gets(buffer);
    strcpy(students[index].name, buffer);
}

int main() {
    Student students[NUM_STUDENTS] = {0};
    int choice, index;

    while (1) {
        printf("\nMenu:\n");
        printf("1. Add student name\n");
        printf("2. Print student name\n");
        printf("3. Exit\n");
        printf("Enter your choice: \n");
        scanf("%d", &choice);
        getchar(); 

        switch (choice) {
            case 1:
                printf("Enter index to add the student name: \n");
                scanf("%d", &index);
                getchar();
                add_student(students, index);
                break;
            case 2:
                printf("Enter index to print the student name: \n");
                scanf("%d", &index);
                getchar();
                print_student_name(students, index);
                break;
            case 3:
                exit(0);
                break;
            default:
                printf("Invalid choice.\n");
                break;
        }
    }

    return 0;
}