# Getting started

Follow the steps in this section to install Cinemachine in your project. Get started quickly with a few Virtual Cameras, then gradually add more sophisticated features as needed.

## Installing Cinemachine

Cinemachine is a free package, available for any project. You install Cinemachine like [any other package](https://docs.unity3d.com/Packages/com.unity.package-manager-ui@latest/index.html).

After you install Cinemachine, a new *Cinemachine* folder appears in the Gizmos folder of your Project window, and a new __Cinemachine__ menu is available.

![Cinemachine menu in the Unity Editor](images/CinemachineMenu.png)

## Upgrading from the Cinemachine Asset Package

If you already installed Cinemachine from the Unity Asset Store, you can upgrade to the Cinemachine Package.

To upgrade to the Cinemachine Package:

1. In Unity Editor, 2018.1 or later, open your project.

2. Save the current Scene you are working on.

3. Create a new, empty Scene.

4. In the [Project window](https://docs.unity3d.com/Manual/ProjectView.html), delete the Cinemachine Asset and any CinemachinePostProcessing adaptor assets you may have installed.

5. Install the Cinemachine package.

## Learning more about Cinemachine

Use the [Unity Tutorials](https://unity3d.com/learn/tutorials/s/animation) to see demonstrations for setting up and using Cinemachine.

Experiment with the example Assets. In the Unity menu, choose __Cinemachine > Import Example Asset Package__ to import these Assets.

Discuss your Cinemachine challenges and ideas in the [Cinemachine community forum](https://forum.unity.com/forums/cinemachine.136) and in the [Answers page](https://answers.unity.com/search.html?sort=relevance&q=cinemachine).

