# ERC721 Exercise 1

## Intro
Your goal is to create an ERC721 token (NFT), based on OpenZeppelin `ERC721.sol` contract,
deploy it to your local hardhat chain, and test it.

## Accounts
* 0 - Deployer
* 1 - User1
* 2 - User2

## Tasks

### Task 1
**Create your contract under the `./contracts/erc721-1` folder:**
1. Import and inherit from OpenZeppelin `ERC721.sol` contract
2. Choose your token NAME and SYMBOl
3. Implement an external `mint()` function according the following properties:
   1. Max Supply = 10,000
   2. Mint Price = 0.1 ETH
4. Keep track of the current supply using a public state variable


### Task 2
**Testing:**
1. Deploy your contract from the deployer account
2. Mint 5 tokens from `Deployer`
3. Mint 3 Tokens from `User1`
4. Test that every account has the right amount of tokens
5. Transfer 1 token from `User1` to `User2` (Token ID 6)
6. Make sure that the token that was transfered is now owned by `User2`
7. From `Deployer`: approve `User1` to spend one of the tokens (Token ID 3)
8. Test that `User1` has the right approval that was granted by the `Deployer`
9. From `User1`: transfer to yourself the token that was approved by the `Deployer`
10. Test that `User1` owns the transfered token
11. Test that every user has the right amount of tokens


## Links that might be useful
1. ERC721 Standard on Ethereum Website
https://eips.ethereum.org/EIPS/eip-721
2. ERC721 Source code on Github
https://github.com/OpenZeppelin/openzeppelin-contracts/blob/master/contracts/token/ERC721/ERC721.sol
3. Hardhat Tests
https://hardhat.org/tutorial/testing-contracts