# Start of creating instances
#resource "aws_instance" "web1" {
#
#    ami = "${lookup(var.AMI, var.AWS_REGION)}"
#    instance_type = "t2.micro"
#
#    # VPC
#    subnet_id = "${aws_subnet.prod-subnet-public-1.id}"
#
#    # Set Private IP
#    private_ip = "10.10.0.105"
#
#    # Security Group
#    vpc_security_group_ids = ["${aws_security_group.subnet-sg-allowed.id}"]
#
#   # the Public SSH key
#    key_name = "${aws_key_pair.offensive-dev-key-pair.id}"
#
#    # nginx installation
#    provisioner "file" {
#        source = "nginx.sh"
#        destination = "/tmp/nginx.sh"
#    }
#
#    provisioner "remote-exec" {
#        inline = [
#            "chmod +x /tmp/nginx.sh",
#            "sudo /tmp/nginx.sh"
#        ]
#    }
#
#    connection {
#        user = "${var.EC2_USER}"
#        host = "${aws_instance.web1.public_ip}"
#        private_key = "${file("${var.PRIVATE_KEY_PATH}")}"
#    }
#
#    tags = {
#      Name = "Web1 Box"
#    }
#
#}

# Cobalt Strike Server
resource "aws_instance" "cobalt-strike-server" {

    ami = "ami-0afb5ca65adb5b3e1"
    instance_type = "t2.medium"

    # VPC
    subnet_id = "${aws_subnet.prod-subnet-public-1.id}"

    # Set Private IP
    private_ip = "10.10.0.204"

    # Security Group
    vpc_security_group_ids = ["${aws_security_group.subnet-sg-allowed.id}"]

    # the Public SSH key
    key_name = "${aws_key_pair.offensive-dev-key-pair.id}"

    # nginx installation
    #provisioner "file" {
    #    source = "nginx.sh"
    #    destination = "/tmp/nginx.sh"
    #}

    #provisioner "remote-exec" {
    #    inline = [
    #        "chmod +x /tmp/nginx.sh",
    #        "sudo /tmp/nginx.sh"
    #    ]
    #}

    connection {
        user = "${var.EC2_USER}"
        host = "${aws_instance.cobalt-strike-server.public_ip}"
        private_key = "${file("${var.PRIVATE_KEY_PATH}")}"
    }

    tags = {
      Name = "Offensive Development - Cobalt Strike Server"
    }

}

# Attacker Kali Box
resource "aws_instance" "attacker-kali-box" {

    ami = "ami-0711f26bbff697040"
    instance_type = "t2.medium"

    # VPC
    subnet_id = "${aws_subnet.prod-subnet-public-1.id}"

    # Set Private IP
    private_ip = "10.10.0.108"

    # Security Group
    vpc_security_group_ids = ["${aws_security_group.subnet-sg-allowed.id}"]

    # the Public SSH key
    key_name = "${aws_key_pair.offensive-dev-key-pair.id}"

    # nginx installation
    #provisioner "file" {
    #    source = "nginx.sh"
    #    destination = "/tmp/nginx.sh"
    #}

    #provisioner "remote-exec" {
    #    inline = [
    #        "chmod +x /tmp/nginx.sh",
    #        "sudo /tmp/nginx.sh"
    #    ]
    #}

    connection {
        user = "admin"
        host = "${aws_instance.attacker-kali-box.public_ip}"
        private_key = "${file("${var.PRIVATE_KEY_PATH}")}"
    }

    tags = {
      Name = "Offensive Development - Attacker Kali Box"
    }

}

# Windows Dev Box
resource "aws_instance" "windows-dev-box" {

    ami = "ami-054a53c4e15cf3d72"
    instance_type = "t2.large"

    # VPC
    subnet_id = "${aws_subnet.prod-subnet-public-1.id}"

    # Set Private IP
    private_ip = "10.10.0.122"

    # Security Group
    vpc_security_group_ids = ["${aws_security_group.subnet-sg-allowed.id}"]

    # the Public SSH key
    key_name = "${aws_key_pair.offensive-dev-key-pair.id}"

    # nginx installation
    #provisioner "file" {
    #    source = "nginx.sh"
    #    destination = "/tmp/nginx.sh"
    #}

    #provisioner "remote-exec" {
    #    inline = [
    #        "chmod +x /tmp/nginx.sh",
    #        "sudo /tmp/nginx.sh"
    #    ]
    #}

    #connection {
    #    user = "${var.EC2_USER}"
    #    host = "${aws_instance.windows-dev-box.public_ip}"
    #    private_key = "${file("${var.PRIVATE_KEY_PATH}")}"
    #}

    tags = {
      Name = "Offensive Development - Windows Dev Box"
    }

}

# Windows Defender Box
resource "aws_instance" "windows-defender-box" {

    ami = "ami-064cbacbf71035c53"
    instance_type = "t2.medium"

    # VPC
    subnet_id = "${aws_subnet.prod-subnet-public-1.id}"

    # Set Private IP
    private_ip = "10.10.0.149"

    # Security Group
    vpc_security_group_ids = ["${aws_security_group.subnet-sg-allowed.id}"]

    # the Public SSH key
    key_name = "${aws_key_pair.offensive-dev-key-pair.id}"

    # nginx installation
    #provisioner "file" {
    #    source = "nginx.sh"
    #    destination = "/tmp/nginx.sh"
    #}

    #provisioner "remote-exec" {
    #    inline = [
    #        "chmod +x /tmp/nginx.sh",
    #        "sudo /tmp/nginx.sh"
    #    ]
    #}

    #connection {
    #    user = "${var.EC2_USER}"
    #    host = "${aws_instance.windows-defender-box.public_ip}"
    #    private_key = "${file("${var.PRIVATE_KEY_PATH}")}"
    #}

    tags = {
      Name = "Offensive Development - Windows Defender Box"
    }

}

# Windows Sophos Box
resource "aws_instance" "windows-sophos-box" {

    ami = "ami-033631ee58086f549"
    instance_type = "t2.medium"

    # VPC
    subnet_id = "${aws_subnet.prod-subnet-public-1.id}"

    # Set Private IP
    private_ip = "10.10.0.235"

    # Security Group
    vpc_security_group_ids = ["${aws_security_group.subnet-sg-allowed.id}"]

    # the Public SSH key
    key_name = "${aws_key_pair.offensive-dev-key-pair.id}"

    # nginx installation
    #provisioner "file" {
    #    source = "nginx.sh"
    #    destination = "/tmp/nginx.sh"
    #}

    #provisioner "remote-exec" {
    #    inline = [
    #        "chmod +x /tmp/nginx.sh",
    #        "sudo /tmp/nginx.sh"
    #    ]
    #}

    #connection {
    #    user = "${var.EC2_USER}"
    #    host = "${aws_instance.windows-defender-box.public_ip}"
    #    private_key = "${file("${var.PRIVATE_KEY_PATH}")}"
    #}

    tags = {
      Name = "Offensive Development - Windows Sophos Box"
    }

}

# Windows F-Secure Box
#resource "aws_instance" "windows-fsecure-box" {
#
#    ami = "ami-092ca148c5c73d149"
#    instance_type = "t2.medium"
#
#    # VPC
#    subnet_id = "${aws_subnet.prod-subnet-public-1.id}"
#
#    # Set Private IP
#    private_ip = "10.10.0.250"
#
#    # Security Group
#    vpc_security_group_ids = ["${aws_security_group.subnet-sg-allowed.id}"]
#
#    # the Public SSH key
#    key_name = "${aws_key_pair.offensive-dev-key-pair.id}"
#
#    # nginx installation
#    #provisioner "file" {
#    #    source = "nginx.sh"
#    #    destination = "/tmp/nginx.sh"
#    #}
#
#    #provisioner "remote-exec" {
#    #    inline = [
#    #        "chmod +x /tmp/nginx.sh",
#    #        "sudo /tmp/nginx.sh"
#    #    ]
#    #}
#
#    #connection {
#    #    user = "${var.EC2_USER}"
#    #    host = "${aws_instance.windows-defender-box.public_ip}"
#    #    private_key = "${file("${var.PRIVATE_KEY_PATH}")}"
#    #}
#
#    tags = {
#      Name = "Offensive Development - Windows Cylance Box"
#    }
#
#}

# Windows CrowdStrike Box
resource "aws_instance" "windows-crowdstrike-box" {

    ami = "ami-0e90f6ff7222eb084"
    instance_type = "t2.medium"

    # VPC
    subnet_id = "${aws_subnet.prod-subnet-public-1.id}"

    # Set Private IP
    private_ip = "10.10.0.70"

    # Security Group
    vpc_security_group_ids = ["${aws_security_group.subnet-sg-allowed.id}"]

    # the Public SSH key
    key_name = "${aws_key_pair.offensive-dev-key-pair.id}"

    # nginx installation
    #provisioner "file" {
    #    source = "nginx.sh"
    #    destination = "/tmp/nginx.sh"
    #}

    #provisioner "remote-exec" {
    #    inline = [
    #        "chmod +x /tmp/nginx.sh",
    #        "sudo /tmp/nginx.sh"
    #    ]
    #}

    #connection {
    #    user = "${var.EC2_USER}"
    #    host = "${aws_instance.windows-defender-box.public_ip}"
    #    private_key = "${file("${var.PRIVATE_KEY_PATH}")}"
    #}

    tags = {
      Name = "Offensive Development - Windows CrowdStrike Box"
    }

}

## Windows Cylance Box
#resource "aws_instance" "windows-cylance-box" {
#
#    ami = "ami-077118592d4dad59b"
#    instance_type = "t2.medium"
#
#    # VPC
#    subnet_id = "${aws_subnet.prod-subnet-public-1.id}"
#
#    # Set Private IP
#    private_ip = "10.10.0.162"
#
#    # Security Group
#    vpc_security_group_ids = ["${aws_security_group.subnet-sg-allowed.id}"]
#
#    # the Public SSH key
#    key_name = "${aws_key_pair.offensive-dev-key-pair.id}"
#
#    # nginx installation
#    #provisioner "file" {
#    #    source = "nginx.sh"
#    #    destination = "/tmp/nginx.sh"
#    #}
#
#    #provisioner "remote-exec" {
#    #    inline = [
#    #        "chmod +x /tmp/nginx.sh",
#    #        "sudo /tmp/nginx.sh"
#    #    ]
#    #}
#
#    #connection {
#    #    user = "${var.EC2_USER}"
#    #    host = "${aws_instance.windows-defender-box.public_ip}"
#    #    private_key = "${file("${var.PRIVATE_KEY_PATH}")}"
#    #}
#
#    tags = {
#      Name = "Offensive Development - Windows Cylance Box"
#    }

#}

# Windows ATP Box
resource "aws_instance" "windows-atp-box" {

    ami = "ami-041c9827a40cde845"
    instance_type = "t2.medium"

    # VPC
    subnet_id = "${aws_subnet.prod-subnet-public-1.id}"

    # Set Private IP
    private_ip = "10.10.0.88"

    # Security Group
    vpc_security_group_ids = ["${aws_security_group.subnet-sg-allowed.id}"]

    # the Public SSH key
    key_name = "${aws_key_pair.offensive-dev-key-pair.id}"

    # nginx installation
    #provisioner "file" {
    #    source = "nginx.sh"
    #    destination = "/tmp/nginx.sh"
    #}

    #provisioner "remote-exec" {
    #    inline = [
    #        "chmod +x /tmp/nginx.sh",
    #        "sudo /tmp/nginx.sh"
    #    ]
    #}

    #connection {
    #    user = "${var.EC2_USER}"
    #    host = "${aws_instance.windows-defender-box.public_ip}"
    #    private_key = "${file("${var.PRIVATE_KEY_PATH}")}"
    #}

    tags = {
      Name = "Offensive Development - Windows ATP Box"
    }

}

# Guacamole Server
resource "aws_instance" "guacamole-server" {

    ami = "ami-0c26a073bec4ca413"
    instance_type = "t2.medium"

    # VPC
    subnet_id = "${aws_subnet.prod-subnet-public-1.id}"

    # Set Private IP
    private_ip = "10.10.0.50"

    # Security Group
    vpc_security_group_ids = ["${aws_security_group.guacamole-server-sg-allowed.id}"]

    # the Public SSH key
    key_name = "${aws_key_pair.offensive-dev-key-pair.id}"

    # nginx installation
    #provisioner "file" {
    #    source = "nginx.sh"
    #    destination = "/tmp/nginx.sh"
    #}

    #provisioner "remote-exec" {
    #    inline = [
    #        "chmod +x /tmp/nginx.sh",
    #        "sudo /tmp/nginx.sh"
    #    ]
    #}

    connection {
        user = "admin"
        host = "${aws_instance.guacamole-server.public_ip}"
        private_key = "${file("${var.PRIVATE_KEY_PATH}")}"
    }

    tags = {
      Name = "Offensive Development - Guacamole Server"
    }

}

resource "aws_key_pair" "offensive-dev-key-pair" {
    key_name = "offensive-dev-key-pair"
    public_key = "${file(var.PUBLIC_KEY_PATH)}"
}

# Create Elastic IP for the Guacamole Server EC2 instance
resource "aws_eip" "guacamole-server-eip" {
  vpc  = true
  tags = {
    Name = "guacamole-server-eip"
  }
}
# Associate Elastic IP to Windows Server
resource "aws_eip_association" "guacamole-server-eip-association" {
  instance_id   = aws_instance.guacamole-server.id
  allocation_id = aws_eip.guacamole-server-eip.id
}