#!/bin/bash

target=$1

REDCOLOR="\e[31m"
GREENCOLOR="\e[32m"

if [ ! -d $target ]
then
    mkdir $target
fi

cd $target

echo -e "$REDCOLOR [+] Finding subdomains with Sublist3r..."
python3 /home/techhacker/Documents/subwalker/tools/Sublist3r/sublist3r.py -d $target -t 25 -o subdomains.txt

echo -e "$REDCOLOR [+] Finding subdomnains with Assetfinder..."
/home/techhacker/Documents/subwalker/tools/assetfinder/assetfinder -subs-only $target >> subdomains.txt

echo -e "$REDCOLOR [+] Sorting and Filtering outputs.."
cat subdomains.txt | sort | uniq > subdomains

echo -e "$REDCOLOR [+] Finding live subdomains with httprobe..."
cat subdomains | httprobe > alive.txt

echo -e "$REDCOLOR [+] Finding JS files..."
cat alive.txt | subjs > jsfiles

echo -e "$REDCOLOR [+] Finding subdomnain takeovers..."
subjack -w subdomains -c /home/techhacker/go/src/github.com/haccer/subjack/fingerprints.json -t 25 -ssl -o takeovers.txt

echo -e "$REDCOLOR [+] Fuzzing for directories..."
while read -r line
do
    python3 /home/techhacker/Documents/dirsearch/dirsearch.py -u $line -w /home/techhacker/Documents/wordlists/common.txt -o directory_fuzzing.txt
done < alive.txt

echo -e "$GREENCOLOR [+] Done"



