/*
** USB-Duplicator.c
**
** Template automatically created by Application Wizard 1.2.4.1
**
** Part of solution USB-Duplicator in project USB-Duplicator
*/
#include "vos.h"

/* FTDI:SHF Header Files */
#include "USB.h"
#include "USBHost.h"
#include "GPIO.h"
#include "FAT.h"
#include "msi.h"
#include "BOMS.h"
#include "stdio.h"
#include "errno.h"
#include "stdlib.h"
#include "string.h"
#include "ctype.h"
#include "USB-MSI-SCSI.h"

/* FTDI:EHF */

/* FTDI:SDC Driver Constants */
#define VOS_DEV_USBHOST_1 0
#define VOS_DEV_USBHOST_2 1
#define VOS_DEV_GPIO_PORT_A 2
#define VOS_DEV_FAT_FILE_SYSTEM 3
#define VOS_DEV_BOMS_1 4
#define VOS_DEV_BOMS_2 5

#define VOS_NUMBER_DEVICES 6
/* FTDI:EDC */

#define BUFFER_SIZE 4096

/* FTDI:SDH Driver Handles */
VOS_HANDLE hUSBHOST_1; // USB Host Port 1
VOS_HANDLE hUSBHOST_2; // USB Host Port 2
VOS_HANDLE hGPIO_PORT_A; // GPIO Port A Driver
VOS_HANDLE hFAT_FILE_SYSTEM; // FAT File System for FAT32 and FAT16
VOS_HANDLE hBOMS_1; // Bulk Only Mass Storage for USB disks
VOS_HANDLE hBOMS_2; // Bulk Only Mass Storage for USB disks
/* FTDI:EDH */


/* FTDI:STP Thread Prototypes */
vos_tcb_t *tcbFIRMWARE;

void SetupIOMUX();
void firmware();
/* FTDI:ETP */

// semaphores for read and write operations
vos_semaphore_t semRead;
vos_semaphore_t semWrite;

/* Main code - entry point to firmware */
void main(void)
{
	/* FTDI:SDD Driver Declarations */
	// GPIO Port A configuration context
	gpio_context_t gpioContextA;
	// USB Host configuration context
	usbhost_context_t usbhostContext;
	/* FTDI:EDD */

	/* FTDI:SKI Kernel Initialisation */
	vos_init(50, VOS_TICK_INTERVAL, VOS_NUMBER_DEVICES);
	vos_set_clock_frequency(VOS_48MHZ_CLOCK_FREQUENCY);
	vos_set_idle_thread_tcb_size(512);
	/* FTDI:EKI */

	SetupIOMUX();

	/* FTDI:SDI Driver Initialisation */
	// Initialise GPIO A
	gpioContextA.port_identifier = GPIO_PORT_A;
	gpio_init(VOS_DEV_GPIO_PORT_A,&gpioContextA);







	// Initialise USB Host
	usbhostContext.if_count = 8;
	usbhostContext.ep_count = 16;
	usbhostContext.xfer_count = 2;
	usbhostContext.iso_xfer_count = 2;
	usbhost_init(VOS_DEV_USBHOST_1, VOS_DEV_USBHOST_2, &usbhostContext);
	/* FTDI:EDI */

		// Initialise BOMS Device Driver
	boms_init(VOS_DEV_BOMS_1);

	// Initialise BOMS Device Driver
	boms_init(VOS_DEV_BOMS_2);

	// Initialise FAT File System Driver
	fatdrv_init(VOS_DEV_FAT_FILE_SYSTEM);

	/* FTDI:SCT Thread Creation */
	tcbFIRMWARE = vos_create_thread_ex(20, 4096, firmware, "Application", 0);
	/* FTDI:ECT */

	vos_start_scheduler();

main_loop:
	goto main_loop;
}

/* Code for opening and closing drivers - move to required places in Application Threads */
/* FTDI:SDA Driver Open */
// hUSBHOST_1 = vos_dev_open(VOS_DEV_USBHOST_1);
// hUSBHOST_2 = vos_dev_open(VOS_DEV_USBHOST_2);
// hGPIO_PORT_A = vos_dev_open(VOS_DEV_GPIO_PORT_A);
// hFAT_FILE_SYSTEM = vos_dev_open(VOS_DEV_FAT_FILE_SYSTEM);
// hBOMS_1 = vos_dev_open(VOS_DEV_BOMS_1);
// hBOMS_2 = vos_dev_open(VOS_DEV_BOMS_2);
// hSTDIO = vos_dev_open(VOS_DEV_STDIO);
// hSTDLIB = vos_dev_open(VOS_DEV_STDLIB);
// hSTRING = vos_dev_open(VOS_DEV_STRING);
// hCTYPE = vos_dev_open(VOS_DEV_CTYPE);
// hERRNO = vos_dev_open(VOS_DEV_ERRNO);
/* FTDI:EDA */

/* FTDI:SDB Driver Close */
// vos_dev_close(hUSBHOST_1);
// vos_dev_close(hUSBHOST_2);
// vos_dev_close(hGPIO_PORT_A);
// vos_dev_close(hFAT_FILE_SYSTEM);
// vos_dev_close(hBOMS_1);
// vos_dev_close(hBOMS_2);
// vos_dev_close(hSTDIO);
// vos_dev_close(hSTDLIB);
// vos_dev_close(hSTRING);
// vos_dev_close(hCTYPE);
// vos_dev_close(hERRNO);
/* FTDI:EDB */

unsigned char FatReadSector(unsigned long sec, unsigned char *buffer, unsigned short sl)
{
	// transfer buffer
	static msi_xfer_cb_t xfer;
	unsigned char stat;

	xfer.sector = sec;
	xfer.buf = buffer;
	xfer.total_len = sl;
	xfer.buf_len = sl;
	xfer.status = MSI_NOT_ACCESSED;
	xfer.s = &semRead;
	xfer.do_phases = MSI_PHASE_ALL;
	stat = vos_dev_read(hBOMS_2, (unsigned char *)&xfer, sizeof(msi_xfer_cb_t ), NULL);
	if (stat == MSI_OK)
	{
		stat = FAT_OK;
	}
	else
	{
		stat |= FAT_MSI_ERROR;
	}
	return stat;
}

unsigned char FatWriteSector(unsigned long sec, unsigned char *buffer, unsigned short sl)
{
	// transfer buffer
	static msi_xfer_cb_t xfer;
	unsigned char status;

	xfer.sector = sec;
	xfer.buf = buffer;
	xfer.total_len = sl;
	xfer.buf_len = sl;
	xfer.status = MSI_NOT_ACCESSED;
	xfer.s = &semWrite;
	xfer.do_phases = MSI_PHASE_ALL;
	status = vos_dev_write(hBOMS_1, (unsigned char *)&xfer, sizeof(msi_xfer_cb_t ), NULL);
	if (status == MSI_OK)
	{
		status = FAT_OK;
	}
	else
	{
		status |= FAT_MSI_ERROR;
	}
	return status;
}

/* Application Threads */

void firmware(void)
{
	unsigned short sectorSize2, sectorSize1;
	unsigned char led[5]={0x02, 0x04, 0x08, 0x10, 0x20};
	unsigned char connectstate;
	unsigned char status;
	unsigned short ledStep;

	// USB host variables
	usbhost_device_handle *ifDev;
	usbhost_ioctl_cb_t hc_iocb, be_iocb;
	usbhost_ioctl_cb_class_t hc_iocb_class;
	// BOMS device variables
	msi_ioctl_cb_t boms_iocb;
	boms_ioctl_cb_attach_t boms_att;
	// FAT file system variables
	fat_ioctl_cb_t fat_ioctl;
	fatdrv_ioctl_cb_attach_t fat_att;
	FILE *file;
	// GPIO variables
	gpio_ioctl_cb_t gpio_iocb;
	unsigned char leds;
	msi_xfer_cb_t xfer;
	usbhost_xfer_t uxfer;

	// completion semaphore
	vos_semaphore_t semRead, semWrite;
	unsigned char *pBuffer;
	unsigned long sector=0;
	unsigned short clusterSize;

	short allDone=0;
	int i; //counting variable

	// open host controller
	hUSBHOST_2 = vos_dev_open(VOS_DEV_USBHOST_2);

	// open GPIO device
	hGPIO_PORT_A = vos_dev_open(VOS_DEV_GPIO_PORT_A);

	gpio_iocb.ioctl_code = VOS_IOCTL_GPIO_SET_MASK;
	gpio_iocb.value = 0xff; // set all as output
	vos_dev_ioctl(hGPIO_PORT_A, &gpio_iocb);

	// buffer for reading and writing sectors
	pBuffer = malloc(BUFFER_SIZE);

	do
	{
		//wait for enumeration to complete
		vos_delay_msecs(250);
		leds = led[0];  vos_dev_write(hGPIO_PORT_A,&leds,1,NULL);
		vos_delay_msecs(250);
		leds = 0;  vos_dev_write(hGPIO_PORT_A,&leds,1,NULL);

		// use ioctl to see if bus available
		hc_iocb.ioctl_code = VOS_IOCTL_USBHOST_GET_CONNECT_STATE;
		hc_iocb.get = &connectstate;
		vos_dev_ioctl(hUSBHOST_2, &hc_iocb);

		if (connectstate == PORT_STATE_ENUMERATED)
		{
			leds = led[1];  vos_dev_write(hGPIO_PORT_A,&leds,1,NULL);

			// find and connect a BOMS device

			// USBHost ioctl to find first BOMS device on host
			hc_iocb.ioctl_code = VOS_IOCTL_USBHOST_DEVICE_FIND_HANDLE_BY_CLASS;
			hc_iocb.handle.dif = NULL;
			hc_iocb.set = &hc_iocb_class;
			hc_iocb.get = &ifDev;
			hc_iocb_class.dev_class = USB_CLASS_MASS_STORAGE;
			hc_iocb_class.dev_subclass = USB_SUBCLASS_MASS_STORAGE_SCSI;
			hc_iocb_class.dev_protocol = USB_PROTOCOL_MASS_STORAGE_BOMS;

			if (vos_dev_ioctl(hUSBHOST_2, &hc_iocb) != USBHOST_OK)
			{
				leds = led[3];  vos_dev_write(hGPIO_PORT_A,&leds,1,NULL);
				vos_delay_msecs(1000);
				break;
			}

			// now we have a device, intialise a BOMS driver for it
			hBOMS_2 = vos_dev_open(VOS_DEV_BOMS_2);

			// BOMS ioctl to attach BOMS driver to device on host
			boms_iocb.ioctl_code = MSI_IOCTL_BOMS_ATTACH;
			boms_iocb.set = &boms_att;
			boms_iocb.get = NULL;
			boms_att.hc_handle = hUSBHOST_2;
			boms_att.ifDev = ifDev;

			status = vos_dev_ioctl(hBOMS_2, &boms_iocb);
			if (status != MSI_OK)
			{
				leds = led[3];  vos_dev_write(hGPIO_PORT_A,&leds,1,NULL);
				vos_delay_msecs(1000);
				break;
			}

			boms_iocb.ioctl_code = MSI_IOCTL_GET_SECTOR_SIZE;
			boms_iocb.get = &sectorSize2;
			vos_dev_ioctl(hBOMS_2,&boms_iocb);

			// now connect to the drive to be writtent to in port 1
			hUSBHOST_1 = vos_dev_open(VOS_DEV_USBHOST_1);
			// use ioctl to see if bus available
			hc_iocb.ioctl_code = VOS_IOCTL_USBHOST_GET_CONNECT_STATE;
			hc_iocb.get = &connectstate;

			do
			{
				vos_dev_ioctl(hUSBHOST_1, &hc_iocb);
				vos_delay_msecs(250);
				leds = led[1];  vos_dev_write(hGPIO_PORT_A,&leds,1,NULL);
				vos_delay_msecs(250);
				leds = 0;  vos_dev_write(hGPIO_PORT_A,&leds,1,NULL);
			} while (connectstate!=PORT_STATE_ENUMERATED);

			leds = led[1];  vos_dev_write(hGPIO_PORT_A,&leds,1,NULL);

			// find and connect a BOMS device

			// USBHost ioctl to find first BOMS device on host
			hc_iocb.ioctl_code = VOS_IOCTL_USBHOST_DEVICE_FIND_HANDLE_BY_CLASS;
			hc_iocb.handle.dif = NULL;
			hc_iocb.set = &hc_iocb_class;
			hc_iocb.get = &ifDev;
			hc_iocb_class.dev_class = USB_CLASS_MASS_STORAGE;
			hc_iocb_class.dev_subclass = USB_SUBCLASS_MASS_STORAGE_SCSI;
			hc_iocb_class.dev_protocol = USB_PROTOCOL_MASS_STORAGE_BOMS;

			if (vos_dev_ioctl(hUSBHOST_1, &hc_iocb) != USBHOST_OK)
			{
				leds = led[3];  vos_dev_write(hGPIO_PORT_A,&leds,1,NULL);
				vos_delay_msecs(1000);
				break;
			}

			// now we have a device, intialise a BOMS driver for it
			hBOMS_1 = vos_dev_open(VOS_DEV_BOMS_1);

			// BOMS ioctl to attach BOMS driver to device on host
			boms_iocb.ioctl_code = MSI_IOCTL_BOMS_ATTACH;
			boms_iocb.set = &boms_att;
			boms_iocb.get = NULL;
			boms_att.hc_handle = hUSBHOST_1;
			boms_att.ifDev = ifDev;

			status = vos_dev_ioctl(hBOMS_1, &boms_iocb);
			if (status != MSI_OK)
			{
				leds = led[3];  vos_dev_write(hGPIO_PORT_A,&leds,1,NULL);
				vos_delay_msecs(1000);
				break;
			}

			boms_iocb.ioctl_code = MSI_IOCTL_GET_SECTOR_SIZE;
			boms_iocb.get = &sectorSize1;
			vos_dev_ioctl(hBOMS_1,&boms_iocb);
			clusterSize = BUFFER_SIZE/sectorSize1;

			// time to copy
			vos_init_semaphore(&semRead, 0);
			vos_init_semaphore(&semWrite, 0);
			xfer.sector = sector;
			xfer.buf = pBuffer;
			xfer.total_len = BUFFER_SIZE;
			xfer.buf_len = BUFFER_SIZE;
			xfer.status = MSI_NOT_ACCESSED;
			xfer.s = &semRead;
			xfer.do_phases = MSI_PHASE_ALL;
			do
			{
				// this funny for loop is to speed up processing
				// by eliminating as much as possible from a tight loop
				// while still providing status through LEDs
				for(i=0;i<500;i++)
				{
					status = FatReadSector(sector, pBuffer, BUFFER_SIZE);
					if (status == FAT_OK)
					{
						status = FatWriteSector(sector, pBuffer, BUFFER_SIZE);
					} else
					{
						allDone = 1;
						break;
					}
					sector+=clusterSize;
				}
				ledStep++;
				vos_dev_write(hGPIO_PORT_A, &led[ledStep%5],1,NULL);
			} while((status == FAT_OK)&& !allDone);

			// TO DO: use SCSI command 0x25 to find drive size instead of going till error
			allDone=1;

			boms_iocb.ioctl_code = MSI_IOCTL_BOMS_DETACH;
			if (vos_dev_ioctl(hBOMS_2, &boms_iocb) != MSI_OK)
			{
				leds = led[3];  vos_dev_write(hGPIO_PORT_A,&leds,1,NULL);
				vos_delay_msecs(1000);
				break;
			}
			vos_dev_close(hBOMS_2);

			boms_iocb.ioctl_code = MSI_IOCTL_BOMS_DETACH;
			if (vos_dev_ioctl(hBOMS_1, &boms_iocb) != MSI_OK)
			{
				leds = led[3];  vos_dev_write(hGPIO_PORT_A,&leds,1,NULL);
				vos_delay_msecs(1000);
				break;
			}
			vos_dev_close(hBOMS_1);

			leds = 0;  vos_dev_write(hGPIO_PORT_A,&leds,1,NULL);
			vos_power_down(VOS_WAKE_ON_USB_1); // go to sleep till next time
		}
	} while (!allDone);
}

void storage(void)
{
/*		// Endpoint handles
	usbhost_ep_handle hBulkIn1;
	usbhost_ep_handle hBulkIn2;
	usbhost_ep_handle hBulkOut1;
	usbhost_ep_handle hBulkOut2;

	USB_MSI_CBW cbw; // control block wrapper
	CbReadCapacity cbrc; // control block for read capacity
	DB_READ_CAPACITY dbrc;
			// now get the bulk endpoint handles
			be_iocb.ioctl_code = VOS_IOCTL_USBHOST_DEVICE_GET_BULK_IN_ENDPOINT_HANDLE;
			be_iocb.handle.dif = ifDev;
			be_iocb.get = &hBulkIn2;

			vos_dev_ioctl(hUSBHOST_2, &be_iocb);

			if (hBulkIn2)
			{
				// now lets try for the bulk out
				be_iocb.ioctl_code = VOS_IOCTL_USBHOST_DEVICE_GET_BULK_OUT_ENDPOINT_HANDLE;
				be_iocb.get = &hBulkOut2;
				vos_dev_ioctl(hUSBHOST_2, &be_iocb);
			}

			// request read capacity
			memset(&cbrc, 0, 10);
			cbrc.CB_RC_FIELDS.OperationCode = 0x25;
			InitCbw(&cbw, 1, 8, TRUE, 0, 10, &cbrc);

			vos_init_semaphore(&semRead, 0);
			uxfer.buf = &cbw;
			uxfer.len = sizeof(cbw);
			uxfer.ep = hBulkOut2;
			uxfer.s = &semRead;
			uxfer.cond_code = USBHOST_CC_NOTACCESSED;
			uxfer.flags = USBHOST_XFER_FLAG_START_BULK_ENDPOINT_LIST;
			status = vos_dev_write(hUSBHOST_1, (unsigned char *)&uxfer,
				sizeof(usbhost_xfer_t), NULL);
			//get response
			uxfer.ep = hBulkIn2;
			uxfer.buf = &dbrc;
			uxfer.len = sizeof(dbrc);
			status = vos_dev_read(hUSBHOST_1, (unsigned char *)&uxfer,
				sizeof(usbhost_xfer_t), NULL);
*/

/*					status = vos_dev_read(hBOMS_2, (unsigned char *)&xfer,
						sizeof(msi_xfer_cb_t ), NULL);
					if (status == MSI_OK)
					{
						xfer.s = &semWrite;
						status = vos_dev_write(hBOMS_1, (unsigned char *)&xfer,
						sizeof(msi_xfer_cb_t ), NULL);
						xfer.s = &semRead;
					}
					else
						break;
*/



}

