# Configure CredSSP for PowerShell Remoting and Kerberos Delegation
# Ref: timw.info/shr

# Verify the problem
Enter-PSSession -ComputerName 'vm2'
Invoke-Command -ComputerName 'vm3a' -ScriptBlock { Get-WindowsFeature | Where-Object -FilterScript { $_.InstallState -eq 'Installed' } }

# Command search
Get-Command -Name *credssp* | Select-Object -Property Name, Source

Enable-WSManCredSSP -Role Client -DelegateComputer vm2.timw.info -Force

Get-WSManCredSSP

Invoke-Command -ComputerName vm3a -Scriptblock {Enable-WSManCredSSP -Role Server -Force}

Enter-PSSession -ComputerName vm2.timw.info -Credential timw\tim -Authentication CredSSP

Disable-WSManCredSSP -Role Client

Invoke-Command -ComputerName vm2 -ScriptBlock { Disable-WSManCredSSP -Role Server }