
## From Clip: Demo: CPU Monitoring in Action

Get-Counter '\Processor(_Total)\% Processor Time' -ComputerName SRV1 -Continuous 

Get-Counter '\Processor(_Total)\Processor Queue Length' -ComputerName SRV1 -Continuous
Get-Counter '\Processor(_Total)\% Available Mhz' -ComputerName SRV1 -Continuous

Get-ScheduledTask -ComputerName SRV1

## From Clip: Demo: Techniques for Collecting Server Performance Metrics 

Get-Counter '\Processor(*)\% Processor Time'

Get-Counter '\Memory\Available Mbytes' 

Get-Counter '\LogicalDisk(*)\Avg. Disk sec/Read'
Get-Counter '\LogicalDisk(*)\Avg. Disk sec/Write'  

Get-Counter '\Network Interface(*)\Bytes Total/sec'

## From Clip: Demo: Monitoring File System Activity with WMI Events

$monitoredDirectory = "C:\CriticalDirectory"
$logFilePath = "C:\FileSystemChangeLog.txt"

# Create a FileSystemWatcher object
$watcher = New-Object System.IO.FileSystemWatcher
$watcher.Path = $monitoredDirectory
$watcher.IncludeSubdirectories = $false
$watcher.EnableRaisingEvents = $true

# Define actions for different event types
$action = {
  param($source, $e)

  # Format the log entry
  $changeType = $e.ChangeType.ToString()
  $logEntry = "$(Get-Date): File `"$($e.FullPath)`" was $changeType."

  # Append the log entry to the log file
  Add-Content -Path $logFilePath -Value $logEntry
}

# Subscribe to events with a specific source identifier
Register-ObjectEvent -InputObject $watcher -EventName Created -SourceIdentifier FileCreated -Action $action
Register-ObjectEvent -InputObject $watcher -EventName Deleted -SourceIdentifier FileDeleted -Action $action

## From Clip: Demo: Investigating IIS App Crashes

Get-WinEvent -LogName 'System' | Select-Object -First 5

Get-WinEvent -LogName 'Microsoft-Windows-IIS-Configuration/Operational' | Select-Object -First 5

Get-WinEvent -LogName 'Microsoft-Windows-IIS-Configuration/Operational' -Level 1,2 | Select-Object -First 5

Get-WinEvent -ProviderName 'Microsoft-Windows-IIS-Configuration' | Select-Object -First 5

Get-WinEvent -LogName 'Microsoft-Windows-IIS-Configuration/Operational' -Level 2 -ProviderName 'Microsoft-Windows-IIS-Configuration' | Select-Object -First 5

Get-WinEvent -FilterHashtable @{LogName='Microsoft-Windows-IIS-Configuration/Operational'; Level=1,2; ProviderName='Microsoft-Windows-IIS-Configuration'} | Select-Object -First 5

## From Clip: Demo: Auditing Failed Logons

Get-WinEvent -FilterHashtable @{LogName='Security';ID=529} | Select-Object -First 10

# Create hash table to filter security log
$filter = @{
  LogName='Security'
  ID=529
  ProviderName='Microsoft-Windows-Security-Auditing'
  Data=@{Key='TargetUserName';Value='TestUser'}
}

# Retrieve failed logins for 'TestUser'  
Get-WinEvent -FilterHashtable $filter

Set-ADAccountLockoutPolicy -LockoutThreshold 10 -LockoutDuration 00:30:00

Get-ADAccountLockoutPolicy

## From Clip: Demo: Troubleshooting Failed Updates

Get-WindowsUpdateHistory | Where-Object {$_.Result -ne 'Succeeded'}

Get-Service -Name wuauserv

Start-Service -Name wuauserv

Reset-WindowsUpdate

Get-Service -Name wuauserv

Get-WindowsUpdate

Install-WindowsUpdate -KBArticleID KB123456

Get-WindowsUpdateHistory | Where-Object {$_.KB -eq 'KB123456'}