clc  % Clear Command Window
clear %Remove items from workspace, freeing up system memory
close all % Remove specified figure

ts=0.1; % sample time
t=0:ts:50; % vector time

%%%%%%%%%%%%%%%%%%% Initial conditions %%%%%%%%%%%%%%%%%%%%%

x1(1) = 0;  % initial center position (x axis) in meters (m)
y1(1) = 1;  % initial center position (y axis) in meters (m)
z1(1) = 2;  % initial center position (y axis) in meters (m)

phi(1)=0; % initial orientation in radians
q1(1)=pi/20; % initial angular position q2 in radians
q2(1)=0; % initial angular position q3 in radians

a=0.1; % distance to interest point in meters (m)
c=0.25; % height of arm base 
l1=0.5; % length of first joint
l2=0.55; % length of second joint

% Geometric model

% aerial robot
x(1)=x1(1)+a*cos(phi(1));
y(1)=y1(1)+a*sin(phi(1));
z(1)=z1(1);

% arm 
hx(1)=x(1)+l1*cos(q1(1))*cos(phi(1))+l2*cos(q1(1)+q2(1))*cos(phi(1));   % initial interest position (x axis) in meters (m)
hy(1)=y(1)+l1*cos(q1(1))*sin(phi(1))+l2*cos(q1(1)+q2(1))*sin(phi(1));   % initial interest position (y axis) in meters (m)
hz(1)=z(1)-c+l1*sin(q1(1))+l2*sin(q1(1)+q2(1)); % initial interest position (z axis) in meters (m)


%%%%%%%%%%%%%%%%%%%%% movement of the ROBOT %%%%%%%%%%%%%%%%%%%
scene=figure;  % new figure
tam=get(0,'ScreenSize');
set(scene,'position',[tam(1) tam(2) tam(3) tam(4)]); % position and size figure in the screen
axis equal; % Set axis aspect ratios
axis([-2 2 -2 2 -1 3]); % Set axis limits 
view([-14 21]); % orientation figure
grid on; % Display axes grid lines


M1=Plot_Drone(x1(1),y1(1),z1(1),0,0,phi(1),1.2); % Plot robot in initial position x1,y1 and phi orientation
hold on;
xlabel('x(m)'); ylabel('y(m)'); zlabel('z(m)'); % Label axis


M2=plot3(hx(1),hy(1),hz(1),'gO','LineWidth',2); % Initial point.
M3=plot3(hx(1),hy(1),hz(1),'b','LineWidth',2); % Initial trajectory.

Arm_Parameters(1); % Parameters of arm robot
M5=Arm_Plot3D(x(1),y(1),z(1),pi,0,phi(1),q1(1),q2(1),0);% Plot robot in initial position hx,hy and phi orientation


