clear
close all
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% TIEMPO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tf = 10;             % Tiempo de simulacion en segundos (s)
ts = 0.1;            % Tiempo de muestreo en segundos (s)
t = 0: ts: tf;       % Vector de tiempo
N = length(t);       % Muestras

%%%%%%%%%%%%%%%%%%%%%%%% PARAMETROS DEL ROBOT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
l1=1.05; % longitud del eslabon en metros (m)
b=0.25;  % altura de la base del manipulador en metros (m)

%%%%%%%%%%%%%%%%%%%%%%%% CONDICIONES INICIALES %%%%%%%%%%%%%%%%%%%%%%%%%%%%
q1 = zeros(1, N+1); % Posicin angular de la base del manipulador
q2 = zeros(1, N+1); % Posicin angular del eslabn del manipulador

q1(1) =  10*(pi/180);  % Posicin angular inicial q1           
q2(1) =  0*(pi/180);   % Posicin angular inicial q2              


%%%%%%%%%%%%%%%%%%%%%%%%%%%% PUNTO DE CONTROL %%%%%%%%%%%%%%%%%%%%%%%%%%%%
hx = zeros(1, N+1);  % Posicion en el punto de control (eje x) en metros (m)
hy = zeros(1, N+1);  % Posicion en el punto de control (eje y) en metros (m)
hz = zeros(1, N+1);  % Posicion en el punto de control (eje z) en metros (m)

hx(1)=l1*cos(q2(1))*cos(q1(1));
hy(1)=l1*cos(q2(1))*sin(q1(1));
hz(1)=b+l1*sin(q2(1));

%%%%%%%%%%%%%%%%%%%%%% VELOCIDADES DE REFERENCIA %%%%%%%%%%%%%%%%%%%%%%%%%%
q1p = 0.8*sin(0.9*t);  % Velocidad angular de la base del manipulador (rad/s)         
q2p = 0.3*cos(0.9*t)+0.1; % Velocidad angular del eslabn del manipulador (rad/s)

%%%%%%%%%%%%%%%%%%%%%%%%% BUCLE DE SIMULACION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for k=1:length(t)

    q1(k+1)=q1(k)+ts*q1p(k);
    q2(k+1)=q2(k)+ts*q2p(k);
    
    hx(k+1)=l1*cos(q2(k+1))*cos(q1(k+1));
    hy(k+1)=l1*cos(q2(k+1))*sin(q1(k+1));
    hz(k+1)=b+l1*sin(q2(k+1));

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% SIMULACION VIRTUAL 3D %%%%%%%%%%%%%%%%%%%%%%%%%%%%

% a) Configuracion de escena

scene=figure;  % Crear figura (Escena)
set(scene,'Color','white'); % Color del fondo de la escena
set(gca,'FontWeight','bold') ;% Negrilla en los ejes y etiquetas
sizeScreen=get(0,'ScreenSize'); % Retorna el tamao de la pantalla del computador
set(scene,'position',sizeScreen); % Congigurar tamao de la figura
axis equal; % Establece la relacin de aspecto para que las unidades de datos sean las mismas en todas las direcciones.
grid on; % Mostrar lneas de cuadrcula en los ejes
box on; % Mostrar contorno de ejes
xlabel('x(m)'); ylabel('y(m)'); zlabel('z(m)'); % Etiqueta de los eje

view([-15 25]); % Orientacion de la figura
axis([-2 2 -2 2 0 2]); % Ingresar limites minimos y maximos en los ejes x y z [minX maxX minY maxY minZ maxZ]

% b) Graficar robots en la posicion inicial
Arm_Parameters; 
H1=Arm_Plot3D(0,0,0,0,0,q1(1),q2(1),0,0); hold on; 

% c) Graficar Trayectorias
H2=plot3(hx(1),hy(1),hz(1),'r','LineWidth',2);

% d) Bucle de simulacion de movimiento del robot

step=1; % pasos para simulacion

for k=1:step:length(t) 
    
    delete (H1)
    delete (H2)
    H1=Arm_Plot3D(0,0,0,0,0,q1(k),q2(k),0,0);
    H2=plot3(hx(1:k),hy(1:k),hz(1:k),'b','LineWidth',2);
    
    pause(ts)
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Graficas %%%%%%%%%%%%%%%%%%%%%%%%%%%%
graph=figure;  % Crear figura (Escena)
set(graph,'position',sizeScreen); % Congigurar tamao de la figura
subplot(211)
plot(t,q1p,'b','LineWidth',2),grid('on'),xlabel('Tiempo [s]'),ylabel('[rad/s]'),legend('q1p');
subplot(212)
plot(t,q2p,'r','LineWidth',2),grid('on'),xlabel('Tiempo [s]'),ylabel('[rad/s]'),legend('q2p');

