clear
close all
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% TIEMPO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tf = 40;             % Tiempo de simulacion en segundos (s)
ts = 0.1;            % Tiempo de muestreo en segundos (s)
t = 0: ts: tf;       % Vector de tiempo
N = length(t);       % Muestras


%%%%%%%%%%%%%%%%%%%%%%%% PARAMETROS DEL ROBOT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
D=0.75;

%%%%%%%%%%%%%%%%%%%%%%%% CONDICIONES INICIALES %%%%%%%%%%%%%%%%%%%%%%%%%%%%

x2 = zeros(1, N+1);  % Posicion en el centro del robot (eje x) en metros (m)
y2 = zeros(1, N+1);  % Posicion en el centro del robot (eje y) en metros (m)
phi = zeros(1, N+1); % Orientacion del robot en radianes (rad)
% psi = zeros(1, N+1);

x2(1)=0;  % Posicion inicial eje x
y2(1)=0;  % Posicion inicial eje y
phi(1)=0; % Orientacion inicial del robot
% psi(1)= 0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%% PUNTO DE CONTROL %%%%%%%%%%%%%%%%%%%%%%%%%%%%

hx = zeros(1, N+1);  % Posicion en el punto de control (eje x) en metros (m)
hy = zeros(1, N+1);  % Posicion en el punto de control (eje y) en metros (m)

hx(1) = x2(1)+D*cos(phi(1)); % Posicion en el punto de control del robot en el eje x
hy(1) = y2(1)+D*sin(phi(1)); % Posicion en el punto de control del robot en el eje y

%%%%%%%%%%%%%%%%%%%%%% VELOCIDADES DE REFERENCIA %%%%%%%%%%%%%%%%%%%%%%%%%%

u=0.1*ones(1,length(t));
% wsi=(15*(pi/180))*sin(0.01*t);
psi=0.4*cos(0.2*t);


for k=1:length(t)

    %%%%%%%%%%%%%%%%%%%%% MODELO CINEMATICO %%%%%%%%%%%%%%%%%%%%%%%%%
    hxp = u(k)*cos(phi(k))-u(k)*tan(psi(k))*sin(phi(k));
    hyp = u(k)*sin(phi(k))+u(k)*tan(psi(k))*cos(phi(k));
    phip = (1/D)*u(k)*tan(psi(k));
%     psip(k)=wsi(k);

    % Integral numrica (mtodo de Euler)
    hx(k+1)=hx(k)+ts*hxp;
    hy(k+1)=hy(k)+ts*hyp;
    phi(k+1)=phi(k)+ts*phip;
%     psi(k+1)=psi(k)+ts*psip(k);

    % Posicion del robot con respecto al punto de control
    
    x2(k+1)=hx(k+1)-D*cos(phi(k+1));  
    y2(k+1)=hy(k+1)-D*sin(phi(k+1));  


end

scene=figure;  % new figure
tam=get(0,'ScreenSize');
set(scene,'position',[tam(1) tam(2) tam(3) tam(4)]); % position and size figure in the screen

axis equal; % Set axis aspect ratios
axis([0 6 -1 1 -0.1 1]); % Set axis limits 
grid on; % Display axes grid lines
MobileCarlike; % Parameters of robot
M1=CarlikePlot(x2(1),y2(1),phi(1),psi(1)); % Plot robot in initial position hx,hy and phi orientation
hold on; % Retain current plot when adding new plot
M2=plot(hx(1),hy(2),'r'); % plot trayectory.
xlabel('x(m)'); ylabel('y(m)'); zlabel('z(m)'); % Label axis
camlight('rigth');
% 
step=10; % position step

for i=1:step:length(t) % Loop emulation
    delete (M1)
    delete (M2)
    M1=CarlikePlot(x2(i),y2(i),phi(i),psi(i)); hold on
    plot(hx(1:i),hy(1:i),'b','LineWidth',2); % plot trayectory.
    pause(ts)
end


