function  graphRobot=robotPlot(x,y,z,phi,scaleRobot)
global Robot;
robotParameters; 

%Matrix Rotation z axis
Rz=[cos(phi), -sin(phi) 0; sin(phi) cos(phi) 0; 0 0 1]; %Matrix Rotation z axis


robotPatch = Rz*Robot.baseVertices;
robotPatch(1,:)=robotPatch(1,:)*scaleRobot+x; 
robotPatch(2,:)=robotPatch(2,:)*scaleRobot+y;
robotPatch(3,:)=robotPatch(3,:)*scaleRobot+z;

graphRobot(1) = patch('Faces',Robot.baseFaces,'Vertices',robotPatch','FaceColor',[0,0,0.7],'EdgeColor','none');

robotPatch = Rz*Robot.wheelVertices;
robotPatch(1,:)=robotPatch(1,:)*scaleRobot+x; 
robotPatch(2,:)=robotPatch(2,:)*scaleRobot+y;
robotPatch(3,:)=robotPatch(3,:)*scaleRobot+z;

graphRobot(2) = patch('Faces',Robot.wheelFaces,'Vertices',robotPatch','FaceColor','k','EdgeColor','none');

robotPatch = Rz*Robot.motorVertices;
robotPatch(1,:)=robotPatch(1,:)*scaleRobot+x; 
robotPatch(2,:)=robotPatch(2,:)*scaleRobot+y;
robotPatch(3,:)=robotPatch(3,:)*scaleRobot+z;

graphRobot(3) = patch('Faces',Robot.motorFaces,'Vertices',robotPatch','FaceColor',[0.3,0.3,0.3],'EdgeColor','none');

robotPatch = Rz*Robot.hoppsVertices;
robotPatch(1,:)=robotPatch(1,:)*scaleRobot+x; 
robotPatch(2,:)=robotPatch(2,:)*scaleRobot+y;
robotPatch(3,:)=robotPatch(3,:)*scaleRobot+z;

graphRobot(4) = patch('Faces',Robot.hoppsFaces,'Vertices',robotPatch','FaceColor','y','EdgeColor','none');

robotPatch = Rz*Robot.castorVertices;
robotPatch(1,:)=robotPatch(1,:)*scaleRobot+x; 
robotPatch(2,:)=robotPatch(2,:)*scaleRobot+y;
robotPatch(3,:)=robotPatch(3,:)*scaleRobot+z;

graphRobot(5) = patch('Faces',Robot.castorFaces,'Vertices',robotPatch','FaceColor','k','EdgeColor','none');



