clear
close all
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% TIEMPO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tf = 40;             % Tiempo de simulacion en segundos (s)
ts = 0.1;            % Tiempo de muestreo en segundos (s)
t = 0: ts: tf;       % Vector de tiempo
N = length(t);       % Muestras


%%%%%%%%%%%%%%%%%%%%%%%% PARAMETROS DEL ROBOT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
D=0.5;
R=0.1;

%%%%%%%%%%%%%%%%%%%%%%%% CONDICIONES INICIALES %%%%%%%%%%%%%%%%%%%%%%%%%%%%

x1 = zeros(1, N+1);  % Posicion en el centro del robot (eje x) en metros (m)
y1 = zeros(1, N+1);  % Posicion en el centro del robot (eje y) en metros (m)
phi = zeros(1, N+1); % Orientacion del robot en radianes (rad)
psi = zeros(1, N+1); % Orientacion del robot en radianes (rad)

x1(1)=0;  % Posicion inicial eje x
y1(1)=0;  % Posicion inicial eje y
phi(1)=0; % Orientacion inicial del robot
psi(1)=-pi/6;

%%%%%%%%%%%%%%%%%%%%%%%%%%%% PUNTO DE CONTROL %%%%%%%%%%%%%%%%%%%%%%%%%%%%

hx = zeros(1, N+1);  % Posicion en el punto de control (eje x) en metros (m)
hy = zeros(1, N+1);  % Posicion en el punto de control (eje y) en metros (m)

hx(1) = x1(1); % Posicion en el punto de control del robot en el eje x
hy(1) = y1(1); % Posicion en el punto de control del robot en el eje y

%%%%%%%%%%%%%%%%%%%%%% VELOCIDADES DE REFERENCIA %%%%%%%%%%%%%%%%%%%%%%%%%%

thethap=0.5*ones(1,length(t));
wpsi=0.1*sin(0.1*t);

%%%%%%%%%%%%%%%%%%%%%%%%% BUCLE DE SIMULACION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for k=1:N

   
    %%%%%%%%%%%%%%%%%%%%% MODELO CINEMATICO %%%%%%%%%%%%%%%%%%%%%%%%%
    x1p = R*thethap(k)*cos(psi(k))*cos(phi(k));
    y1p = R*thethap(k)*cos(psi(k))*sin(phi(k));
    phip = (1/D)*R*thethap(k)*sin(psi(k));
    psip = wpsi(k);
    
    % Integral numrica (mtodo de Euler)
    x1(k+1)=x1(k)+ts*x1p;
    y1(k+1)=y1(k)+ts*y1p;
    phi(k+1)=phi(k)+ts*phip;
    psi(k+1)=psi(k)+ts*psip;
    
    % Posicion del robot con respecto al punto de control
    hx(k+1)=x1(k+1); 
    hy(k+1)=y1(k+1);
    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% SIMULACION VIRTUAL 3D %%%%%%%%%%%%%%%%%%%%%%%%%%%%

% a) Configuracion de escena

scene=figure;  % Crear figura (Escena)
set(scene,'Color','white'); % Color del fondo de la escena
set(gca,'FontWeight','bold') ;% Negrilla en los ejes y etiquetas
sizeScreen=get(0,'ScreenSize'); % Retorna el tamao de la pantalla del computador
set(scene,'position',sizeScreen); % Congigurar tamao de la figura
camlight('headlight'); % Luz para la escena
axis equal; % Establece la relacin de aspecto para que las unidades de datos sean las mismas en todas las direcciones.
grid on; % Mostrar lneas de cuadrcula en los ejes
box on; % Mostrar contorno de ejes
xlabel('x(m)'); ylabel('y(m)'); zlabel('z(m)'); % Etiqueta de los eje

view([-40 30]); % Orientacion de la figura
axis([0 2 -1 1 0 0.5]); % Ingresar limites minimos y maximos en los ejes x y z [minX maxX minY maxY minZ maxZ]

hold on;
% b) Graficar Trayectorias
H1=plot3(hx(1),hy(1),0,'r','lineWidth',2);

step=10; % pasos para simulacion

for k=1:step:N


    delete(H1);

    H1=plot3(hx(1:k),hy(1:k),zeros(1,k),'r','lineWidth',2);
    
    pause(ts);

end


