clc  % Clear Command Window
clear  %Remove items from workspace, freeing up system memory
close all % Remove specified figure

%%%%%%%%%%%%%%%%%%% Only position %%%%%%%%%%%%%%%%%%%
%%
% Position and orientation robot
b=0.25;
l1=0.5;
l2=0.4;
l3=0.15;

q0(1) =  0*(pi/180);  
q1(1) =  0*(pi/180);             
q2(1) =  0*(pi/180);    
q3(1) =  0*(pi/180);  

fig=figure; % new figure
set(fig,'position',[10 60 980 600]); % position window 
axis equal; % Set axis aspect ratios
axis([-1.5 1.5 -1.5 1.5 -.5 1.2]); % Set axis limits 
grid on; % Display axes grid lines


Arm_Parameters; % Parameters of robot
M1=Arm_Plot3D(0,0,0,90*(pi/180),0,q0(1),q1(1),q2(1),q3(1)); % Plot robot in position hx,hy and phi orientation
xlabel('x(m)'); ylabel('y(m)'); zlabel('z(m)'); % Label axis

%%%%%%%%%%%%%%%%%%% vector position %%%%%%%%%%%%%%%%%%%
%%

ts=0.1; %sample time
tf=10; % final time
t=0:ts:tf; % vector time

% Position and orientation robot
b=0.25;
l1=0.5;
l2=0.4;
l3=0.15;

q0 =  10*(pi/180)*t;  
q1 =  5*(pi/180)*t;             
q2 =  -5*(pi/180)*t;    
q3 =  0*(pi/180)*t;  


fig=figure; % new figure
set(fig,'position',[10 60 980 600]); % position window 
axis equal; % Set axis aspect ratios
axis([-1 2 -1 2 0 1.2]); % Set axis limits 
grid on; % Display axes grid lines

Arm_Parameters; % Parameters of robot
M1=Arm_Plot3D(0,0,0,0,0,q0(1),q1(1),q2(1),q3(1));hold on;% Plot robot in initial position hx,hy and phi orientation
xlabel('x(m)'); ylabel('y(m)'); zlabel('z(m)'); % Label axis


step=5;

for i=1:step:length(t) % Loop emulation
    
    delete (M1)
    M1=Arm_Plot3D(0,0,0,0,0,q0(i),q1(i),q2(i),q3(i));  hold on
    
    pause(ts)
end

