clc  % Clear Command Window
clear %Remove items from workspace, freeing up system memory
close all % Remove specified figure

ts=0.1; % sample time
t=0:ts:20; % vector time

l1=1.05;
b=0.25;

% initial condition in rad

q1(1) =  10*(pi/180);             
q2(1) =  0*(pi/180);             


% initial condition of griper
hx(1)=l1*cos(q2(1))*cos(q1(1));
hy(1)=l1*cos(q2(1))*sin(q1(1));
hz(1)=b+l1*sin(q2(1));

% angular velocities
q1p = 0.01*sin(0.9*t);             
q2 = 0.1*t;

for k=1:length(t)

    q1(k+1)=q1(k)+q1p(k);
    %q2(k+1)=q2(k)+q2p(k);
    
    hx(k+1)=l1*cos(q2(k))*cos(q1(k+1));
    hy(k+1)=l1*cos(q2(k))*sin(q1(k+1));
    hz(k+1)=b+l1*sin(q2(k));

end

scene=figure;  % new figure
tam=get(0,'ScreenSize');
set(scene,'position',[tam(1) tam(2) tam(3) tam(4)]); % position and size figure in the screen
axis equal; % Set axis aspect ratios
axis([-2 2 -2 2 0 1.4]); % Set axis limits 
grid on; % Display axes grid lines

Arm_Parameters; % Parameters of robot
M1=Arm_Plot3D(0,0,0,0,0,q1(1),q2(1),0,0); hold on; % Plot robot in initial position hx,hy and phi orientation
hold on; % Retain current plot when adding new plot
M2=plot3(hx(1),hy(1),hz(1),'r'); % plot trayectory.
xlabel('x(m)'); ylabel('y(m)'); zlabel('z(m)'); % Label axis

step=20; % position step

for i=1:step:length(t) % Loop emulation
    
    delete (M1)
    delete (M2)
    M1=Arm_Plot3D(0,0,0,0,0,q1(i),q2(i),0,0);
    hold on;
    M2=plot3(hx(1:i),hy(1:i),hz(1:i),'b','LineWidth',2);
    
    pause(ts)
end



