clc  % Clear Command Window
clear  %Remove items from workspace, freeing up system memory
close all % Remove specified figure

ts=0.1; % sample time
t=0:ts:20; % vector time

% initial point control of robot
x1(1)=0;
y1(1)=0;
z1(1)=0;
phi(1)=0;

a=0.2;

hx(1)=x1(1)+a*cos(phi(1));
hy(1)=y1(1)-a*sin(phi(1));
hz(1)=z1(1);


% Velocities
uf=0*ones(1,length(t));
ul=0*ones(1,length(t));
uz=0.1*ones(1,length(t));
w=0.01*ones(1,length(t));

for k=1:length(t)

    % Kinematic Model
    hxp(k)=uf(k)*cos(phi(k))-ul(k)*sin(phi(k));
    hyp(k)=uf(k)*sin(phi(k))+ul(k)*cos(phi(k));
    hzp(k)=uz(k);
    phip(k)=w(k);
    
     %numerical integral (Euler Method)
    hx(k+1)=hx(k)+ts*hxp(k);
    hy(k+1)=hy(k)+ts*hyp(k);
    hz(k+1)=hz(k)+ts*hzp(k);
    phi(k+1)=phi(k)+phip(k);
    
    x1(k+1)=hx(k+1)-a*cos(phi(1));
    y1(k+1)=hy(k+1)+a*sin(phi(1));
    z1(k+1)=hz(k+1);
end

scene=figure;  % new figure
tam=get(0,'ScreenSize');
set(scene,'position',[tam(1) tam(2) tam(3) tam(4)]); % position and size figure in the screen
axis equal; % Set axis aspect ratios
axis([-2 2 -2 2 0 3]); % Set axis limits 
grid on; % Display axes grid lines


M1=Plot_Drone(x1(1),y1(1),z1(1),0,0,phi(1),1); hold on; % Plot robot in initial position hx,hy and phi orientation
hold on; % Retain current plot when adding new plot
M2=plot3(hx(1),hy(1),hz(1),'r'); % plot trayectory.
xlabel('x(m)'); ylabel('y(m)'); zlabel('z(m)'); % Label axis

step=10; % position step

for i=1:step:length(t) % Loop emulation
    
    delete (M1)
    delete (M2)
    M1=Plot_Drone(x1(i),y1(i),z1(i),0,0,phi(i),1); hold on;
    M2=plot3(hx(1:i),hy(1:i),hz(1:i),'b','LineWidth',2);
    
    pause(ts)
end



