clear
close all
clc
warning off

% Tiempo de simulacin 
tf=10;
ts=0.1; % tiempo de muestreo 
t=0:ts:tf;

Q=length(t);

COM='COM5';
delete(instrfind({'Port'},{COM}));

PS=serial(COM);

set(PS,'Baudrate',9600); % se configura la velocidad a 9600 Baudios
set(PS,'StopBits',1); % se configura bit de parada a uno
set(PS,'DataBits',8); % se configura que el dato es de 8 bits
set(PS,'Parity','none'); % se configura sin paridad
set(PS,'Terminator','CR/LF');% c caracter con que finaliza el envo 
set(PS,'OutputBufferSize',30); % n es el nmero de bytes a enviar
set(PS,'InputBufferSize' ,30); % n es el nmero de bytes a recibir
set(PS,'Timeout',2); % 2 segundos de tiempo de espera


rpmRef=90*cos(0.2*t); 
rpmRef1=90*sin(0.2*t); 
rpmRef2=9*t; 

rpmMeas=zeros(1,Q);
rpmMeas1=zeros(1,Q);
rpmMeas2=zeros(1,Q);

tiempo=zeros(1,Q);

fopen(PS);

pause(3);

disp('Recibiendo Datos..');

for k=1:Q
tic  
trama=[num2str(round(rpmRef(k))) ',' num2str(round(rpmRef1(k))) ',' num2str(round(rpmRef2(k)))]; % trama para envio de datos
fprintf(PS,'%s\n',trama,'sync');

rpmMeas(k) = fscanf(PS, '%d\n');
rpmMeas1(k) = fscanf(PS, '%d\n');
rpmMeas2(k) = fscanf(PS, '%d\n');

tiempo(k)=toc;

while toc<ts
end
end
disp('Fin..');

fprintf(PS,'%s\n','0,0,0','sync');
%%
fclose(PS); 
delete(PS);
%%
figure
subplot(311)
plot(t,rpmMeas,'b','LineWidth',2),hold on, plot(t,rpmRef,'r','LineWidth',2),legend('Medida','Referencia')
subplot(312)
plot(t,rpmMeas1,'b','LineWidth',2),hold on, plot(t,rpmRef1,'r','LineWidth',2),legend('Medida','Referencia')
subplot(313)
plot(t,rpmMeas2,'b','LineWidth',2),hold on, plot(t,rpmRef2,'r','LineWidth',2),legend('Medida','Referencia')
figure
plot(tiempo)

