/*
 * Decompiled with CFR 0.152.
 */
package com.pluralsight.protectivetechnology.auditlogger.controller;

import com.pluralsight.protectivetechnology.auditlogger.dto.Resource;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ResourceController {
    private static final Logger log = LoggerFactory.getLogger(ResourceController.class);

    @PostMapping(value={"/resources"})
    public ResponseEntity createResource(@RequestBody Resource resource, HttpServletRequest request) {
        String authentication = request.getHeader("authorization").substring("Basic".length()).trim();
        String decodedAuthentication = new String(Base64.getDecoder().decode(authentication));
        String user = decodedAuthentication.split(":")[0];
        String remoteAddress = request.getRemoteAddr();
        log.info("{}@{},{},create,{}", new Object[]{user, remoteAddress, resource.getResourceType(), resource.getName()});
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }
}

