  ;gui-keygen-template.asm
  ; -------------------------------------------------------------------------------------

 format PE GUI 4.0
 entry start

 include 'win32a.inc'

; -------------------------------------------------------------------------------------
 ; Maximum size of input string we are willing to take:
 MAX_INPUT_SIZE = 4
 ID_KEYGEN_DIALOG = 102
 ID_NAME = 1000
 ID_OUTPUT = 1004
 ID_BTN = 1005
 IDR_ICON = 17
; -------------------------------------------------------------------------------------

section '.data' data readable writeable
  szInitText    db '',0
  string_format db  '%s-%d-%d-%d',0

; -------------------------------------------------------------------------------------
section '.bss' readable writeable
    input_str       db  MAX_INPUT_SIZE + 1 dup (?)
    ; Note: + 1 to leave room for the zero terminator.

    ; A structure to hold the system time.
    systime     SYSTEMTIME  ?
    serial_key      db   128  dup(?)

; -------------------------------------------------------------------------------------
section '.code' code readable executable

  start:
    invoke GetModuleHandle,0
    invoke DialogBoxParam,eax,ID_KEYGEN_DIALOG,0,DialogProc,0

  exit:
    invoke  ExitProcess,0 

; -------------------------------------------------------------------------------------

proc DialogProc uses esi edi ebx,hwnddlg,msg,wparam,lparam

  cmp [msg],WM_INITDIALOG
  je .wminitdialog

  cmp [msg],WM_COMMAND
  je .wmcommand

  cmp [msg],WM_CLOSE
  je .wmclose

  xor eax,eax
  jmp .quit

  .wminitdialog:
    invoke SetDlgItemText,[hwnddlg],ID_NAME,szInitText
    invoke SetDlgItemText,[hwnddlg],ID_OUTPUT,szInitText
    jmp .done

  .wmcommand:
    cmp [wparam], BN_CLICKED shl 16 + ID_BTN
    je .generateKey
    jmp .done

  .generateKey:
    ; Get the system time into the systime structure:
    push    systime             ; lpSystemTime
    call    [GetLocalTime]

    invoke GetDlgItemText,[hwnddlg],ID_NAME,input_str,MAX_INPUT_SIZE + 1

    ; --- Replace below code with yours ---
    movzx   eax, word[systime.wYear]
    movzx   ebx, word [systime.wMonth]
    movzx   ecx, word [systime.wDay]
    ; --- end Replace ---

    ; print out serial key
    push ecx
    push ebx
    push eax
    push input_str
    push string_format
    push serial_key
    call [sprintf]
    add esp, 4*6 ;4 bytes x65 pushes - to clean the stack

    invoke SetDlgItemText,[hwnddlg],ID_OUTPUT,serial_key
    jmp .done

  .wmclose:
    invoke EndDialog,[hwnddlg],0

  .done:
    mov eax,1

  .quit:
  ret       

endp

; -------------------------------------------------------------------------------------

section '.idata' import data readable writeable

  library kernel,'KERNEL32.DLL',\
          user,'USER32.DLL',\
          msvcrt,'msvcrt.dll'

  import kernel,\
         GetModuleHandle,'GetModuleHandleA',\
         ExitProcess,'ExitProcess',\
         GetLocalTime,'GetLocalTime'

  import user,\
         DialogBoxParam,'DialogBoxParamA',\ 
         SetDlgItemText,'SetDlgItemTextA',\
         EndDialog,'EndDialog',\
         GetDlgItemText, 'GetDlgItemTextA'

  import  msvcrt,\
        sprintf,'sprintf'
; -------------------------------------------------------------------------------------

section '.rc' resource data readable
  directory RT_DIALOG,dialogs, \
            RT_ICON,icons,\
            RT_GROUP_ICON,group_icons

  resource icons,\
           1,LANG_NEUTRAL,icon_data

  resource group_icons,\
           IDR_ICON,LANG_NEUTRAL,main_icon

  icon main_icon,icon_data,'key.ico'

  resource dialogs,ID_KEYGEN_DIALOG,LANG_ENGLISH+SUBLANG_DEFAULT,mod_exp_dialog

  dialog mod_exp_dialog,\
  'GUI Keygen by CrackingLessons.com',0,0,160,130,\
  DS_MODALFRAME+WS_MINIMIZEBOX+WS_POPUP+WS_VISIBLE+WS_CAPTION+WS_SYSMENU,\
  0,0,"Lucida Console",11

  dialogitem 'BUTTON','Enter Name',-1,7,10,145,60,BS_GROUPBOX+WS_VISIBLE,0
  dialogitem 'BUTTON',"Output",-1,7,80,145,30,BS_GROUPBOX+WS_VISIBLE,0


  dialogitem 'EDIT',0,ID_NAME,20,20,120,14,WS_BORDER+WS_VISIBLE,0
  dialogitem 'BUTTON',"Generate",ID_BTN,40,45,80,14,BS_PUSHBUTTON+WS_VISIBLE,0
  dialogitem 'EDIT',0,ID_OUTPUT,20,90,120,14,WS_BORDER+WS_VISIBLE,0

  enddialog

; -------------------------------------------------------------------------------------