"use strict";

const { ServiceBroker } = require("moleculer");
const path = require("path");

const broker = new ServiceBroker({
    logger: true,
    logLevel: "debug",
    validator: {
        enabled: true,
        debug: true
    },
    errorHandler(err, info) {
        this.logger.error("Error details:", {
            error: err.message,
            code: err.code,
            type: err.type,
            data: err.data,
            params: info.params,
            action: info.action,
            nodeID: info.nodeID
        });
        return err;
    }
});

broker.loadServices(path.join(__dirname, "services"));
broker.start()
    .then(() => {
        broker.logger.info("Server is running on http://localhost:3000/api");
        broker.logger.info("See dev.md for API documentation and examples");
    })
    .catch(err => {
        broker.logger.error("Error occurred during broker start:", err);
        process.exit(1);
    });
