const express = require('express');
const bcrypt = require('bcrypt');
const router = express.Router();

router.get('/register', (req, res) => {
    res.render('auth/register', { error: null });
});

router.post('/register', (req, res) => {
    const { username, password } = req.body;
    const db = req.db;

    bcrypt.hash(password, 10, (err, hash) => {
        if (err) {
            return res.render('auth/register', { error: 'Error creating account' });
        }

        const query = `INSERT INTO users (username, password) VALUES ('${username}', '${hash}')`;
        
        db.run(query, function(err) {
            if (err) {
                return res.render('auth/register', { 
                    error: 'Username already exists or other error occurred' 
                });
            }
            
            req.session.user = {
                id: this.lastID,
                username: username
            };
            res.redirect('/');
        });
    });
});

router.get('/login', (req, res) => {
    res.render('auth/login', { error: null });
});

router.post('/login', (req, res) => {
    const { username, password } = req.body;
    const db = req.db;

    const query = `SELECT * FROM users WHERE username = '${username}'`;
    db.get(query, (err, user) => {
        if (err || !user) {
            return res.render('auth/login', { error: 'Invalid username or password' });
        }

        bcrypt.compare(password, user.password, (err, match) => {
            if (err || !match) {
                return res.render('auth/login', { error: 'Invalid username or password' });
            }

            req.session.user = {
                id: user.id,
                username: user.username
            };
            res.redirect('/');
        });
    });
});

router.get('/logout', (req, res) => {
    req.session.destroy();
    res.redirect('/');
});

module.exports = router;
