const express = require('express');
const router = express.Router();
const seedrandom = require('seedrandom');

function generateId(userId, timestamp) {
    const timestampSeconds = Math.floor(timestamp / 1000);
    const rng = seedrandom(userId + timestampSeconds.toString());
    const chars = '0123456789abcdef';
    let result = '';
    for (let i = 0; i < 8; i++) {
        result += chars[Math.floor(rng() * chars.length)];
    }
    return result;
}

const requireLogin = (req, res, next) => {
    if (!req.session.user) {
        return res.redirect('/auth/login');
    }
    next();
};

router.get('/new', requireLogin, (req, res) => {
    res.render('snippets/new', { error: null });
});

// create new snippet
router.post('/', requireLogin, (req, res) => {
    const { title, content, language, is_public } = req.body;
    const userId = req.session.user.id;
    const db = req.db;

    const timestamp = Date.now();
    const snippetId = generateId(userId, timestamp);
    const query = `
        INSERT INTO snippets (id, title, content, language, is_public, user_id) 
        VALUES ('${snippetId}', '${title}', '${content}', '${language}', ${is_public ? 1 : 0}, ${userId})
    `;

    db.run(query, function(err) {
        if (err) {
            return res.render('snippets/new', { error: 'Error creating snippet' });
        }
        res.redirect(`/snippets/${snippetId}`);
    });
});

// view snippet
router.get('/:id', (req, res) => {
    const snippetId = req.params.id;
    const db = req.db;
    const userId = req.session.user ? req.session.user.id : null;

    const query = `
        SELECT s.*, u.username 
        FROM snippets s 
        JOIN users u ON s.user_id = u.id 
        WHERE s.id = '${req.params.id}'
    `;

    db.get(query, (err, snippet) => {
        if (err || !snippet) {
            return res.status(404).send('Snippet not found');
        }

        res.render('snippets/view', { 
            snippet,
            user: req.session.user,
            req: req
        });
    });
});

// list a user's snippets
router.get('/user/my-snippets', requireLogin, (req, res) => {
    const userId = req.session.user.id;
    const db = req.db;

    const query = `
        SELECT * FROM snippets 
        WHERE user_id = ${userId} 
        ORDER BY created_at DESC
    `;

    db.all(query, (err, snippets) => {
        if (err) {
            return res.status(500).send('Error fetching snippets');
        }

        res.render('snippets/my-snippets', {
            snippets,
            user: req.session.user
        });
    });
});

module.exports = router;
